/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram2D
extends FloatHistogram
implements FloatIHistogram2D {
    private static final long serialVersionUID = 1L;
    protected FloatIAxis xAxis;
    protected FloatIAxis yAxis;

    FloatAbstractHistogram2D(String title) {
        super(title);
    }

    public int allEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public int binEntriesX(int indexX) {
        return this.projectionX().binEntries(indexX);
    }

    public int binEntriesY(int indexY) {
        return this.projectionY().binEntries(indexY);
    }

    public float binHeightX(int indexX) {
        return this.projectionX().binHeight(indexX);
    }

    public float binHeightY(int indexY) {
        return this.projectionY().binHeight(indexY);
    }

    public int dimensions() {
        return 2;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(float x, float y) {
        this.fill(x, y, 1.0f);
    }

    protected abstract FloatIHistogram1D internalSliceX(String var1, int var2, int var3);

    protected abstract FloatIHistogram1D internalSliceY(String var1, int var2, int var3);

    int mapX(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapY(int index) {
        int bins = this.yAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public int[] minMaxBins() {
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        int minBinX = -1;
        int minBinY = -1;
        int maxBinX = -1;
        int maxBinY = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            int j = this.yAxis.bins();
            while (--j >= 0) {
                float value = this.binHeight(i, j);
                if (value < minValue) {
                    minValue = value;
                    minBinX = i;
                    minBinY = j;
                }
                if (!(value > maxValue)) continue;
                maxValue = value;
                maxBinX = i;
                maxBinY = j;
            }
        }
        int[] result = new int[]{minBinX, minBinY, maxBinX, maxBinY};
        return result;
    }

    public FloatIHistogram1D projectionX() {
        String newTitle = this.title() + " (projectionX)";
        return this.internalSliceX(newTitle, this.mapY(-2), this.mapY(-1));
    }

    public FloatIHistogram1D projectionY() {
        String newTitle = this.title() + " (projectionY)";
        return this.internalSliceY(newTitle, this.mapX(-2), this.mapX(-1));
    }

    public FloatIHistogram1D sliceX(int indexY) {
        int start = this.mapY(indexY);
        String newTitle = this.title() + " (sliceX [" + indexY + "])";
        return this.internalSliceX(newTitle, start, start);
    }

    public FloatIHistogram1D sliceX(int indexY1, int indexY2) {
        int start = this.mapY(indexY1);
        int stop = this.mapY(indexY2);
        String newTitle = this.title() + " (sliceX [" + indexY1 + ":" + indexY2 + "])";
        return this.internalSliceX(newTitle, start, stop);
    }

    public FloatIHistogram1D sliceY(int indexX) {
        int start = this.mapX(indexX);
        String newTitle = this.title() + " (sliceY [" + indexX + "])";
        return this.internalSliceY(newTitle, start, start);
    }

    public FloatIHistogram1D sliceY(int indexX1, int indexX2) {
        int start = this.mapX(indexX1);
        int stop = this.mapX(indexX2);
        String newTitle = this.title() + " (slicey [" + indexX1 + ":" + indexX2 + "])";
        return this.internalSliceY(newTitle, start, stop);
    }

    public float sumAllBinHeights() {
        float n = 0.0f;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                n += this.binHeight(i, j);
            }
        }
        return n;
    }

    public float sumBinHeights() {
        float n = 0.0f;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                n += this.binHeight(i, j);
            }
        }
        return n;
    }

    public float sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }

    public FloatIAxis yAxis() {
        return this.yAxis;
    }
}

