/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.buffer.tfloat.FloatBuffer;
import cern.colt.buffer.tfloat.FloatBufferConsumer;
import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin;

public abstract class AbstractFloatBin1D
extends AbstractFloatBin
implements FloatBufferConsumer {
    private static final long serialVersionUID = 1L;

    protected AbstractFloatBin1D() {
    }

    public abstract void add(float var1);

    public final synchronized void addAllOf(FloatArrayList list) {
        this.addAllOfFromTo(list, 0, list.size() - 1);
    }

    public synchronized void addAllOfFromTo(FloatArrayList list, int from, int to) {
        for (int i = from; i <= to; ++i) {
            this.add(list.getQuick(i));
        }
    }

    public synchronized FloatBuffer buffered(int capacity) {
        return new FloatBuffer(this, capacity);
    }

    public String compareWith(AbstractFloatBin1D other) {
        StringBuffer buf = new StringBuffer();
        buf.append("\nDifferences [percent]");
        buf.append("\nSize: " + this.relError(this.size(), other.size()) + " %");
        buf.append("\nSum: " + this.relError(this.sum(), other.sum()) + " %");
        buf.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), other.sumOfSquares()) + " %");
        buf.append("\nMin: " + this.relError(this.min(), other.min()) + " %");
        buf.append("\nMax: " + this.relError(this.max(), other.max()) + " %");
        buf.append("\nMean: " + this.relError(this.mean(), other.mean()) + " %");
        buf.append("\nRMS: " + this.relError(this.rms(), other.rms()) + " %");
        buf.append("\nVariance: " + this.relError(this.variance(), other.variance()) + " %");
        buf.append("\nStandard deviation: " + this.relError(this.standardDeviation(), other.standardDeviation()) + " %");
        buf.append("\nStandard error: " + this.relError(this.standardError(), other.standardError()) + " %");
        buf.append("\n");
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractFloatBin1D)) {
            return false;
        }
        AbstractFloatBin1D other = (AbstractFloatBin1D)object;
        return this.size() == other.size() && this.min() == other.min() && this.max() == other.max() && this.sum() == other.sum() && this.sumOfSquares() == other.sumOfSquares();
    }

    public abstract float max();

    public synchronized float mean() {
        return this.sum() / (float)this.size();
    }

    public abstract float min();

    protected float relError(float measure1, float measure2) {
        return 100.0f * (1.0f - measure1 / measure2);
    }

    public synchronized float rms() {
        return FloatDescriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized float standardDeviation() {
        return (float)Math.sqrt(this.variance());
    }

    public synchronized float standardError() {
        return FloatDescriptive.standardError(this.size(), this.variance());
    }

    public abstract float sum();

    public abstract float sumOfSquares();

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("\n-------------");
        buf.append("\nSize: " + this.size());
        buf.append("\nSum: " + this.sum());
        buf.append("\nSumOfSquares: " + this.sumOfSquares());
        buf.append("\nMin: " + this.min());
        buf.append("\nMax: " + this.max());
        buf.append("\nMean: " + this.mean());
        buf.append("\nRMS: " + this.rms());
        buf.append("\nVariance: " + this.variance());
        buf.append("\nStandard deviation: " + this.standardDeviation());
        buf.append("\nStandard error: " + this.standardError());
        buf.append("\n");
        return buf.toString();
    }

    public synchronized void trimToSize() {
    }

    public synchronized float variance() {
        return FloatDescriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

