/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_dump;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;

public class Dklu_sort
extends Dklu_internal {
    public static void sort(int n, int[] Xip, int Xip_offset, int[] Xlen, int Xlen_offset, double[] LU, int[] Tp, int[] Tj, double[] Tx, int[] W) {
        int p;
        double[] Xi;
        double[] Xx;
        int j;
        int i;
        int[] len = new int[1];
        int[] Xi_offset = new int[1];
        int[] Xx_offset = new int[1];
        Dklu_sort.ASSERT(Dklu_dump.klu_valid_LU(n, 0, Xip, Xip_offset, Xlen, Xlen_offset, LU));
        for (i = 0; i < n; ++i) {
            W[i] = 0;
        }
        for (j = 0; j < n; ++j) {
            Xi = Xx = Dklu_sort.GET_POINTER(LU, Xip, Xip_offset, Xlen, Xlen_offset, Xi_offset, Xx_offset, j, len);
            for (p = 0; p < len[0]; ++p) {
                int n2 = (int)Xi[Xi_offset[0] + p];
                W[n2] = W[n2] + 1;
            }
        }
        int nz = 0;
        for (i = 0; i < n; ++i) {
            Tp[i] = nz;
            nz += W[i];
        }
        Tp[n] = nz;
        for (i = 0; i < n; ++i) {
            W[i] = Tp[i];
        }
        for (j = 0; j < n; ++j) {
            Xi = Xx = Dklu_sort.GET_POINTER(LU, Xip, Xip_offset, Xlen, Xlen_offset, Xi_offset, Xx_offset, j, len);
            for (p = 0; p < len[0]; ++p) {
                int n3 = (int)Xi[Xi_offset[0] + p];
                W[n3] = W[n3] + 1;
                Tj[tp] = j;
                Tx[tp] = Xx[Xx_offset[0] + p];
            }
        }
        for (j = 0; j < n; ++j) {
            W[j] = 0;
        }
        for (i = 0; i < n; ++i) {
            int pend = Tp[i + 1];
            for (p = Tp[i]; p < pend; ++p) {
                j = Tj[p];
                Xi = Xx = Dklu_sort.GET_POINTER(LU, Xip, Xip_offset, Xlen, Xlen_offset, Xi_offset, Xx_offset, j, len);
                int n4 = j;
                W[n4] = W[n4] + 1;
                Xi[Xi_offset[0] + xlen] = i;
                Xx[Xx_offset[0] + xlen] = Tx[p];
            }
        }
        Dklu_sort.ASSERT(Dklu_dump.klu_valid_LU(n, 0, Xip, Xip_offset, Xlen, Xlen_offset, LU));
    }

    public static int klu_sort(KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        if (Common == null) {
            return 0;
        }
        Common.status = 0;
        int[] R = Symbolic.R;
        int nblocks = Symbolic.nblocks;
        int maxblock = Symbolic.maxblock;
        int[] Lip = Numeric.Lip;
        int[] Llen = Numeric.Llen;
        int[] Uip = Numeric.Uip;
        int[] Ulen = Numeric.Ulen;
        double[][] LUbx = Numeric.LUbx;
        int m1 = maxblock + 1;
        int nz = Dklu_sort.MAX(Numeric.max_lnz_block, Numeric.max_unz_block);
        int[] W = Dklu_memory.klu_malloc_int(maxblock, Common);
        int[] Tp = Dklu_memory.klu_malloc_int(m1, Common);
        int[] Ti = Dklu_memory.klu_malloc_int(nz, Common);
        double[] Tx = Dklu_memory.klu_malloc_dbl(nz, Common);
        Dklu_sort.PRINTF("\n======================= Start sort:\n", new Object[0]);
        if (Common.status == 0) {
            for (int block = 0; block < nblocks; ++block) {
                int k1 = R[block];
                int nk = R[block + 1] - k1;
                if (nk <= 1) continue;
                Dklu_sort.PRINTF("\n-------------------block: %d nk %d\n", block, nk);
                Dklu_sort.sort(nk, Lip, k1, Llen, k1, LUbx[block], Tp, Ti, Tx, W);
                Dklu_sort.sort(nk, Uip, k1, Ulen, k1, LUbx[block], Tp, Ti, Tx, W);
            }
        }
        Dklu_sort.PRINTF("\n======================= sort done.\n", new Object[0]);
        W = null;
        Tp = null;
        Ti = null;
        Tx = null;
        return Common.status == 0 ? 1 : 0;
    }
}

