/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu;
import edu.ufl.cise.klu.tdouble.Dklu_dump;
import edu.ufl.cise.klu.tdouble.Dklu_internal;

public class Dklu_solve
extends Dklu_internal {
    public static int klu_solve(KLU_symbolic Symbolic, KLU_numeric Numeric, int d, int nrhs, double[] B, int B_offset, KLU_common Common) {
        double[] x = new double[4];
        if (Common == null) {
            return 0;
        }
        if (Numeric == null || Symbolic == null || d < Symbolic.n || nrhs < 0 || B == null) {
            Common.status = -3;
            return 0;
        }
        Common.status = 0;
        double[] Bz = B;
        int n = Symbolic.n;
        int nblocks = Symbolic.nblocks;
        int[] Q = Symbolic.Q;
        int[] R = Symbolic.R;
        Dklu_solve.ASSERT(nblocks == Numeric.nblocks);
        int[] Pnum = Numeric.Pnum;
        int[] Offp = Numeric.Offp;
        int[] Offi = Numeric.Offi;
        double[] Offx = Numeric.Offx;
        int[] Lip = Numeric.Lip;
        int[] Llen = Numeric.Llen;
        int[] Uip = Numeric.Uip;
        int[] Ulen = Numeric.Ulen;
        double[][] LUbx = Numeric.LUbx;
        double[] Udiag = Numeric.Udiag;
        double[] Rs = Numeric.Rs;
        double[] X = Numeric.Xwork;
        if (!NDEBUG) {
            Dklu_solve.ASSERT(Dklu_dump.klu_valid(n, Offp, Offi, Offx));
        }
        for (int chunk = 0; chunk < nrhs; chunk += 4) {
            int i;
            int k;
            int nr = Dklu_solve.MIN(nrhs - chunk, 4);
            if (Rs == null) {
                switch (nr) {
                    case 1: {
                        for (k = 0; k < n; ++k) {
                            X[k] = Bz[B_offset + Pnum[k]];
                        }
                        break;
                    }
                    case 2: {
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            X[2 * k] = Bz[B_offset + i];
                            X[2 * k + 1] = Bz[B_offset + i + d];
                        }
                        break;
                    }
                    case 3: {
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            X[3 * k] = Bz[B_offset + i];
                            X[3 * k + 1] = Bz[B_offset + i + d];
                            X[3 * k + 2] = Bz[B_offset + i + d * 2];
                        }
                        break;
                    }
                    case 4: {
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            X[4 * k] = Bz[B_offset + i];
                            X[4 * k + 1] = Bz[B_offset + i + d];
                            X[4 * k + 2] = Bz[B_offset + i + d * 2];
                            X[4 * k + 3] = Bz[B_offset + i + d * 3];
                        }
                        break;
                    }
                }
            } else {
                switch (nr) {
                    case 1: {
                        for (k = 0; k < n; ++k) {
                            X[k] = Bz[B_offset + Pnum[k]] / Rs[k];
                        }
                        break;
                    }
                    case 2: {
                        double rs;
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            rs = Rs[k];
                            X[2 * k] = Bz[B_offset + i] / rs;
                            X[2 * k + 1] = Bz[B_offset + i + d] / rs;
                        }
                        break;
                    }
                    case 3: {
                        double rs;
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            rs = Rs[k];
                            X[3 * k] = Bz[B_offset + i] / rs;
                            X[3 * k + 1] = Bz[B_offset + i + d] / rs;
                            X[3 * k + 2] = Bz[B_offset + i + d * 2] / rs;
                        }
                        break;
                    }
                    case 4: {
                        double rs;
                        for (k = 0; k < n; ++k) {
                            i = Pnum[k];
                            rs = Rs[k];
                            X[4 * k] = Bz[B_offset + i] / rs;
                            X[4 * k + 1] = Bz[B_offset + i + d] / rs;
                            X[4 * k + 2] = Bz[B_offset + i + d * 2] / rs;
                            X[4 * k + 3] = Bz[B_offset + i + d * 3] / rs;
                        }
                        break;
                    }
                }
            }
            block39: for (int block = nblocks - 1; block >= 0; --block) {
                int k1 = R[block];
                int k2 = R[block + 1];
                int nk = k2 - k1;
                Dklu_solve.PRINTF("solve %d, k1 %d k2-1 %d nk %d\n", block, k1, k2 - 1, nk);
                if (nk == 1) {
                    double s = Udiag[k1];
                    switch (nr) {
                        case 1: {
                            X[k1] = X[k1] / s;
                            break;
                        }
                        case 2: {
                            X[2 * k1] = X[2 * k1] / s;
                            X[2 * k1 + 1] = X[2 * k1 + 1] / s;
                            break;
                        }
                        case 3: {
                            X[3 * k1] = X[3 * k1] / s;
                            X[3 * k1 + 1] = X[3 * k1 + 1] / s;
                            X[3 * k1 + 2] = X[3 * k1 + 2] / s;
                            break;
                        }
                        case 4: {
                            X[4 * k1] = X[4 * k1] / s;
                            X[4 * k1 + 1] = X[4 * k1 + 1] / s;
                            X[4 * k1 + 2] = X[4 * k1 + 2] / s;
                            X[4 * k1 + 3] = X[4 * k1 + 3] / s;
                        }
                    }
                } else {
                    Dklu.klu_lsolve(nk, Lip, k1, Llen, k1, LUbx[block], nr, X, nr * k1);
                    Dklu.klu_usolve(nk, Uip, k1, Ulen, k1, LUbx[block], Udiag, k1, nr, X, nr * k1);
                }
                if (block <= 0) continue;
                switch (nr) {
                    case 1: {
                        int p;
                        int pend;
                        for (k = k1; k < k2; ++k) {
                            pend = Offp[k + 1];
                            x[0] = X[k];
                            for (p = Offp[k]; p < pend; ++p) {
                                int n2 = Offi[p];
                                X[n2] = X[n2] - Offx[p] * x[0];
                            }
                        }
                        continue block39;
                    }
                    case 2: {
                        double offik;
                        int p;
                        int pend;
                        for (k = k1; k < k2; ++k) {
                            pend = Offp[k + 1];
                            x[0] = X[2 * k];
                            x[1] = X[2 * k + 1];
                            for (p = Offp[k]; p < pend; ++p) {
                                i = Offi[p];
                                offik = Offx[p];
                                int n3 = 2 * i;
                                X[n3] = X[n3] - offik * x[0];
                                int n4 = 2 * i + 1;
                                X[n4] = X[n4] - offik * x[1];
                            }
                        }
                        continue block39;
                    }
                    case 3: {
                        double offik;
                        int p;
                        int pend;
                        for (k = k1; k < k2; ++k) {
                            pend = Offp[k + 1];
                            x[0] = X[3 * k];
                            x[1] = X[3 * k + 1];
                            x[2] = X[3 * k + 2];
                            for (p = Offp[k]; p < pend; ++p) {
                                i = Offi[p];
                                offik = Offx[p];
                                int n5 = 3 * i;
                                X[n5] = X[n5] - offik * x[0];
                                int n6 = 3 * i + 1;
                                X[n6] = X[n6] - offik * x[1];
                                int n7 = 3 * i + 2;
                                X[n7] = X[n7] - offik * x[2];
                            }
                        }
                        continue block39;
                    }
                    case 4: {
                        double offik;
                        int p;
                        int pend;
                        for (k = k1; k < k2; ++k) {
                            pend = Offp[k + 1];
                            x[0] = X[4 * k];
                            x[1] = X[4 * k + 1];
                            x[2] = X[4 * k + 2];
                            x[3] = X[4 * k + 3];
                            for (p = Offp[k]; p < pend; ++p) {
                                i = Offi[p];
                                offik = Offx[p];
                                int n8 = 4 * i;
                                X[n8] = X[n8] - offik * x[0];
                                int n9 = 4 * i + 1;
                                X[n9] = X[n9] - offik * x[1];
                                int n10 = 4 * i + 2;
                                X[n10] = X[n10] - offik * x[2];
                                int n11 = 4 * i + 3;
                                X[n11] = X[n11] - offik * x[3];
                            }
                        }
                        continue block39;
                    }
                }
            }
            switch (nr) {
                case 1: {
                    for (k = 0; k < n; ++k) {
                        Bz[B_offset + Q[k]] = X[k];
                    }
                    break;
                }
                case 2: {
                    for (k = 0; k < n; ++k) {
                        i = Q[k];
                        Bz[B_offset + i] = X[2 * k];
                        Bz[B_offset + i + d] = X[2 * k + 1];
                    }
                    break;
                }
                case 3: {
                    for (k = 0; k < n; ++k) {
                        i = Q[k];
                        Bz[B_offset + i] = X[3 * k];
                        Bz[B_offset + i + d] = X[3 * k + 1];
                        Bz[B_offset + i + d * 2] = X[3 * k + 2];
                    }
                    break;
                }
                case 4: {
                    for (k = 0; k < n; ++k) {
                        i = Q[k];
                        Bz[B_offset + i] = X[4 * k];
                        Bz[B_offset + i + d] = X[4 * k + 1];
                        Bz[B_offset + i + d * 2] = X[4 * k + 2];
                        Bz[B_offset + i + d * 3] = X[4 * k + 3];
                    }
                    break;
                }
            }
            B_offset += d * 4;
        }
        return 1;
    }
}

