/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.amd.tdouble.Damd_order;
import edu.ufl.cise.btf.tdouble.Dbtf;
import edu.ufl.cise.btf.tdouble.Dbtf_order;
import edu.ufl.cise.colamd.tdouble.Dcolamd;
import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_analyze_given;
import edu.ufl.cise.klu.tdouble.Dklu_dump;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;

public class Dklu_analyze
extends Dklu_internal {
    public static int analyze_worker(int n, int[] Ap, int[] Ai, int nblocks, int[] Pbtf, int[] Qbtf, int[] R, int ordering, int[] P, int[] Q, double[] Lnz, int[] Pblk, int[] Cp, int[] Ci, int Cilen, int[] Pinv, KLU_symbolic Symbolic, KLU_common Common) {
        int k;
        double[] amd_Info = new double[20];
        int err = -3;
        int[] cstats = new int[Dcolamd.COLAMD_STATS];
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                P[k] = -1;
                Q[k] = -1;
                Pinv[k] = -1;
            }
        }
        for (k = 0; k < n; ++k) {
            Dklu_analyze.ASSERT(Pbtf[k] >= 0 && Pbtf[k] < n);
            Pinv[Pbtf[k]] = k;
        }
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Dklu_analyze.ASSERT(Pinv[k] != -1);
            }
        }
        int nzoff = 0;
        double lnz = 0.0;
        int maxnz = 0;
        double flops = 0.0;
        Symbolic.symmetry = -1.0;
        for (int block = 0; block < nblocks; ++block) {
            int ok;
            double flops1;
            double lnz1;
            int k1 = R[block];
            int k2 = R[block + 1];
            int nk = k2 - k1;
            Dklu_analyze.PRINTF("BLOCK %d, k1 %d k2-1 %d nk %d\n", block, k1, k2 - 1, nk);
            Lnz[block] = -1.0;
            int pc = 0;
            for (k = k1; k < k2; ++k) {
                int newcol = k - k1;
                Cp[newcol] = pc;
                int oldcol = Qbtf[k];
                int pend = Ap[oldcol + 1];
                for (int p = Ap[oldcol]; p < pend; ++p) {
                    int newrow = Pinv[Ai[p]];
                    if (newrow < k1) {
                        ++nzoff;
                        continue;
                    }
                    Dklu_analyze.ASSERT(newrow < k2);
                    Ci[pc++] = newrow -= k1;
                }
            }
            Cp[nk] = pc;
            maxnz = Dklu_analyze.MAX(maxnz, pc);
            if (!NDEBUG) {
                Dklu_analyze.ASSERT(Dklu_dump.klu_valid(nk, Cp, Ci, null));
            }
            if (nk <= 3) {
                for (k = 0; k < nk; ++k) {
                    Pblk[k] = k;
                }
                lnz1 = nk * (nk + 1) / 2;
                flops1 = nk * (nk - 1) / 2 + (nk - 1) * nk * (2 * nk - 1) / 6;
                ok = 1;
            } else if (ordering == 0) {
                int result = Damd_order.amd_order(nk, Cp, Ci, Pblk, null, amd_Info);
                int n2 = ok = result >= 0 ? 1 : 0;
                if (result == -1) {
                    err = -2;
                }
                Common.mempeak = Dklu_analyze.MAX(Common.mempeak, Common.memusage + (long)amd_Info[7]);
                lnz1 = (int)amd_Info[9] + nk;
                flops1 = 2.0 * amd_Info[12] + amd_Info[10];
                if (pc == maxnz) {
                    Symbolic.symmetry = amd_Info[3];
                }
            } else if (ordering == 1) {
                ok = Dcolamd.colamd(nk, nk, Cilen, Ci, Cp, null, cstats);
                lnz1 = -1.0;
                flops1 = -1.0;
                for (k = 0; k < nk; ++k) {
                    Pblk[k] = Cp[k];
                }
            } else {
                lnz1 = Common.user_order.order(nk, Cp, Ci, Pblk, Common);
                flops1 = -1.0;
                int n3 = ok = lnz1 != 0.0 ? 1 : 0;
            }
            if (ok != 1) {
                return err;
            }
            Lnz[block] = lnz1;
            lnz = lnz == -1.0 || lnz1 == -1.0 ? -1.0 : lnz + lnz1;
            flops = flops == -1.0 || flops1 == -1.0 ? -1.0 : flops + flops1;
            Dklu_analyze.PRINTF("Pblk, 1-based:\n", new Object[0]);
            for (k = 0; k < nk; ++k) {
                Dklu_analyze.ASSERT(k + k1 < n);
                Dklu_analyze.ASSERT(Pblk[k] + k1 < n);
                Q[k + k1] = Qbtf[Pblk[k] + k1];
            }
            for (k = 0; k < nk; ++k) {
                Dklu_analyze.ASSERT(k + k1 < n);
                Dklu_analyze.ASSERT(Pblk[k] + k1 < n);
                P[k + k1] = Pbtf[Pblk[k] + k1];
            }
        }
        Dklu_analyze.PRINTF("nzoff %d  Ap[n] %d\n", nzoff, Ap[n]);
        Dklu_analyze.ASSERT(nzoff >= 0 && nzoff <= Ap[n]);
        Symbolic.lnz = lnz;
        Symbolic.unz = lnz;
        Symbolic.nzoff = nzoff;
        Symbolic.est_flops = flops;
        return 0;
    }

    public static KLU_symbolic order_and_analyze(int n, int[] Ap, int[] Ai, KLU_common Common) {
        int maxblock;
        int nblocks;
        int Cilen;
        double[] work = new double[1];
        int[] structural_rank = new int[1];
        KLU_symbolic Symbolic = Dklu_analyze_given.klu_alloc_symbolic(n, Ap, Ai, Common);
        if (Symbolic == null) {
            return null;
        }
        int[] P = Symbolic.P;
        int[] Q = Symbolic.Q;
        int[] R = Symbolic.R;
        double[] Lnz = Symbolic.Lnz;
        int nz = Symbolic.nz;
        int ordering = Common.ordering;
        if (ordering == 1) {
            Cilen = Dcolamd.COLAMD_recommended(nz, n, n);
        } else if (ordering == 0 || ordering == 3 && Common.user_order != null) {
            Cilen = nz + 1;
        } else {
            Common.status = -3;
            Symbolic = null;
            return null;
        }
        int[] Pbtf = Dklu_memory.klu_malloc_int(n, Common);
        int[] Qbtf = Dklu_memory.klu_malloc_int(n, Common);
        if (Common.status < 0) {
            Pbtf = null;
            Qbtf = null;
            Symbolic = null;
            return null;
        }
        int do_btf = Common.btf;
        do_btf = do_btf != 0 ? 1 : 0;
        Symbolic.ordering = ordering;
        Symbolic.do_btf = do_btf;
        Symbolic.structural_rank = -1;
        Common.work = 0.0;
        if (do_btf != 0) {
            if (Common.status < 0) {
                Pbtf = null;
                Qbtf = null;
                Symbolic = null;
                return null;
            }
            nblocks = Dbtf_order.btf_order(n, Ap, Ai, Common.maxwork, work, Pbtf, Qbtf, R, structural_rank);
            Common.structural_rank = Symbolic.structural_rank = structural_rank[0];
            Common.work += work[0];
            if (Symbolic.structural_rank < n) {
                for (int k = 0; k < n; ++k) {
                    Qbtf[k] = Dbtf.BTF_UNFLIP(Qbtf[k]);
                }
            }
            maxblock = 1;
            for (int block = 0; block < nblocks; ++block) {
                int k1 = R[block];
                int k2 = R[block + 1];
                int nk = k2 - k1;
                Dklu_analyze.PRINTF("block %d size %d\n", block, nk);
                maxblock = Dklu_analyze.MAX(maxblock, nk);
            }
        } else {
            nblocks = 1;
            maxblock = n;
            R[0] = 0;
            R[1] = n;
            for (int k = 0; k < n; ++k) {
                Pbtf[k] = k;
                Qbtf[k] = k;
            }
        }
        Symbolic.nblocks = nblocks;
        Dklu_analyze.PRINTF("maxblock size %d\n", maxblock);
        Symbolic.maxblock = maxblock;
        int[] Pblk = Dklu_memory.klu_malloc_int(maxblock, Common);
        int[] Cp = Dklu_memory.klu_malloc_int(maxblock + 1, Common);
        int[] Ci = Dklu_memory.klu_malloc_int(Dklu_analyze.MAX(Cilen, nz + 1), Common);
        int[] Pinv = Dklu_memory.klu_malloc_int(n, Common);
        if (Common.status == 0) {
            Dklu_analyze.PRINTF("calling analyze_worker\n", new Object[0]);
            Common.status = Dklu_analyze.analyze_worker(n, Ap, Ai, nblocks, Pbtf, Qbtf, R, ordering, P, Q, Lnz, Pblk, Cp, Ci, Cilen, Pinv, Symbolic, Common);
            Dklu_analyze.PRINTF("analyze_worker done\n", new Object[0]);
        }
        Qbtf = null;
        Pbtf = null;
        Pinv = null;
        Ci = null;
        Cp = null;
        Pblk = null;
        if (Common.status < 0) {
            Symbolic = null;
        }
        return Symbolic;
    }

    public static KLU_symbolic klu_analyze(int n, int[] Ap, int[] Ai, KLU_common Common) {
        if (Common == null) {
            return null;
        }
        Common.status = 0;
        Common.structural_rank = -1;
        if (Common.ordering == 2) {
            return Dklu_analyze_given.klu_analyze_given(n, Ap, Ai, null, null, Common);
        }
        return Dklu_analyze.order_and_analyze(n, Ap, Ai, Common);
    }
}

