/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_kernel;
import edu.ufl.cise.klu.tdouble.Dklu_memory;

public class Dklu
extends Dklu_internal {
    public static int klu_kernel_factor(int n, int[] Ap, int[] Ai, double[] Ax, int[] Q, double Lsize, double[][] p_LU, int block, double[] Udiag, int Udiag_offset, int[] Llen, int Llen_offset, int[] Ulen, int Ulen_offset, int[] Lip, int Lip_offset, int[] Uip, int Uip_offset, int[] P, int[] lnz, int[] unz, double[] X, int[] Work, int k1, int[] PSinv, double[] Rs, int[] Offp, int[] Offi, double[] Offx, KLU_common Common) {
        int lsize;
        double[][] LU = new double[1][];
        Dklu.ASSERT(Common != null);
        n = Dklu.MAX(1, n);
        int anz = Ap[n + k1] - Ap[k1];
        if (Lsize <= 0.0) {
            Lsize = -Lsize;
            Lsize = Dklu.MAX(Lsize, 1.0);
            lsize = (int)(Lsize * (double)anz + (double)n);
        } else {
            lsize = (int)Lsize;
        }
        int usize = lsize;
        lsize = Dklu.MAX(n + 1, lsize);
        usize = Dklu.MAX(n + 1, usize);
        double maxlnz = ((double)n * (double)n + (double)n) / 2.0;
        maxlnz = Dklu.MIN(maxlnz, 2.147483647E9);
        lsize = Dklu.MIN((int)maxlnz, lsize);
        usize = Dklu.MIN((int)maxlnz, usize);
        Dklu.PRINTF("Welcome to klu: n %d anz %d k1 %d lsize %d usize %d maxlnz %g\n", n, anz, k1, lsize, usize, maxlnz);
        p_LU[block] = null;
        int[] Pinv = new int[n];
        int[] Stack2 = new int[n];
        int[] Flag = new int[n];
        int[] Lpend = new int[n];
        int[] Ap_pos = new int[n];
        double dunits = lsize + lsize + usize + usize;
        int lusize = (int)dunits;
        boolean ok = !Dklu.INT_OVERFLOW(dunits);
        double[] dArray = LU[0] = ok ? Dklu_memory.klu_malloc_dbl(lusize, Common) : null;
        if (LU[0] == null) {
            Common.status = -2;
            lusize = 0;
            return lusize;
        }
        lusize = Dklu_kernel.klu_kernel(n, Ap, Ai, Ax, Q, lusize, Pinv, P, LU, Udiag, Udiag_offset, Llen, Llen_offset, Ulen, Ulen_offset, Lip, Lip_offset, Uip, Uip_offset, lnz, unz, X, Stack2, Flag, Ap_pos, Lpend, k1, PSinv, Rs, Offp, Offi, Offx, Common);
        if (Common.status < 0) {
            LU[0] = null;
            lusize = 0;
        }
        p_LU[block] = LU[0];
        Dklu.PRINTF(" in klu noffdiag %d\n", Common.noffdiag);
        return lusize;
    }

    public static void klu_lsolve(int n, int[] Lip, int Lip_offset, int[] Llen, int Llen_offset, double[] LU, int nrhs, double[] X, int X_offset) {
        double[] x = new double[4];
        int[] len = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        switch (nrhs) {
            case 1: {
                for (int k = 0; k < n; ++k) {
                    double[] Lx;
                    x[0] = X[X_offset + k];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int n2 = X_offset + (int)Li[Li_offset[0] + p];
                        X[n2] = X[n2] - Lx[Lx_offset[0] + p] * x[0];
                    }
                }
                break;
            }
            case 2: {
                for (int k = 0; k < n; ++k) {
                    double[] Lx;
                    x[0] = X[X_offset + 2 * k];
                    x[1] = X[X_offset + 2 * k + 1];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        int n3 = X_offset + 2 * i;
                        X[n3] = X[n3] - lik * x[0];
                        int n4 = X_offset + 2 * i + 1;
                        X[n4] = X[n4] - lik * x[1];
                    }
                }
                break;
            }
            case 3: {
                for (int k = 0; k < n; ++k) {
                    double[] Lx;
                    x[0] = X[X_offset + 3 * k];
                    x[1] = X[X_offset + 3 * k + 1];
                    x[2] = X[X_offset + 3 * k + 2];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        int n5 = X_offset + 3 * i;
                        X[n5] = X[n5] - lik * x[0];
                        int n6 = X_offset + 3 * i + 1;
                        X[n6] = X[n6] - lik * x[1];
                        int n7 = X_offset + 3 * i + 2;
                        X[n7] = X[n7] - lik * x[2];
                    }
                }
                break;
            }
            case 4: {
                for (int k = 0; k < n; ++k) {
                    double[] Lx;
                    x[0] = X[X_offset + 4 * k];
                    x[1] = X[X_offset + 4 * k + 1];
                    x[2] = X[X_offset + 4 * k + 2];
                    x[3] = X[X_offset + 4 * k + 3];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        int n8 = X_offset + 4 * i;
                        X[n8] = X[n8] - lik * x[0];
                        int n9 = X_offset + 4 * i + 1;
                        X[n9] = X[n9] - lik * x[1];
                        int n10 = X_offset + 4 * i + 2;
                        X[n10] = X[n10] - lik * x[2];
                        int n11 = X_offset + 4 * i + 3;
                        X[n11] = X[n11] - lik * x[3];
                    }
                }
                break;
            }
        }
    }

    public static void klu_usolve(int n, int[] Uip, int Uip_offset, int[] Ulen, int Ulen_offset, double[] LU, double[] Udiag, int Udiag_offset, int nrhs, double[] X, int X_offset) {
        double[] x = new double[4];
        int[] len = new int[1];
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        switch (nrhs) {
            case 1: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    x[0] = X[X_offset + k] / Udiag[Udiag_offset + k];
                    X[X_offset + k] = x[0];
                    for (int p = 0; p < len[0]; ++p) {
                        int n2 = X_offset + (int)Ui[Ui_offset[0] + p];
                        X[n2] = X[n2] - Ux[Ux_offset[0] + p] * x[0];
                    }
                }
                break;
            }
            case 2: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    double ukk = Udiag[Udiag_offset + k];
                    x[0] = X[X_offset + 2 * k] / ukk;
                    x[1] = X[X_offset + 2 * k + 1] / ukk;
                    X[X_offset + 2 * k] = x[0];
                    X[X_offset + 2 * k + 1] = x[1];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        int n3 = X_offset + 2 * i;
                        X[n3] = X[n3] - uik * x[0];
                        int n4 = X_offset + 2 * i + 1;
                        X[n4] = X[n4] - uik * x[1];
                    }
                }
                break;
            }
            case 3: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    double ukk = Udiag[Udiag_offset + k];
                    x[0] = X[X_offset + 3 * k] / ukk;
                    x[1] = X[X_offset + 3 * k + 1] / ukk;
                    x[2] = X[X_offset + 3 * k + 2] / ukk;
                    X[3 * k] = x[0];
                    X[3 * k + 1] = x[1];
                    X[3 * k + 2] = x[2];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        int n5 = X_offset + 3 * i;
                        X[n5] = X[n5] - uik * x[0];
                        int n6 = X_offset + 3 * i + 1;
                        X[n6] = X[n6] - uik * x[1];
                        int n7 = X_offset + 3 * i + 2;
                        X[n7] = X[n7] - uik * x[2];
                    }
                }
                break;
            }
            case 4: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    double ukk = Udiag[Udiag_offset + k];
                    x[0] = X[X_offset + 4 * k] / ukk;
                    x[1] = X[X_offset + 4 * k + 1] / ukk;
                    x[2] = X[X_offset + 4 * k + 2] / ukk;
                    x[3] = X[X_offset + 4 * k + 3] / ukk;
                    X[X_offset + 4 * k] = x[0];
                    X[X_offset + 4 * k + 1] = x[1];
                    X[X_offset + 4 * k + 2] = x[2];
                    X[X_offset + 4 * k + 3] = x[3];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        int n8 = X_offset + 4 * i;
                        X[n8] = X[n8] - uik * x[0];
                        int n9 = X_offset + 4 * i + 1;
                        X[n9] = X[n9] - uik * x[1];
                        int n10 = X_offset + 4 * i + 2;
                        X[n10] = X[n10] - uik * x[2];
                        int n11 = X_offset + 4 * i + 3;
                        X[n11] = X[n11] - uik * x[3];
                    }
                }
                break;
            }
        }
    }

    public static void klu_ltsolve(int n, int[] Lip, int Lip_offset, int[] Llen, int Llen_offset, double[] LU, int nrhs, double[] X, int X_offset) {
        double[] x = new double[4];
        int[] len = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        switch (nrhs) {
            case 1: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Lx;
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    x[0] = X[X_offset + k];
                    for (int p = 0; p < len[0]; ++p) {
                        x[0] = x[0] - Lx[Lx_offset[0] + p] * X[X_offset + (int)Li[Li_offset[0] + p]];
                    }
                    X[X_offset + k] = x[0];
                }
                break;
            }
            case 2: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Lx;
                    x[0] = X[X_offset + 2 * k];
                    x[1] = X[X_offset + 2 * k + 1];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        x[0] = x[0] - lik * X[X_offset + 2 * i];
                        x[1] = x[1] - lik * X[X_offset + 2 * i + 1];
                    }
                    X[X_offset + 2 * k] = x[0];
                    X[X_offset + 2 * k + 1] = x[1];
                }
                break;
            }
            case 3: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Lx;
                    x[0] = X[X_offset + 3 * k];
                    x[1] = X[X_offset + 3 * k + 1];
                    x[2] = X[X_offset + 3 * k + 2];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        x[0] = x[0] - lik * X[X_offset + 3 * i];
                        x[1] = x[1] - lik * X[X_offset + 3 * i + 1];
                        x[2] = x[2] - lik * X[X_offset + 3 * i + 2];
                    }
                    X[X_offset + 3 * k] = x[0];
                    X[X_offset + 3 * k + 1] = x[1];
                    X[X_offset + 3 * k + 2] = x[2];
                }
                break;
            }
            case 4: {
                for (int k = n - 1; k >= 0; --k) {
                    double[] Lx;
                    x[0] = X[X_offset + 4 * k];
                    x[1] = X[X_offset + 4 * k + 1];
                    x[2] = X[X_offset + 4 * k + 2];
                    x[3] = X[X_offset + 4 * k + 3];
                    double[] Li = Lx = Dklu.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, len);
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Li[Li_offset[0] + p];
                        double lik = Lx[Lx_offset[0] + p];
                        x[0] = x[0] - lik * X[X_offset + 4 * i];
                        x[1] = x[1] - lik * X[X_offset + 4 * i + 1];
                        x[2] = x[2] - lik * X[X_offset + 4 * i + 2];
                        x[3] = x[3] - lik * X[X_offset + 4 * i + 3];
                    }
                    X[X_offset + 4 * k] = x[0];
                    X[X_offset + 4 * k + 1] = x[1];
                    X[X_offset + 4 * k + 2] = x[2];
                    X[X_offset + 4 * k + 3] = x[3];
                }
                break;
            }
        }
    }

    public static void klu_utsolve(int n, int[] Uip, int Uip_offset, int[] Ulen, int Ulen_offset, double[] LU, double[] Udiag, int Udiag_offset, int nrhs, double[] X, int X_offset) {
        double[] x = new double[4];
        int[] len = new int[1];
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        switch (nrhs) {
            case 1: {
                for (int k = 0; k < n; ++k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    x[0] = X[X_offset + k];
                    for (int p = 0; p < len[0]; ++p) {
                        x[0] = x[0] - Ux[Ux_offset[0] + p] * X[X_offset + (int)Ui[Ui_offset[0] + p]];
                    }
                    double ukk = Udiag[k];
                    X[X_offset + k] = x[0] / ukk;
                }
                break;
            }
            case 2: {
                for (int k = 0; k < n; ++k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    x[0] = X[X_offset + 2 * k];
                    x[1] = X[X_offset + 2 * k + 1];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        x[0] = x[0] - uik * X[X_offset + 2 * i];
                        x[1] = x[1] - uik * X[X_offset + 2 * i + 1];
                    }
                    double ukk = Udiag[k];
                    X[X_offset + 2 * k] = x[0] / ukk;
                    X[X_offset + 2 * k + 1] = x[1] / ukk;
                }
                break;
            }
            case 3: {
                for (int k = 0; k < n; ++k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    x[0] = X[X_offset + 3 * k];
                    x[1] = X[X_offset + 3 * k + 1];
                    x[2] = X[X_offset + 3 * k + 2];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        x[0] = x[0] - uik * X[X_offset + 3 * i];
                        x[1] = x[1] - uik * X[X_offset + 3 * i + 1];
                        x[2] = x[2] - uik * X[X_offset + 3 * i + 2];
                    }
                    double ukk = Udiag[k];
                    X[X_offset + 3 * k] = x[0] / ukk;
                    X[X_offset + 3 * k + 1] = x[1] / ukk;
                    X[X_offset + 3 * k + 2] = x[2] / ukk;
                }
                break;
            }
            case 4: {
                for (int k = 0; k < n; ++k) {
                    double[] Ux;
                    double[] Ui = Ux = Dklu.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, len);
                    x[0] = X[X_offset + 4 * k];
                    x[1] = X[X_offset + 4 * k + 1];
                    x[2] = X[X_offset + 4 * k + 2];
                    x[3] = X[X_offset + 4 * k + 3];
                    for (int p = 0; p < len[0]; ++p) {
                        int i = (int)Ui[Ui_offset[0] + p];
                        double uik = Ux[Ux_offset[0] + p];
                        x[0] = x[0] - uik * X[X_offset + 4 * i];
                        x[1] = x[1] - uik * X[X_offset + 4 * i + 1];
                        x[2] = x[2] - uik * X[X_offset + 4 * i + 2];
                        x[3] = x[3] - uik * X[X_offset + 4 * i + 3];
                    }
                    double ukk = Udiag[k];
                    X[X_offset + 4 * k] = x[0] / ukk;
                    X[X_offset + 4 * k + 1] = x[1] / ukk;
                    X[X_offset + 4 * k + 2] = x[2] / ukk;
                    X[X_offset + 4 * k + 3] = x[3] / ukk;
                }
                break;
            }
        }
    }
}

