/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexFactory1D;
import cern.colt.matrix.tdcomplex.DComplexFactory2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tint.IntFactory1D;
import cern.colt.matrix.tint.IntFactory2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class Utils {
    public static final IntFunctions ifunc = IntFunctions.intFunctions;
    public static final DoubleFunctions dfunc = DoubleFunctions.functions;
    public static final DComplexFunctions cfunc = DComplexFunctions.functions;
    public static final double[] j = new double[]{0.0, 1.0};
    public static final double[] CZERO = new double[]{0.0, 0.0};
    public static final double[] CONE = new double[]{1.0, 0.0};
    public static final double[] CNEG_ONE = new double[]{-1.0, 0.0};
    public static final Utils util = new Utils();
    public static final double EPS;

    protected Utils() {
    }

    public static int[] irange(int stop) {
        return Utils.irange(0, stop);
    }

    public static int[] irange(int start, int stop) {
        return Utils.irange(start, stop, 1);
    }

    public static int[] irange(int start, int stop, int step) {
        int[] r = new int[stop - start];
        int v = start;
        for (int i = 0; i < r.length; ++i) {
            r[i] = v;
            v += step;
        }
        return r;
    }

    public static double[] drange(int stop) {
        return Utils.drange(0, stop);
    }

    public static double[] drange(int start, int stop) {
        return Utils.drange(start, stop, 1);
    }

    public static double[] drange(int start, int stop, int step) {
        double[] r = new double[stop - start];
        int v = start;
        for (int i = 0; i < r.length; ++i) {
            r[i] = v;
            v += step;
        }
        return r;
    }

    public static double[] drange(double stop) {
        return Utils.drange(0.0, stop, 1.0);
    }

    public static double[] drange(double start, double stop) {
        return Utils.drange(start, stop, 1.0);
    }

    public static double[] drange(double start, double stop, double step) {
        double[] r = new double[(int)((stop - start) / step)];
        double v = start;
        for (int i = 0; i < r.length; ++i) {
            r[i] = v;
            v += step;
        }
        return r;
    }

    public static int[] zeros(int size) {
        final int[] values = new int[size];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = 0;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values[i] = 0;
            }
        }
        return values;
    }

    public static int[] ones(int size) {
        final int[] values = new int[size];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = 1;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values[i] = 1;
            }
        }
        return values;
    }

    public static int[] inta(final DoubleMatrix1D d) {
        int size = (int)d.size();
        final int[] values = new int[size];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = (int)Math.round(d.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values[i] = (int)d.getQuick(i);
            }
        }
        return values;
    }

    public static IntMatrix1D intm(final DoubleMatrix1D d) {
        int size = (int)d.size();
        final IntMatrix1D values = IntFactory1D.dense.make(size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values.setQuick(i, (int)Math.round(d.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values.setQuick(i, (int)d.getQuick(i));
            }
        }
        return values;
    }

    public static DoubleMatrix1D dbla(final int[] ix) {
        int size = ix.length;
        final DoubleMatrix1D values = DoubleFactory1D.dense.make(size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values.setQuick(i, ix[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values.setQuick(i, ix[i]);
            }
        }
        return values;
    }

    public static DoubleMatrix1D dblm(final IntMatrix1D ix) {
        int size = (int)ix.size();
        final DoubleMatrix1D values = DoubleFactory1D.dense.make(size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values.setQuick(i, ix.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values.setQuick(i, ix.getQuick(i));
            }
        }
        return values;
    }

    public static DComplexMatrix1D cplxm(final IntMatrix1D ix) {
        int size = (int)ix.size();
        final DComplexMatrix1D values = DComplexFactory1D.dense.make(size);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values.setQuick(i, ix.getQuick(i), 0.0);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                values.setQuick(i, ix.getQuick(i), 0.0);
            }
        }
        return values;
    }

    public static double max(DoubleMatrix1D a) {
        return a.aggregate(DoubleFunctions.max, DoubleFunctions.identity);
    }

    public static double min(DoubleMatrix1D a) {
        return a.aggregate(DoubleFunctions.min, DoubleFunctions.identity);
    }

    public static int max(int[] t) {
        int maximum = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (t[i] <= maximum) continue;
            maximum = t[i];
        }
        return maximum;
    }

    public static int[] icat(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static double[] dcat(double[] a, double[] b) {
        double[] c = new double[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[] scat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] nonzero(IntMatrix1D a) {
        int value;
        IntArrayList indexList = new IntArrayList();
        int size = (int)a.size();
        int rem = size % 2;
        if (rem == 1 && (value = a.getQuick(0)) != 0) {
            indexList.add(0);
        }
        for (int i = rem; i < size; i += 2) {
            int value2 = a.getQuick(i);
            if (value2 != 0) {
                indexList.add(i);
            }
            if ((value2 = a.getQuick(i + 1)) == 0) continue;
            indexList.add(i + 1);
        }
        indexList.trimToSize();
        return indexList.elements();
    }

    public static int[] nonzero(DoubleMatrix1D a) {
        double value;
        IntArrayList indexList = new IntArrayList();
        int size = (int)a.size();
        int rem = size % 2;
        if (rem == 1 && (value = a.getQuick(0)) != 0.0) {
            indexList.add(0);
        }
        for (int i = rem; i < size; i += 2) {
            double value2 = a.getQuick(i);
            if (value2 != 0.0) {
                indexList.add(i);
            }
            if ((value2 = a.getQuick(i + 1)) == 0.0) continue;
            indexList.add(i + 1);
        }
        indexList.trimToSize();
        return indexList.elements();
    }

    public static DComplexMatrix1D polar(DoubleMatrix1D r, DoubleMatrix1D theta) {
        return Utils.polar(r, theta, true);
    }

    public static DComplexMatrix1D polar(DoubleMatrix1D r, DoubleMatrix1D theta, boolean radians) {
        DoubleMatrix1D real = theta.copy();
        DoubleMatrix1D imag = theta.copy();
        if (!radians) {
            real.assign(DoubleFunctions.chain(DoubleFunctions.mult(Math.PI), DoubleFunctions.div(180.0)));
            imag.assign(DoubleFunctions.chain(DoubleFunctions.mult(Math.PI), DoubleFunctions.div(180.0)));
        }
        real.assign(DoubleFunctions.cos);
        imag.assign(DoubleFunctions.sin);
        real.assign(r, DoubleFunctions.mult);
        imag.assign(r, DoubleFunctions.mult);
        DComplexMatrix1D cmplx = DComplexFactory1D.dense.make((int)r.size());
        cmplx.assignReal(real);
        cmplx.assignImaginary(imag);
        return cmplx;
    }

    public static DComplexMatrix2D polar(DoubleMatrix2D r, DoubleMatrix2D theta) {
        return Utils.polar(r, theta, true);
    }

    public static DComplexMatrix2D polar(DoubleMatrix2D r, DoubleMatrix2D theta, boolean radians) {
        DoubleMatrix2D real = theta.copy();
        DoubleMatrix2D imag = theta.copy();
        if (!radians) {
            real.assign(DoubleFunctions.chain(DoubleFunctions.mult(Math.PI), DoubleFunctions.div(180.0)));
            imag.assign(DoubleFunctions.chain(DoubleFunctions.mult(Math.PI), DoubleFunctions.div(180.0)));
        }
        real.assign(DoubleFunctions.cos);
        imag.assign(DoubleFunctions.sin);
        real.assign(r, DoubleFunctions.mult);
        imag.assign(r, DoubleFunctions.mult);
        DComplexMatrix2D cmplx = DComplexFactory2D.dense.make(r.rows(), r.columns());
        cmplx.assignReal(real);
        cmplx.assignImaginary(imag);
        return cmplx;
    }

    public static IntMatrix1D diff(IntMatrix1D x) {
        int size = (int)x.size() - 1;
        IntMatrix1D d = IntFactory1D.dense.make(size);
        for (int i = 0; i < size; ++i) {
            d.set(i, IntFunctions.minus.apply(x.get(i + 1), x.get(i)));
        }
        return d;
    }

    public static DoubleMatrix1D diff(DoubleMatrix1D x) {
        int size = (int)x.size() - 1;
        DoubleMatrix1D d = DoubleFactory1D.dense.make(size);
        for (int i = 0; i < size; ++i) {
            d.set(i, DoubleFunctions.minus.apply(x.get(i + 1), x.get(i)));
        }
        return d;
    }

    public static boolean any(int[] x) {
        for (int i : x) {
            if (i == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean any(IntMatrix1D x) {
        IntArrayList indexList = new IntArrayList();
        x.getNonZeros(indexList, new IntArrayList());
        return indexList.size() > 0;
    }

    public static boolean any(DoubleMatrix1D x) {
        IntArrayList indexList = new IntArrayList();
        x.getNonZeros(indexList, new DoubleArrayList());
        return indexList.size() > 0;
    }

    public static IntMatrix1D any(DoubleMatrix2D x) {
        int cols = x.columns();
        IntMatrix1D y = IntFactory1D.dense.make(cols);
        for (int i = 0; i < cols; ++i) {
            int a = Utils.any(x.viewColumn(i)) ? 1 : 0;
            y.set(i, a);
        }
        return y;
    }

    public static boolean all(IntMatrix1D x) {
        IntArrayList indexList = new IntArrayList();
        x.getNonZeros(indexList, null);
        return x.size() == (long)indexList.size();
    }

    public static boolean all(DoubleMatrix1D x) {
        IntArrayList indexList = new IntArrayList();
        x.getNonZeros(indexList, null);
        return x.size() == (long)indexList.size();
    }

    public static DComplexMatrix1D complex(DoubleMatrix1D real, DoubleMatrix1D imaginary) {
        int size = 0;
        if (real != null) {
            size = (int)real.size();
        }
        if (imaginary != null) {
            size = (int)imaginary.size();
        }
        DComplexMatrix1D cmplx = DComplexFactory1D.dense.make(size);
        if (real != null) {
            cmplx.assignReal(real);
        }
        if (imaginary != null) {
            cmplx.assignImaginary(imaginary);
        }
        return cmplx;
    }

    public static DComplexMatrix2D complex(DoubleMatrix2D real, DoubleMatrix2D imaginary) {
        DComplexMatrix2D cmplx = DComplexFactory2D.dense.make(real.rows(), real.columns());
        if (real != null) {
            cmplx.assignReal(real);
        }
        if (imaginary != null) {
            cmplx.assignImaginary(imaginary);
        }
        return cmplx;
    }

    public static IntMatrix1D sub2ind(int rows, int cols, IntMatrix1D I, IntMatrix1D J) {
        return Utils.sub2ind(rows, cols, I, J, true);
    }

    public static IntMatrix1D sub2ind(int rows, int cols, IntMatrix1D I, IntMatrix1D J, boolean row_major) {
        IntMatrix1D ind = row_major ? I.copy().assign(IntFunctions.mod(rows)).assign(IntFunctions.mult(cols)).assign(J.copy().assign(IntFunctions.mod(cols)), IntFunctions.plus) : J.copy().assign(IntFunctions.mod(cols)).assign(IntFunctions.max(rows)).assign(I.copy().assign(IntFunctions.mod(rows)), IntFunctions.plus);
        return ind;
    }

    public static DoubleMatrix1D append(DoubleMatrix1D x, double a) {
        int n = (int)x.size();
        DoubleMatrix1D y = DoubleFactory1D.dense.make(n + 1);
        y.viewPart(0, n).assign(x);
        y.setQuick(n, a);
        return y;
    }

    public static IntMatrix1D append(IntMatrix1D x, int a) {
        int n = (int)x.size();
        IntMatrix1D y = IntFactory1D.dense.make(n + 1);
        y.viewPart(0, n).assign(x);
        y.setQuick(n, a);
        return y;
    }

    public static DoubleMatrix2D unflatten(DoubleMatrix1D a, boolean col) {
        int ncol;
        int nrow;
        if (col) {
            nrow = (int)a.size();
            ncol = 1;
        } else {
            nrow = 1;
            ncol = (int)a.size();
        }
        DoubleMatrix2D b = DoubleFactory2D.dense.make(nrow, ncol);
        b.assign(a.toArray());
        return b;
    }

    public static DComplexMatrix2D unflatten(DComplexMatrix1D a, boolean col) {
        int ncol;
        int nrow;
        if (col) {
            nrow = (int)a.size();
            ncol = 1;
        } else {
            nrow = 1;
            ncol = (int)a.size();
        }
        DComplexMatrix2D b = DComplexFactory2D.dense.make(nrow, ncol);
        b.assign(a.toArray());
        return b;
    }

    public static IntMatrix2D unflatten(IntMatrix1D a) {
        return Utils.unflatten(a, true);
    }

    public static IntMatrix2D unflatten(IntMatrix1D a, boolean col) {
        int ncol;
        int nrow;
        if (col) {
            nrow = (int)a.size();
            ncol = 1;
        } else {
            nrow = 1;
            ncol = (int)a.size();
        }
        IntMatrix2D b = IntFactory2D.dense.make(nrow, ncol);
        b.assign(a.toArray());
        return b;
    }

    public static DoubleMatrix2D delete(DoubleMatrix2D m, int idx) {
        return Utils.delete(m, idx, 0);
    }

    public static DoubleMatrix2D delete(DoubleMatrix2D m, int idx, int axis) {
        int[] icol;
        int[] irow;
        if (axis == 0) {
            irow = Utils.icat(Utils.irange(idx), Utils.irange(idx + 1, m.rows()));
            icol = null;
        } else {
            irow = null;
            icol = Utils.icat(Utils.irange(idx), Utils.irange(idx + 1, m.columns()));
        }
        return m.viewSelection(irow, icol).copy();
    }

    static {
        double d = 0.5;
        while (1.0 + d > 1.0) {
            d /= 2.0;
        }
        EPS = d;
    }
}

