/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.stat.tdouble.Gamma;

public class DoubleDescriptive {
    protected DoubleDescriptive() {
    }

    public static double autoCorrelation(DoubleArrayList data, int lag, double mean, double variance) {
        int N = data.size();
        if (lag >= N) {
            throw new IllegalArgumentException("Lag is too large");
        }
        double[] elements = data.elements();
        double run = 0.0;
        for (int i = lag; i < N; ++i) {
            run += (elements[i] - mean) * (elements[i - lag] - mean);
        }
        return run / (double)(N - lag) / variance;
    }

    protected static void checkRangeFromTo(int from, int to, int theSize) {
        if (to == from - 1) {
            return;
        }
        if (from < 0 || from > to || to >= theSize) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        }
    }

    public static double correlation(DoubleArrayList data1, double standardDev1, DoubleArrayList data2, double standardDev2) {
        return DoubleDescriptive.covariance(data1, data2) / (standardDev1 * standardDev2);
    }

    public static double covariance(DoubleArrayList data1, DoubleArrayList data2) {
        int size = data1.size();
        if (size != data2.size() || size == 0) {
            throw new IllegalArgumentException();
        }
        double[] elements1 = data1.elements();
        double[] elements2 = data2.elements();
        double sumx = elements1[0];
        double sumy = elements2[0];
        double Sxy = 0.0;
        for (int i = 1; i < size; ++i) {
            double x = elements1[i];
            double y = elements2[i];
            Sxy += (x - (sumx += x) / (double)(i + 1)) * (y - sumy / (double)i);
            sumy += y;
        }
        return Sxy / (double)(size - 1);
    }

    private static double covariance2(DoubleArrayList data1, DoubleArrayList data2) {
        int size = data1.size();
        double mean1 = DoubleDescriptive.mean(data1);
        double mean2 = DoubleDescriptive.mean(data2);
        double covariance = 0.0;
        for (int i = 0; i < size; ++i) {
            double x = data1.get(i);
            double y = data2.get(i);
            covariance += (x - mean1) * (y - mean2);
        }
        return covariance / (double)(size - 1);
    }

    public static double durbinWatson(DoubleArrayList data) {
        int size = data.size();
        if (size < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        double[] elements = data.elements();
        double run = 0.0;
        double run_sq = 0.0;
        run_sq = elements[0] * elements[0];
        for (int i = 1; i < size; ++i) {
            double x = elements[i] - elements[i - 1];
            run += x * x;
            run_sq += elements[i] * elements[i];
        }
        return run / run_sq;
    }

    public static void frequencies(DoubleArrayList sortedData, DoubleArrayList distinctValues, IntArrayList frequencies) {
        distinctValues.clear();
        if (frequencies != null) {
            frequencies.clear();
        }
        double[] sortedElements = sortedData.elements();
        int size = sortedData.size();
        int i = 0;
        while (i < size) {
            double element = sortedElements[i];
            int cursor = i;
            while (++i < size && sortedElements[i] == element) {
            }
            int runLength = i - cursor;
            distinctValues.add(element);
            if (frequencies == null) continue;
            frequencies.add(runLength);
        }
    }

    public static double geometricMean(int size, double sumOfLogarithms) {
        return Math.exp(sumOfLogarithms / (double)size);
    }

    public static double geometricMean(DoubleArrayList data) {
        return DoubleDescriptive.geometricMean(data.size(), DoubleDescriptive.sumOfLogarithms(data, 0, data.size() - 1));
    }

    public static double harmonicMean(int size, double sumOfInversions) {
        return (double)size / sumOfInversions;
    }

    public static void incrementalUpdate(DoubleArrayList data, int from, int to, double[] inOut) {
        DoubleDescriptive.checkRangeFromTo(from, to, data.size());
        double min = inOut[0];
        double max = inOut[1];
        double sum = inOut[2];
        double sumSquares = inOut[3];
        double[] elements = data.elements();
        while (from <= to) {
            double element = elements[from];
            sum += element;
            sumSquares += element * element;
            if (element < min) {
                min = element;
            }
            if (element > max) {
                max = element;
            }
            ++from;
        }
        inOut[0] = min;
        inOut[1] = max;
        inOut[2] = sum;
        inOut[3] = sumSquares;
    }

    public static void incrementalUpdateSumsOfPowers(DoubleArrayList data, int from, int to, int fromSumIndex, int toSumIndex, double[] sumOfPowers) {
        int size = data.size();
        int lastIndex = toSumIndex - fromSumIndex;
        if (from > size || lastIndex + 1 > sumOfPowers.length) {
            throw new IllegalArgumentException();
        }
        if (fromSumIndex == 1) {
            if (toSumIndex == 2) {
                double[] elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                int i = from - 1;
                while (++i <= to) {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                return;
            }
            if (toSumIndex == 3) {
                double[] elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                int i = from - 1;
                while (++i <= to) {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                return;
            }
            if (toSumIndex == 4) {
                double[] elements = data.elements();
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                double sum_xxxx = sumOfPowers[3];
                int i = from - 1;
                while (++i <= to) {
                    double element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                    sum_xxxx += element * element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                sumOfPowers[3] = sumOfPowers[3] + sum_xxxx;
                return;
            }
        }
        if (fromSumIndex == toSumIndex || fromSumIndex >= -1 && toSumIndex <= 5) {
            for (int i = fromSumIndex; i <= toSumIndex; ++i) {
                int n = i - fromSumIndex;
                sumOfPowers[n] = sumOfPowers[n] + DoubleDescriptive.sumOfPowerDeviations(data, i, 0.0, from, to);
            }
            return;
        }
        double[] elements = data.elements();
        int i = from - 1;
        while (++i <= to) {
            double element = elements[i];
            double pow = Math.pow(element, fromSumIndex);
            int j = 0;
            int m = lastIndex;
            while (--m >= 0) {
                int n = j++;
                sumOfPowers[n] = sumOfPowers[n] + pow;
                pow *= element;
            }
            int n = j;
            sumOfPowers[n] = sumOfPowers[n] + pow;
        }
    }

    public static void incrementalWeightedUpdate(DoubleArrayList data, DoubleArrayList weights, int from, int to, double[] inOut) {
        int dataSize = data.size();
        DoubleDescriptive.checkRangeFromTo(from, to, dataSize);
        if (dataSize != weights.size()) {
            throw new IllegalArgumentException("from=" + from + ", to=" + to + ", data.size()=" + dataSize + ", weights.size()=" + weights.size());
        }
        double sum = inOut[0];
        double sumOfSquares = inOut[1];
        double[] elements = data.elements();
        double[] w = weights.elements();
        int i = from - 1;
        while (++i <= to) {
            double element = elements[i];
            double weight = w[i];
            double prod = element * weight;
            sum += prod;
            sumOfSquares += element * prod;
        }
        inOut[0] = sum;
        inOut[1] = sumOfSquares;
    }

    public static double kurtosis(double moment4, double standardDeviation) {
        return -3.0 + moment4 / (standardDeviation * standardDeviation * standardDeviation * standardDeviation);
    }

    public static double kurtosis(DoubleArrayList data, double mean, double standardDeviation) {
        return DoubleDescriptive.kurtosis(DoubleDescriptive.moment(data, 4, mean), standardDeviation);
    }

    public static double lag1(DoubleArrayList data, double mean) {
        int size = data.size();
        double[] elements = data.elements();
        double q = 0.0;
        double v = (elements[0] - mean) * (elements[0] - mean);
        for (int i = 1; i < size; ++i) {
            double delta0 = elements[i - 1] - mean;
            double delta1 = elements[i] - mean;
            q += (delta0 * delta1 - q) / (double)(i + 1);
            v += (delta1 * delta1 - v) / (double)(i + 1);
        }
        double r1 = q / v;
        return r1;
    }

    public static double max(DoubleArrayList data) {
        int size = data.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        double[] elements = data.elements();
        double max = elements[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(elements[i] > max)) continue;
            max = elements[i];
        }
        return max;
    }

    public static double mean(DoubleArrayList data) {
        return DoubleDescriptive.sum(data) / (double)data.size();
    }

    public static double meanDeviation(DoubleArrayList data, double mean) {
        double[] elements = data.elements();
        int size = data.size();
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            sum += Math.abs(elements[i] - mean);
        }
        return sum / (double)size;
    }

    public static double median(DoubleArrayList sortedData) {
        return DoubleDescriptive.quantile(sortedData, 0.5);
    }

    public static double min(DoubleArrayList data) {
        int size = data.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        double[] elements = data.elements();
        double min = elements[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(elements[i] < min)) continue;
            min = elements[i];
        }
        return min;
    }

    public static double moment(int k, double c, int size, double[] sumOfPowers) {
        double sum = 0.0;
        int sign = 1;
        for (int i = 0; i <= k; ++i) {
            double y = i == 0 ? 1.0 : (i == 1 ? c : (i == 2 ? c * c : (i == 3 ? c * c * c : Math.pow(c, i))));
            sum += (double)sign * DoubleArithmetic.binomial(k, (long)i) * y * sumOfPowers[k - i];
            sign = -sign;
        }
        return sum / (double)size;
    }

    public static double moment(DoubleArrayList data, int k, double c) {
        return DoubleDescriptive.sumOfPowerDeviations(data, k, c) / (double)data.size();
    }

    public static double pooledMean(int size1, double mean1, int size2, double mean2) {
        return ((double)size1 * mean1 + (double)size2 * mean2) / (double)(size1 + size2);
    }

    public static double pooledVariance(int size1, double variance1, int size2, double variance2) {
        return ((double)size1 * variance1 + (double)size2 * variance2) / (double)(size1 + size2);
    }

    public static double product(int size, double sumOfLogarithms) {
        return Math.pow(Math.exp(sumOfLogarithms / (double)size), size);
    }

    public static double product(DoubleArrayList data) {
        int size = data.size();
        double[] elements = data.elements();
        double product = 1.0;
        int i = size;
        while (--i >= 0) {
            product *= elements[i];
        }
        return product;
    }

    public static double quantile(DoubleArrayList sortedData, double phi) {
        double[] sortedElements = sortedData.elements();
        int n = sortedData.size();
        double index = phi * (double)(n - 1);
        int lhs = (int)index;
        double delta = index - (double)lhs;
        if (n == 0) {
            return 0.0;
        }
        double result = lhs == n - 1 ? sortedElements[lhs] : (1.0 - delta) * sortedElements[lhs] + delta * sortedElements[lhs + 1];
        return result;
    }

    public static double quantileInverse(DoubleArrayList sortedList, double element) {
        return DoubleDescriptive.rankInterpolated(sortedList, element) / (double)sortedList.size();
    }

    public static DoubleArrayList quantiles(DoubleArrayList sortedData, DoubleArrayList percentages) {
        int s = percentages.size();
        DoubleArrayList quantiles = new DoubleArrayList(s);
        for (int i = 0; i < s; ++i) {
            quantiles.add(DoubleDescriptive.quantile(sortedData, percentages.get(i)));
        }
        return quantiles;
    }

    public static double rankInterpolated(DoubleArrayList sortedList, double element) {
        int index = sortedList.binarySearch(element);
        if (index >= 0) {
            int to;
            int s = sortedList.size();
            for (to = index + 1; to < s && sortedList.get(to) == element; ++to) {
            }
            return to;
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0 || insertionPoint == sortedList.size()) {
            return insertionPoint;
        }
        double from = sortedList.get(insertionPoint - 1);
        double to = sortedList.get(insertionPoint);
        double delta = (element - from) / (to - from);
        return (double)insertionPoint + delta;
    }

    public static double rms(int size, double sumOfSquares) {
        return Math.sqrt(sumOfSquares / (double)size);
    }

    public static double sampleKurtosis(int size, double moment4, double sampleVariance) {
        int n = size;
        double s2 = sampleVariance;
        double m4 = moment4 * (double)n;
        return m4 * (double)n * (double)(n + 1) / ((double)((n - 1) * (n - 2) * (n - 3)) * s2 * s2) - 3.0 * (double)(n - 1) * (double)(n - 1) / (double)((n - 2) * (n - 3));
    }

    public static double sampleKurtosis(DoubleArrayList data, double mean, double sampleVariance) {
        return DoubleDescriptive.sampleKurtosis(data.size(), DoubleDescriptive.moment(data, 4, mean), sampleVariance);
    }

    public static double sampleKurtosisStandardError(int size) {
        int n = size;
        return Math.sqrt(24.0 * (double)n * (double)(n - 1) * (double)(n - 1) / (double)((n - 3) * (n - 2) * (n + 3) * (n + 5)));
    }

    public static double sampleSkew(int size, double moment3, double sampleVariance) {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double m3 = moment3 * (double)n;
        return (double)n * m3 / ((double)((n - 1) * (n - 2)) * s * s * s);
    }

    public static double sampleSkew(DoubleArrayList data, double mean, double sampleVariance) {
        return DoubleDescriptive.sampleSkew(data.size(), DoubleDescriptive.moment(data, 3, mean), sampleVariance);
    }

    public static double sampleSkewStandardError(int size) {
        int n = size;
        return Math.sqrt(6.0 * (double)n * (double)(n - 1) / (double)((n - 2) * (n + 1) * (n + 3)));
    }

    public static double sampleStandardDeviation(int size, double sampleVariance) {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double Cn = n > 30 ? 1.0 + 1.0 / (double)(4 * (n - 1)) : Math.sqrt((double)(n - 1) * 0.5) * Gamma.gamma((double)(n - 1) * 0.5) / Gamma.gamma((double)n * 0.5);
        return Cn * s;
    }

    public static double sampleVariance(int size, double sum, double sumOfSquares) {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)(size - 1);
    }

    public static double sampleVariance(DoubleArrayList data, double mean) {
        double[] elements = data.elements();
        int size = data.size();
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            double delta = elements[i] - mean;
            sum += delta * delta;
        }
        return sum / (double)(size - 1);
    }

    public static double sampleWeightedVariance(double sumOfWeights, double sumOfProducts, double sumOfSquaredProducts) {
        return (sumOfSquaredProducts - sumOfProducts * sumOfProducts / sumOfWeights) / (sumOfWeights - 1.0);
    }

    public static double skew(double moment3, double standardDeviation) {
        return moment3 / (standardDeviation * standardDeviation * standardDeviation);
    }

    public static double skew(DoubleArrayList data, double mean, double standardDeviation) {
        return DoubleDescriptive.skew(DoubleDescriptive.moment(data, 3, mean), standardDeviation);
    }

    public static DoubleArrayList[] split(DoubleArrayList sortedList, DoubleArrayList splitters) {
        int noOfBins = splitters.size() + 1;
        DoubleArrayList[] bins = new DoubleArrayList[noOfBins];
        int i = noOfBins;
        while (--i >= 0) {
            bins[i] = new DoubleArrayList();
        }
        int listSize = sortedList.size();
        int nextStart = 0;
        for (int i2 = 0; nextStart < listSize && i2 < noOfBins - 1; ++i2) {
            double splitValue = splitters.get(i2);
            int index = sortedList.binarySearch(splitValue);
            if (index < 0) {
                int insertionPosition = -index - 1;
                bins[i2].addAllOfFromTo(sortedList, nextStart, insertionPosition - 1);
                nextStart = insertionPosition;
                continue;
            }
            while (--index >= 0 && sortedList.get(index) == splitValue) {
            }
            bins[i2].addAllOfFromTo(sortedList, nextStart, index);
            nextStart = index + 1;
        }
        bins[noOfBins - 1].addAllOfFromTo(sortedList, nextStart, sortedList.size() - 1);
        return bins;
    }

    public static double standardDeviation(double variance) {
        return Math.sqrt(variance);
    }

    public static double standardError(int size, double variance) {
        return Math.sqrt(variance / (double)size);
    }

    public static void standardize(DoubleArrayList data, double mean, double standardDeviation) {
        double[] elements = data.elements();
        int i = data.size();
        while (--i >= 0) {
            elements[i] = (elements[i] - mean) / standardDeviation;
        }
    }

    public static double sum(DoubleArrayList data) {
        return DoubleDescriptive.sumOfPowerDeviations(data, 1, 0.0);
    }

    public static double sumOfInversions(DoubleArrayList data, int from, int to) {
        return DoubleDescriptive.sumOfPowerDeviations(data, -1, 0.0, from, to);
    }

    public static double sumOfLogarithms(DoubleArrayList data, int from, int to) {
        double[] elements = data.elements();
        double logsum = 0.0;
        int i = from - 1;
        while (++i <= to) {
            logsum += Math.log(elements[i]);
        }
        return logsum;
    }

    public static double sumOfPowerDeviations(DoubleArrayList data, int k, double c) {
        return DoubleDescriptive.sumOfPowerDeviations(data, k, c, 0, data.size() - 1);
    }

    public static double sumOfPowerDeviations(DoubleArrayList data, int k, double c, int from, int to) {
        double[] elements = data.elements();
        double sum = 0.0;
        switch (k) {
            case -2: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i];
                        sum += 1.0 / (v * v);
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i] - c;
                        sum += 1.0 / (v * v);
                    }
                }
                break;
            }
            case -1: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0 / elements[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0 / (elements[i] - c);
                    }
                }
                break;
            }
            case 0: {
                sum += (double)(to - from + 1);
                break;
            }
            case 1: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += elements[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += elements[i] - c;
                    }
                }
                break;
            }
            case 2: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i];
                        sum += v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i] - c;
                        sum += v * v;
                    }
                }
                break;
            }
            case 3: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i];
                        sum += v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i] - c;
                        sum += v * v * v;
                    }
                }
                break;
            }
            case 4: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i];
                        sum += v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i] - c;
                        sum += v * v * v * v;
                    }
                }
                break;
            }
            case 5: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i];
                        sum += v * v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = elements[i] - c;
                        sum += v * v * v * v * v;
                    }
                }
                break;
            }
            default: {
                int i = from - 1;
                while (++i <= to) {
                    sum += Math.pow(elements[i] - c, k);
                }
                break block0;
            }
        }
        return sum;
    }

    public static double sumOfPowers(DoubleArrayList data, int k) {
        return DoubleDescriptive.sumOfPowerDeviations(data, k, 0.0);
    }

    public static double sumOfSquaredDeviations(int size, double variance) {
        return variance * (double)(size - 1);
    }

    public static double sumOfSquares(DoubleArrayList data) {
        return DoubleDescriptive.sumOfPowerDeviations(data, 2, 0.0);
    }

    public static double trimmedMean(DoubleArrayList sortedData, double mean, int left, int right) {
        int i;
        int N = sortedData.size();
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] sortedElements = sortedData.elements();
        int N0 = N;
        for (i = 0; i < left; ++i) {
            mean += (mean - sortedElements[i]) / (double)(--N);
        }
        for (i = 0; i < right; ++i) {
            mean += (mean - sortedElements[N0 - 1 - i]) / (double)(--N);
        }
        return mean;
    }

    public static double variance(double standardDeviation) {
        return standardDeviation * standardDeviation;
    }

    public static double variance(int size, double sum, double sumOfSquares) {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)size;
    }

    public static double weightedMean(DoubleArrayList data, DoubleArrayList weights) {
        int size = data.size();
        if (size != weights.size() || size == 0) {
            throw new IllegalArgumentException();
        }
        double[] elements = data.elements();
        double[] theWeights = weights.elements();
        double sum = 0.0;
        double weightsSum = 0.0;
        int i = size;
        while (--i >= 0) {
            double w = theWeights[i];
            sum += elements[i] * w;
            weightsSum += w;
        }
        return sum / weightsSum;
    }

    public static double weightedRMS(double sumOfProducts, double sumOfSquaredProducts) {
        return sumOfProducts / sumOfSquaredProducts;
    }

    public static double winsorizedMean(DoubleArrayList sortedData, double mean, int left, int right) {
        int N = sortedData.size();
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] sortedElements = sortedData.elements();
        double leftElement = sortedElements[left];
        for (int i = 0; i < left; ++i) {
            mean += (leftElement - sortedElements[i]) / (double)N;
        }
        double rightElement = sortedElements[N - 1 - right];
        for (int i = 0; i < right; ++i) {
            mean += (rightElement - sortedElements[N - 1 - i]) / (double)N;
        }
        return mean;
    }
}

