/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.AbstractDiscreteDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;

public class Binomial
extends AbstractDiscreteDistribution {
    private static final long serialVersionUID = 1L;
    protected int n;
    protected double p;
    private int n_last = -1;
    private int n_prev = -1;
    private double par;
    private double np;
    private double p0;
    private double q;
    private double p_last = -1.0;
    private double p_prev = -1.0;
    private int b;
    private int m;
    private int nm;
    private double pq;
    private double rc;
    private double ss;
    private double xm;
    private double xl;
    private double xr;
    private double ll;
    private double lr;
    private double c;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double ch;
    private double log_p;
    private double log_q;
    private double log_n;
    protected static Binomial shared = new Binomial(1, 0.5, Binomial.makeDefaultGenerator());

    public Binomial(int n, double p, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setNandP(n, p);
    }

    public double cdf(int k) {
        return Probability.binomial(k, this.n, this.p);
    }

    private double cdfSlow(int k) {
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        for (int r = 0; r <= k; ++r) {
            sum += this.pdf(r);
        }
        return sum;
    }

    protected int generateBinomial(int n, double p) {
        int K;
        double f;
        int i;
        double C1_3 = 0.3333333333333333;
        double C5_8 = 0.625;
        double C1_6 = 0.16666666666666666;
        int DMAX_KM = 20;
        if (n != this.n_last || p != this.p_last) {
            this.n_last = n;
            this.p_last = p;
            this.par = Math.min(p, 1.0 - p);
            this.q = 1.0 - this.par;
            this.np = (double)n * this.par;
            if (this.np <= 0.0) {
                return -1;
            }
            double rm = this.np + this.par;
            this.m = (int)rm;
            if (this.np < 10.0) {
                this.p0 = Math.exp((double)n * Math.log(this.q));
                int bh = (int)(this.np + 10.0 * Math.sqrt(this.np * this.q));
                this.b = Math.min(n, bh);
            } else {
                this.pq = this.par / this.q;
                this.rc = ((double)n + 1.0) * this.pq;
                this.ss = this.np * this.q;
                i = (int)(2.195 * Math.sqrt(this.ss) - 4.6 * this.q);
                this.xm = (double)this.m + 0.5;
                this.xl = this.m - i;
                this.xr = (long)(this.m + i) + 1L;
                f = (rm - this.xl) / (rm - this.xl * this.par);
                this.ll = f * (1.0 + 0.5 * f);
                f = (this.xr - rm) / (this.xr * this.q);
                this.lr = f * (1.0 + 0.5 * f);
                this.c = 0.134 + 20.5 / (15.3 + (double)this.m);
                this.p1 = (double)i + 0.5;
                this.p2 = this.p1 * (1.0 + this.c + this.c);
                this.p3 = this.p2 + this.c / this.ll;
                this.p4 = this.p3 + this.c / this.lr;
            }
        }
        if (this.np < 10.0) {
            int K2 = 0;
            double pk = this.p0;
            double U = this.randomGenerator.raw();
            while (U > pk) {
                if (++K2 > this.b) {
                    U = this.randomGenerator.raw();
                    K2 = 0;
                    pk = this.p0;
                    continue;
                }
                U -= pk;
                pk = (double)(n - K2 + 1) * this.par * pk / ((double)K2 * this.q);
            }
            return p > 0.5 ? n - K2 : K2;
        }
        while (true) {
            int nK;
            double E;
            double T;
            double X;
            double d;
            double V = this.randomGenerator.raw();
            double U = this.randomGenerator.raw() * this.p4;
            if (d <= this.p1) {
                K = (int)(this.xm - U + this.p1 * V);
                return p > 0.5 ? n - K : K;
            }
            if (U <= this.p2) {
                double d2;
                X = this.xl + (U - this.p1) / this.c;
                V = V * this.c + 1.0 - Math.abs(this.xm - X) / this.p1;
                if (d2 >= 1.0) continue;
                K = (int)X;
            } else if (U <= this.p3) {
                double d3;
                X = this.xl + Math.log(V) / this.ll;
                if (d3 < 0.0) continue;
                K = (int)X;
                V *= (U - this.p2) * this.ll;
            } else {
                K = (int)(this.xr - Math.log(V) / this.lr);
                if (K > n) continue;
                V *= (U - this.p3) * this.lr;
            }
            int Km = Math.abs(K - this.m);
            if (Km <= 20 || (double)((long)(Km + Km) + 2L) >= this.ss) {
                f = 1.0;
                if (this.m < K) {
                    i = this.m;
                    while (i < K) {
                        double d4;
                        f *= this.rc / (double)(++i) - this.pq;
                        if (!(d4 < V)) continue;
                        break;
                    }
                } else {
                    i = K;
                    while (i < this.m) {
                        double d5;
                        V *= this.rc / (double)(++i) - this.pq;
                        if (!(d5 > f)) continue;
                    }
                }
                if (!(V <= f)) continue;
                break;
            }
            if ((V = Math.log(V)) <= (T = (double)(-Km * Km) / (this.ss + this.ss)) - (E = (double)Km / this.ss * (((double)Km * ((double)Km * 0.3333333333333333 + 0.625) + 0.16666666666666666) / this.ss + 0.5))) break;
            if (!(V <= T + E)) continue;
            if (n != this.n_prev || this.par != this.p_prev) {
                this.n_prev = n;
                this.p_prev = this.par;
                this.nm = n - this.m + 1;
                this.ch = this.xm * Math.log(((double)this.m + 1.0) / (this.pq * (double)this.nm)) + DoubleArithmetic.stirlingCorrection(this.m + 1) + DoubleArithmetic.stirlingCorrection(this.nm);
            }
            if (V <= this.ch + ((double)n + 1.0) * Math.log((double)this.nm / (double)(nK = n - K + 1)) + ((double)K + 0.5) * Math.log((double)nK * this.pq / ((double)K + 1.0)) - DoubleArithmetic.stirlingCorrection(K + 1) - DoubleArithmetic.stirlingCorrection(nK)) break;
        }
        return p > 0.5 ? n - K : K;
    }

    public int nextInt() {
        return this.generateBinomial(this.n, this.p);
    }

    public int nextInt(int n, double p) {
        if ((double)n * Math.min(p, 1.0 - p) <= 0.0) {
            throw new IllegalArgumentException();
        }
        return this.generateBinomial(n, p);
    }

    public double pdf(int k) {
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        int r = this.n - k;
        return Math.exp(this.log_n - DoubleArithmetic.logFactorial(k) - DoubleArithmetic.logFactorial(r) + this.log_p * (double)k + this.log_q * (double)r);
    }

    public void setNandP(int n, double p) {
        if ((double)n * Math.min(p, 1.0 - p) <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.p = p;
        this.log_p = Math.log(p);
        this.log_q = Math.log(1.0 - p);
        this.log_n = DoubleArithmetic.logFactorial(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(int n, double p) {
        Binomial binomial = shared;
        synchronized (binomial) {
            return shared.nextInt(n, p);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.n + "," + this.p + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine randomGenerator) {
        Binomial binomial = shared;
        synchronized (binomial) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

