/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.jet.math.tfcomplex.FComplex;

public class FComplexPlusMultFirst
implements FComplexFComplexFComplexFunction {
    public float[] multiplicator;

    protected FComplexPlusMultFirst(float[] multiplicator) {
        this.multiplicator = multiplicator;
    }

    public final float[] apply(float[] a, float[] b) {
        float[] z = new float[]{a[0] * this.multiplicator[0] - a[1] * this.multiplicator[1], a[1] * this.multiplicator[0] + a[0] * this.multiplicator[1]};
        z[0] = z[0] + b[0];
        z[1] = z[1] + b[1];
        return z;
    }

    public static FComplexPlusMultFirst minusDiv(float[] constant) {
        return new FComplexPlusMultFirst(FComplex.neg(FComplex.inv(constant)));
    }

    public static FComplexPlusMultFirst minusMult(float[] constant) {
        return new FComplexPlusMultFirst(FComplex.neg(constant));
    }

    public static FComplexPlusMultFirst plusDiv(float[] constant) {
        return new FComplexPlusMultFirst(FComplex.inv(constant));
    }

    public static FComplexPlusMultFirst plusMult(float[] constant) {
        return new FComplexPlusMultFirst(constant);
    }
}

