/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseObjectMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new Object[rows * columns];
    }

    protected DenseObjectMatrix2D(int rows, int columns, Object[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseObjectMatrix2D.this.elements[zero + firstRow * DenseObjectMatrix2D.this.rowStride]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseObjectMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DenseObjectMatrix2D.this.elements[zero + r * DenseObjectMatrix2D.this.rowStride + c * DenseObjectMatrix2D.this.columnStride]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride]));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = DenseObjectMatrix2D.this.elements[zero + firstRow * DenseObjectMatrix2D.this.rowStride];
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseObjectMatrix2D.this.columns; ++c) {
                                elem = DenseObjectMatrix2D.this.elements[zero + r * DenseObjectMatrix2D.this.rowStride + c * DenseObjectMatrix2D.this.columnStride];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = f.apply(this.elements[zero]);
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseObjectMatrix2D.this.elements[zero + rowElements[firstIdx] * DenseObjectMatrix2D.this.rowStride + columnElements[firstIdx] * DenseObjectMatrix2D.this.columnStride]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            Object elem = DenseObjectMatrix2D.this.elements[zero + rowElements[i] * DenseObjectMatrix2D.this.rowStride + columnElements[i] * DenseObjectMatrix2D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            for (int i = 1; i < size; ++i) {
                Object elem = this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public Object aggregate(ObjectMatrix2D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        if (!(other instanceof DenseObjectMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final Object[] elemsOther = (Object[])other.elements();
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseObjectMatrix2D.this.elements[zero + firstRow * DenseObjectMatrix2D.this.rowStride], elemsOther[zeroOther + firstRow * rowStrideOther]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseObjectMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DenseObjectMatrix2D.this.elements[zero + r * DenseObjectMatrix2D.this.rowStride + c * DenseObjectMatrix2D.this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero], elemsOther[zeroOther]);
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    public ObjectMatrix2D assign(final Object value) {
        final Object[] elems = this.elements;
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                elems[i] = value;
                                i += DenseObjectMatrix2D.this.columnStride;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elems[i] = value;
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow * DenseObjectMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                Object[] currentRow = values[r];
                                if (currentRow.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                System.arraycopy(currentRow, 0, DenseObjectMatrix2D.this.elements, i, DenseObjectMatrix2D.this.columns);
                                i += DenseObjectMatrix2D.this.columns;
                            }
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        futures[j].get();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int i = 0;
                for (int r = 0; r < this.rows; ++r) {
                    Object[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i += this.columns;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                int j;
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                Object[] currentRow = values[r];
                                if (currentRow.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                int i = idx;
                                for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                    DenseObjectMatrix2D.this.elements[i] = currentRow[c];
                                    i += DenseObjectMatrix2D.this.columnStride;
                                }
                                idx += DenseObjectMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                try {
                    for (j = 0; j < nthreads; ++j) {
                        futures[j].get();
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    Object[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = currentRow[c];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction function) {
        final Object[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                elems[i] = function.apply(elems[i]);
                                i += DenseObjectMatrix2D.this.columnStride;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elems[i] = function.apply(elems[i]);
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final ObjectFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                Object elem = DenseObjectMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseObjectMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i += DenseObjectMatrix2D.this.columnStride;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    Object elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final Object value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                Object elem = DenseObjectMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseObjectMatrix2D.this.elements[i] = value;
                                }
                                i += DenseObjectMatrix2D.this.columnStride;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    Object elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (!(source instanceof DenseObjectMatrix2D)) {
            return super.assign(source);
        }
        DenseObjectMatrix2D other_final = (DenseObjectMatrix2D)source;
        if (other_final == this) {
            return this;
        }
        this.checkShape(other_final);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other_final.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseObjectMatrix2D other = (DenseObjectMatrix2D)source;
        if (this.haveSharedCells(other)) {
            ObjectMatrix2D c = other.copy();
            if (!(c instanceof DenseObjectMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseObjectMatrix2D)c;
        }
        final Object[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                DenseObjectMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseObjectMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, final ObjectObjectFunction function) {
        if (!(y instanceof DenseObjectMatrix2D)) {
            return super.assign(y, function);
        }
        DenseObjectMatrix2D other = (DenseObjectMatrix2D)y;
        this.checkShape(y);
        final Object[] elemsOther = other.elements();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                DenseObjectMatrix2D.this.elements[i] = function.apply(DenseObjectMatrix2D.this.elements[i], elemsOther[j]);
                                i += DenseObjectMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseObjectMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = function.apply(this.elements[i], elemsOther[j]);
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idxOther = firstRow * DenseObjectMatrix2D.this.columns;
                            int idx = zero + firstRow * DenseObjectMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseObjectMatrix2D.this.columns; ++c) {
                                    DenseObjectMatrix2D.this.elements[i] = values[idxOther++];
                                    i += DenseObjectMatrix2D.this.columnStride;
                                }
                                idx += DenseObjectMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = values[idxOther++];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, final ObjectObjectFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final Object[] elemsOther = (Object[])y.elements();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx = zero + rowElements[i] * DenseObjectMatrix2D.this.rowStride + columnElements[i] * DenseObjectMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseObjectMatrix2D.this.elements[idx] = function.apply(DenseObjectMatrix2D.this.elements[idx], elemsOther[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D otherMatrix = (SelectedDenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D otherMatrix = (DenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix1D like1D(int size) {
        return new DenseObjectMatrix1D(size);
    }

    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        return new DenseObjectMatrix1D(size, this.elements, zero, stride, true);
    }

    public void setQuick(int row, int column, Object value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D v = new DenseObjectMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)v.index(0);
        final int strideOther = v.stride();
        final Object[] elemsOther = (Object[])v.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                final int startidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + startidx * strideOther;
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            idx = zero + c * DenseObjectMatrix2D.this.columnStride;
                            for (int r = 0; r < DenseObjectMatrix2D.this.rows; ++r) {
                                elemsOther[idxOther] = DenseObjectMatrix2D.this.elements[idx];
                                idx += DenseObjectMatrix2D.this.rowStride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int c = 0; c < this.columns; ++c) {
                idx = zero + c * this.columnStride;
                for (int r = 0; r < this.rows; ++r) {
                    elemsOther[idxOther] = this.elements[idx];
                    idx += this.rowStride;
                    idxOther += strideOther;
                }
            }
        }
        return v;
    }

    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

