/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.csparsej.tfloat.Scs_add;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_cumsum;
import edu.emory.mathcs.csparsej.tfloat.Scs_dropzeros;
import edu.emory.mathcs.csparsej.tfloat.Scs_dupl;
import edu.emory.mathcs.csparsej.tfloat.Scs_multiply;
import edu.emory.mathcs.csparsej.tfloat.Scs_transpose;
import edu.emory.mathcs.csparsej.tfloat.Scs_util;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Scs_common.Scs scs;
    protected boolean rowIndexesSorted;

    public SparseCCFloatMatrix2D(float[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCFloatMatrix2D(Scs_common.Scs dcs) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(dcs.m, dcs.n);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.scs = dcs;
    }

    public SparseCCFloatMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCFloatMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.scs = Scs_util.cs_spalloc(rows, columns, nzmax, true, false);
    }

    public SparseCCFloatMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float value, boolean removeDuplicates, boolean sortRowIndexes) {
        block9: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block9;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.scs = Scs_util.cs_spalloc(rows, columns, nz, true, false);
        int[] w = new int[columns];
        int[] Cp = this.scs.p;
        int[] Ci = this.scs.i;
        float[] Cx = this.scs.x;
        for (int k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        Scs_cumsum.cs_cumsum(Cp, w, columns);
        for (int k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            Ci[p] = rowIndexes[k];
            if (Cx == null) continue;
            Cx[p] = value;
        }
        if (removeDuplicates && !Scs_dupl.cs_dupl(this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (sortRowIndexes) {
            this.scs = Scs_transpose.cs_transpose(this.scs, true);
            this.scs = Scs_transpose.cs_transpose(this.scs, true);
            if (this.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public SparseCCFloatMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortRowIndexes) {
        block10: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block10;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.scs = Scs_util.cs_spalloc(rows, columns, nz, true, false);
        int[] w = new int[columns];
        int[] Cp = this.scs.p;
        int[] Ci = this.scs.i;
        float[] Cx = this.scs.x;
        for (int k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
        }
        Scs_cumsum.cs_cumsum(Cp, w, columns);
        for (int k = 0; k < nz; ++k) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            Ci[p] = rowIndexes[k];
            if (Cx == null) continue;
            Cx[p] = values[k];
        }
        if (removeZeroes) {
            Scs_dropzeros.cs_dropzeros(this.scs);
        }
        if (removeDuplicates && !Scs_dupl.cs_dupl(this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (sortRowIndexes) {
            this.scs = Scs_transpose.cs_transpose(this.scs, true);
            this.scs = Scs_transpose.cs_transpose(this.scs, true);
            if (this.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public FloatMatrix2D assign(final FloatFunction function) {
        if (function instanceof FloatMult) {
            float alpha = ((FloatMult)function).multiplicator;
            if (alpha == 1.0f) {
                return this;
            }
            if (alpha == 0.0f) {
                return this.assign(0.0f);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            float[] valuesE = this.scs.x;
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                valuesE[n] = valuesE[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int i, int j, float value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(float value) {
        if (value == 0.0f) {
            Arrays.fill(this.scs.i, 0);
            Arrays.fill(this.scs.p, 0);
            Arrays.fill(this.scs.x, 0.0f);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.scs.x[i] = value;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCFloatMatrix2D) {
            SparseCCFloatMatrix2D other = (SparseCCFloatMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.scs.p, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.scs.nzmax < nzmax) {
                this.scs.i = new int[nzmax];
                this.scs.x = new float[nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.scs.i, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.scs.x, 0, nzmax);
            this.rowIndexesSorted = other.rowIndexesSorted;
        } else if (source instanceof SparseRCFloatMatrix2D) {
            SparseRCFloatMatrix2D other = ((SparseRCFloatMatrix2D)source).getTranspose();
            this.scs.p = other.getRowPointers();
            this.scs.i = other.getColumnIndexes();
            this.scs.x = other.getValues();
            this.scs.nzmax = this.scs.x.length;
            this.rowIndexesSorted = true;
        } else {
            this.assign(0.0f);
            source.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int i, int j, float value) {
                    SparseCCFloatMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D y, FloatFloatFunction function) {
        this.checkShape(y);
        if (y instanceof SparseCCFloatMatrix2D && function == FloatFunctions.plus) {
            SparseCCFloatMatrix2D yy = (SparseCCFloatMatrix2D)y;
            this.scs = Scs_add.cs_add(this.scs, yy.scs, 1.0f, 1.0f);
            return this;
        }
        if (function instanceof FloatPlusMultSecond) {
            final float alpha = ((FloatPlusMultSecond)function).multiplicator;
            if (alpha == 0.0f) {
                return this;
            }
            y.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int i, int j, float value) {
                    SparseCCFloatMatrix2D.this.setQuick(i, j, SparseCCFloatMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof FloatPlusMultFirst) {
            final float alpha = ((FloatPlusMultFirst)function).multiplicator;
            if (alpha == 0.0f) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int i, int j, float value) {
                    SparseCCFloatMatrix2D.this.setQuick(i, j, alpha * SparseCCFloatMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == FloatFunctions.mult) {
            int[] rowIndexesA = this.scs.i;
            int[] columnPointersA = this.scs.p;
            float[] valuesA = this.scs.x;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] * y.getQuick(i, j);
                    if (valuesA[k] != 0.0f) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == FloatFunctions.div) {
            int[] rowIndexesA = this.scs.i;
            int[] columnPointersA = this.scs.p;
            float[] valuesA = this.scs.x;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] / y.getQuick(i, j);
                    if (valuesA[k] != 0.0f) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    public int cardinality() {
        return this.scs.p[this.columns];
    }

    public Scs_common.Scs elements() {
        return this.scs;
    }

    public FloatMatrix2D forEachNonZero(IntIntFloatFunction function) {
        int[] rowIndexesA = this.scs.i;
        int[] columnPointersA = this.scs.p;
        float[] valuesA = this.scs.x;
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                float r;
                int i = rowIndexesA[k];
                float value = valuesA[k];
                valuesA[k] = r = function.apply(i, j, value);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.scs.p;
    }

    public DenseFloatMatrix2D getDense() {
        final DenseFloatMatrix2D dense = new DenseFloatMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFloatFunction(){

            public float apply(int i, int j, float value) {
                dense.setQuick(i, j, SparseCCFloatMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    public synchronized float getQuick(int row, int column) {
        int k = SparseCCFloatMatrix2D.searchFromTo(this.scs.i, row, this.scs.p[column], this.scs.p[column + 1] - 1);
        float v = 0.0f;
        if (k >= 0) {
            v = this.scs.x[k];
        }
        return v;
    }

    public SparseRCFloatMatrix2D getRowCompressed() {
        Scs_common.Scs dcst = Scs_transpose.cs_transpose(this.scs, true);
        SparseRCFloatMatrix2D rc = new SparseRCFloatMatrix2D(this.rows, this.columns);
        rc.columnIndexes = dcst.i;
        rc.rowPointers = dcst.p;
        rc.values = dcst.x;
        rc.columnIndexesSorted = true;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.scs.i;
    }

    public SparseCCFloatMatrix2D getTranspose() {
        Scs_common.Scs dcst = Scs_transpose.cs_transpose(this.scs, true);
        SparseCCFloatMatrix2D tr = new SparseCCFloatMatrix2D(this.columns, this.rows);
        tr.scs = dcst;
        return tr;
    }

    public float[] getValues() {
        return this.scs.x;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public FloatMatrix2D like(int rows, int columns) {
        return new SparseCCFloatMatrix2D(rows, columns);
    }

    public FloatMatrix1D like1D(int size) {
        return new SparseFloatMatrix1D(size);
    }

    public synchronized void setQuick(int row, int column, float value) {
        int k = SparseCCFloatMatrix2D.searchFromTo(this.scs.i, row, this.scs.p[column], this.scs.p[column + 1] - 1);
        if (k >= 0) {
            if (value == 0.0f) {
                this.remove(column, k);
            } else {
                this.scs.x[k] = value;
            }
            return;
        }
        if (value != 0.0f) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortRowIndexes() {
        this.scs = Scs_transpose.cs_transpose(this.scs, true);
        this.scs = Scs_transpose.cs_transpose(this.scs, true);
        if (this.scs == null) {
            throw new IllegalArgumentException("Exception occured in cs_transpose()!");
        }
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        if (!Scs_dupl.cs_dupl(this.scs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
    }

    public void removeZeroes() {
        Scs_dropzeros.cs_dropzeros(this.scs);
    }

    public void trimToSize() {
        Scs_util.cs_sprealloc(this.scs, 0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int high = this.scs.p[i + 1];
            for (int j = this.scs.p[i]; j < high; ++j) {
                builder.append('(').append(this.scs.i[j]).append(',').append(i).append(')').append('\t').append(this.scs.x[j]).append('\n');
            }
        }
        return builder.toString();
    }

    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z, final float alpha, final float beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || transposeA;
        if (z == null) {
            z = new DenseFloatMatrix1D(rowsA);
        }
        if (!(y instanceof DenseFloatMatrix1D) || !(z instanceof DenseFloatMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseFloatMatrix1D zz = (DenseFloatMatrix1D)z;
        final float[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)zz.index(0);
        DenseFloatMatrix1D yy = (DenseFloatMatrix1D)y;
        final float[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)yy.index(0);
        final int[] rowIndexesA = this.scs.i;
        final int[] columnPointersA = this.scs.p;
        final float[] valuesA = this.scs.x;
        int zidx = zeroZ;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (!transposeA) {
            if (!ignore && (double)(beta / alpha) != 1.0) {
                z.assign(FloatFunctions.mult(beta / alpha));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                int j;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final float[] result = new float[rowsA];
                int k = this.columns / nthreads;
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final int firstColumn = j2 * k;
                    final int lastColumn = j2 == nthreads - 1 ? this.columns : firstColumn + k;
                    final int threadID = j2;
                    futures[j2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (threadID == 0) {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    float yElem = elementsY[zeroY + strideY * i];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j = rowIndexesA[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + valuesA[k] * yElem;
                                    }
                                }
                            } else {
                                for (int i = firstColumn; i < lastColumn; ++i) {
                                    int high = columnPointersA[i + 1];
                                    float yElem = elementsY[zeroY + strideY * i];
                                    for (int k = columnPointersA[i]; k < high; ++k) {
                                        int j;
                                        int n = j = rowIndexesA[k];
                                        result[n] = result[n] + valuesA[k] * yElem;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (j = rem = rowsA % 10; j < rowsA; j += 10) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                    int n2 = zeroZ + (j + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j + 1];
                    int n3 = zeroZ + (j + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j + 2];
                    int n4 = zeroZ + (j + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j + 3];
                    int n5 = zeroZ + (j + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j + 4];
                    int n6 = zeroZ + (j + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j + 5];
                    int n7 = zeroZ + (j + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j + 6];
                    int n8 = zeroZ + (j + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j + 7];
                    int n9 = zeroZ + (j + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j + 8];
                    int n10 = zeroZ + (j + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j + 9];
                }
                for (j = 0; j < rem; ++j) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int high = columnPointersA[i + 1];
                    float yElem = elementsY[zeroY + strideY * i];
                    for (int k = columnPointersA[i]; k < high; ++k) {
                        int j = rowIndexesA[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + valuesA[k] * yElem;
                    }
                }
            }
            if ((double)alpha != 1.0) {
                z.assign(FloatFunctions.mult(alpha));
            }
        } else if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int zidx = zeroZ + firstColumn * strideZ;
                        int k = SparseCCFloatMatrix2D.this.scs.p[firstColumn];
                        for (int i = firstColumn; i < lastColumn; ++i) {
                            float sum = 0.0f;
                            int high = SparseCCFloatMatrix2D.this.scs.p[i + 1];
                            while (k + 10 < high) {
                                int ind = k + 9;
                                sum += valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCFloatMatrix2D.this.scs.i[ind--]];
                                k += 10;
                            }
                            while (k < high) {
                                sum += valuesA[k] * elementsY[SparseCCFloatMatrix2D.this.scs.i[k]];
                                ++k;
                            }
                            elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                            zidx += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int k = this.scs.p[0];
            for (int i = 0; i < this.columns; ++i) {
                float sum = 0.0f;
                int high = this.scs.p[i + 1];
                while (k + 10 < high) {
                    int ind = k + 9;
                    sum += valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.scs.i[ind--]];
                    k += 10;
                }
                while (k < high) {
                    sum += valuesA[k] * elementsY[this.scs.i[k]];
                    ++k;
                }
                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                zidx += strideZ;
            }
        }
        return z;
    }

    public FloatMatrix2D zMult(FloatMatrix2D B, FloatMatrix2D C, float alpha, float beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseCCFloatMatrix2D ? new SparseCCFloatMatrix2D(rowsA, p, rowsA * p) : new DenseFloatMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && (double)beta != 1.0) {
            C.assign(FloatFunctions.mult(beta));
        }
        if (B instanceof DenseFloatMatrix2D && C instanceof DenseFloatMatrix2D) {
            SparseCCFloatMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseFloatMatrix2D BB = transposeB ? (DenseFloatMatrix2D)B.viewDice() : (DenseFloatMatrix2D)B;
            DenseFloatMatrix2D CC = (DenseFloatMatrix2D)C;
            int[] columnPointersA = AA.scs.p;
            int[] rowIndexesA = AA.scs.i;
            float[] valuesA = AA.scs.x;
            int zeroB = (int)BB.index(0, 0);
            int rowStrideB = BB.rowStride();
            int columnStrideB = BB.columnStride();
            float[] elementsB = BB.elements;
            int zeroC = (int)CC.index(0, 0);
            int rowStrideC = CC.rowStride();
            int columnStrideC = CC.columnStride();
            float[] elementsC = CC.elements;
            for (int jj = 0; jj < columnsB; ++jj) {
                for (int kk = 0; kk < columnsA; ++kk) {
                    int high = columnPointersA[kk + 1];
                    float yElem = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB];
                    for (int ii = columnPointersA[kk]; ii < high; ++ii) {
                        int j = rowIndexesA[ii];
                        int n = zeroC + j * rowStrideC + jj * columnStrideC;
                        elementsC[n] = elementsC[n] + valuesA[ii] * yElem;
                    }
                }
            }
            if ((double)alpha != 1.0) {
                C.assign(FloatFunctions.mult(alpha));
            }
        } else if (B instanceof SparseCCFloatMatrix2D && C instanceof SparseCCFloatMatrix2D) {
            SparseCCFloatMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseCCFloatMatrix2D BB = (SparseCCFloatMatrix2D)B;
            if (transposeB) {
                BB = BB.getTranspose();
            }
            SparseCCFloatMatrix2D CC = (SparseCCFloatMatrix2D)C;
            CC.scs = Scs_multiply.cs_multiply(AA.scs, BB.scs);
            if (CC.scs == null) {
                throw new IllegalArgumentException("Exception occured in cs_multiply()");
            }
            if ((double)alpha != 1.0) {
                CC.assign(FloatFunctions.mult(alpha));
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            FloatMatrix1D[] Brows = new FloatMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            FloatMatrix1D[] Crows = new FloatMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            FloatPlusMultSecond fun = FloatPlusMultSecond.plusMult(0.0f);
            int[] rowIndexesA = this.scs.i;
            int[] columnPointersA = this.scs.p;
            float[] valuesA = this.scs.x;
            int i3 = this.columns;
            while (--i3 >= 0) {
                int low = columnPointersA[i3];
                int k = columnPointersA[i3 + 1];
                while (--k >= low) {
                    int j = rowIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[j].assign(Brows[i3], fun);
                        continue;
                    }
                    Crows[i3].assign(Brows[j], fun);
                }
            }
        }
        return C;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, float value) {
        IntArrayList rowIndexes = new IntArrayList(this.scs.i);
        rowIndexes.setSizeRaw(this.scs.p[this.columns]);
        FloatArrayList values = new FloatArrayList(this.scs.x);
        values.setSizeRaw(this.scs.p[this.columns]);
        rowIndexes.beforeInsert(index, row);
        values.beforeInsert(index, value);
        int i = this.scs.p.length;
        while (--i > column) {
            int n = i;
            this.scs.p[n] = this.scs.p[n] + 1;
        }
        this.scs.i = rowIndexes.elements();
        this.scs.x = values.elements();
        this.scs.nzmax = rowIndexes.elements().length;
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexes = new IntArrayList(this.scs.i);
        FloatArrayList values = new FloatArrayList(this.scs.x);
        rowIndexes.remove(index);
        values.remove(index);
        int i = this.scs.p.length;
        while (--i > column) {
            int n = i;
            this.scs.p[n] = this.scs.p[n] - 1;
        }
        this.scs.i = rowIndexes.elements();
        this.scs.x = values.elements();
        this.scs.nzmax = rowIndexes.elements().length;
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }
}

