/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;

public class FloatILU
implements FloatPreconditioner {
    private SparseRCFloatMatrix2D LU;
    private final FloatMatrix1D y;
    private int[] diagind;
    private final int n;

    public FloatILU(int n) {
        this.n = n;
        this.y = new DenseFloatMatrix1D(n);
    }

    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.lowerUnitSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.loverUnitTransSolve(this.y, x);
    }

    public void setMatrix(FloatMatrix2D A) {
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCFloatMatrix2D(this.n, this.n);
        this.LU.assign(A);
        if (!this.LU.hasColumnIndexesSorted()) {
            this.LU.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        float[] data = this.LU.getValues();
        this.diagind = this.findDiagonalIndexes(this.n, colind, rowptr);
        for (int k = 1; k < this.n; ++k) {
            for (int i = rowptr[k]; i < this.diagind[k]; ++i) {
                int index = colind[i];
                float LUii = data[this.diagind[index]];
                if (LUii == 0.0f) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ILU process");
                }
                int n = i;
                float f = data[n] / LUii;
                data[n] = f;
                float LUki = f;
                int l = rowptr[k] + 1;
                for (int j = this.diagind[index] + 1; j < rowptr[index + 1]; ++j) {
                    while (l < rowptr[k + 1] && colind[l] < colind[j]) {
                        ++l;
                    }
                    if (colind[l] != colind[j]) continue;
                    int n2 = l;
                    data[n2] = data[n2] - LUki * data[j];
                }
            }
        }
    }

    private int[] findDiagonalIndexes(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        for (int k = 0; k < m; ++k) {
            diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
        }
        return diagind;
    }

    private FloatMatrix1D lowerUnitSolve(FloatMatrix1D b, FloatMatrix1D x) {
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        float[] data = this.LU.getValues();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            float sum = 0.0f;
            for (int j = rowptr[i]; j < this.diagind[i]; ++j) {
                sum += data[j] * xd[colind[j]];
            }
            xd[i] = bd[i] - sum;
        }
        return x;
    }

    private FloatMatrix1D loverUnitTransSolve(FloatMatrix1D b, FloatMatrix1D x) {
        x.assign(b);
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        float[] data = this.LU.getValues();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            for (int j = rowptr[i]; j < this.diagind[i]; ++j) {
                int n = colind[j];
                xd[n] = xd[n] - data[j] * xd[i];
            }
        }
        return x;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D b, FloatMatrix1D x) {
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        float[] data = this.LU.getValues();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            float sum = 0.0f;
            for (int j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                sum += data[j] * xd[colind[j]];
            }
            xd[i] = (bd[i] - sum) / data[this.diagind[i]];
        }
        return x;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D b, FloatMatrix1D x) {
        x.assign(b);
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.LU.getColumnIndexes();
        int[] rowptr = this.LU.getRowPointers();
        float[] data = this.LU.getValues();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            int n = i;
            xd[n] = xd[n] / data[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < rowptr[i + 1]; ++j) {
                int n2 = colind[j];
                xd[n2] = xd[n2] - data[j] * xd[i];
            }
        }
        return x;
    }
}

