/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatIR
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D z;
    private FloatMatrix1D r;

    public FloatIR(FloatMatrix1D template) {
        this.z = template.copy();
        this.r = template.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            x.assign(this.z, FloatFunctions.plus);
            A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
            this.iter.next();
        }
        return x;
    }
}

