/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatSingularValueDecomposition;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.HyBRFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.stat.tfloat.FloatDescriptive;
import optimization.FloatFmin;
import optimization.FloatFmin_methods;

public class FloatHyBR
extends AbstractFloatIterativeSolver {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private float regPar;
    private float omega;
    private boolean reorth;
    private int begReg;
    private float flatTol;
    private boolean computeRnrm;
    private static final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
    private static final float FMIN_TOL = 1.0E-4f;

    public FloatHyBR() {
        this(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0f, 0.0f, false, 2, 1.0E-4f, false);
    }

    public FloatHyBR(HyBRInnerSolver innerSolver, HyBRRegularizationMethod regularizationMethod, float regularizationParameter, float omega, boolean reorthogonalize, int beginRegularization, float flatTolerance, boolean computeRnrm) {
        this.innerSolver = innerSolver;
        this.regMethod = regularizationMethod;
        if ((double)regularizationParameter < 0.0 || (double)regularizationParameter > 1.0) {
            throw new IllegalArgumentException("regularizationParameter must be a number between 0 and 1.");
        }
        this.regPar = regularizationParameter;
        if ((double)omega < 0.0) {
            throw new IllegalArgumentException("omega must be a nonnegative number.");
        }
        this.omega = omega;
        this.reorth = reorthogonalize;
        if (beginRegularization < 2) {
            throw new IllegalArgumentException("beginRegularization must be greater or equal 2");
        }
        this.begReg = beginRegularization;
        if ((double)flatTolerance < 0.0) {
            throw new IllegalArgumentException("flatTolerance must be a nonnegative number.");
        }
        this.flatTol = flatTolerance;
        this.computeRnrm = computeRnrm;
        this.iter = new HyBRFloatIterationMonitor();
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        FloatLBD lbd;
        FloatMatrix1D work;
        if (!(this.iter instanceof HyBRFloatIterationMonitor)) {
            this.iter = new HyBRFloatIterationMonitor();
        }
        this.checkSizes(A, b, x);
        int rows = A.rows();
        int columns = A.columns();
        boolean bump = false;
        boolean warning = false;
        float rnrm = -1.0f;
        int iterationsSave = 0;
        float alpha = 0.0f;
        float alphaSave = 0.0f;
        float beta = 0.0f;
        HyBRInnerSolver inSolver = HyBRInnerSolver.NONE;
        FloatMatrix1D f = null;
        DenseFloatMatrix1D xSave = null;
        FloatArrayList omegaList = new FloatArrayList(new float[this.begReg - 2]);
        FloatArrayList GCV = new FloatArrayList(new float[this.begReg - 2]);
        FloatMatrix2D U = new DenseFloatMatrix2D(1, (int)b.size());
        FloatMatrix2D C = null;
        FloatMatrix2D V = null;
        if (this.computeRnrm) {
            work = b.copy();
            A.zMult(x, work, -1.0f, 1.0f, false);
            rnrm = alg.norm2(work);
        }
        if (this.M instanceof FloatIdentity) {
            beta = alg.norm2(b);
            U.viewRow(0).assign(b, FloatFunctions.multSecond(1.0f / beta));
            lbd = new FloatSimpleLBD(A, U, this.reorth);
        } else {
            work = new DenseFloatMatrix1D((int)b.size());
            work = this.M.apply(b, work);
            beta = alg.norm2(work);
            U.viewRow(0).assign(work, FloatFunctions.multSecond(1.0f / beta));
            lbd = new FloatPLBD(this.M, A, U, this.reorth);
        }
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            lbd.apply();
            U = lbd.getU();
            C = lbd.getC();
            V = lbd.getV();
            DenseFloatMatrix1D v = new DenseFloatMatrix1D(C.columns() + 1);
            ((FloatMatrix1D)v).setQuick(0, beta);
            int i = this.iter.iterations();
            if (i >= 1) {
                if (i >= this.begReg - 1) {
                    inSolver = this.innerSolver;
                }
                switch (inSolver) {
                    case TIKHONOV: {
                        DenseFloatSingularValueDecomposition svd = alg.svd(C);
                        FloatMatrix2D Ub = svd.getU();
                        float[] sv = svd.getSingularValues();
                        FloatMatrix2D Vb = svd.getV();
                        if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                            work = new DenseFloatMatrix1D(Ub.rows());
                            Ub.zMult(v, work, 1.0f, 0.0f, true);
                            omegaList.add(Math.min(1.0f, this.findOmega(work, sv)));
                            this.omega = FloatDescriptive.mean(omegaList);
                        }
                        f = new DenseFloatMatrix1D(Vb.rows());
                        alpha = this.tikhonovSolver(Ub, sv, Vb, v, f);
                        ((HyBRFloatIterationMonitor)this.iter).setRegularizationParameter(alpha);
                        GCV.add(this.GCVstopfun(alpha, Ub.viewRow(0), sv, beta, rows, columns));
                        if (i <= 1) break;
                        if (Math.abs(GCV.getQuick(i - 1) - GCV.getQuick(i - 2)) / GCV.get(this.begReg - 2) < this.flatTol) {
                            V.zMult(f, x);
                            ((HyBRFloatIterationMonitor)this.iter).setStoppingCondition(HyBRFloatIterationMonitor.HyBRStoppingCondition.FLAT_GCV_CURVE);
                            if (this.computeRnrm) {
                                work = b.copy();
                                A.zMult(x, work, -1.0f, 1.0f, false);
                                ((HyBRFloatIterationMonitor)this.iter).residual = alg.norm2(work);
                            }
                            return x;
                        }
                        if (warning && GCV.size() > iterationsSave + 3) {
                            for (int j = iterationsSave; j < GCV.size(); ++j) {
                                if (!(GCV.getQuick(iterationsSave - 1) > GCV.get(j))) continue;
                                bump = true;
                            }
                            if (!bump) {
                                x.assign(xSave);
                                ((HyBRFloatIterationMonitor)this.iter).setStoppingCondition(HyBRFloatIterationMonitor.HyBRStoppingCondition.MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS);
                                ((HyBRFloatIterationMonitor)this.iter).iter = iterationsSave;
                                if (this.computeRnrm) {
                                    work = b.copy();
                                    A.zMult(x, work, -1.0f, 1.0f, false);
                                    ((HyBRFloatIterationMonitor)this.iter).residual = alg.norm2(work);
                                }
                                ((HyBRFloatIterationMonitor)this.iter).setRegularizationParameter(alphaSave);
                                return x;
                            }
                            bump = false;
                            warning = false;
                            iterationsSave = this.iter.getMaxIterations();
                            break;
                        }
                        if (warning || !(GCV.get(i - 2) < GCV.get(i - 1))) break;
                        warning = true;
                        xSave = new DenseFloatMatrix1D(V.rows());
                        alphaSave = alpha;
                        V.zMult(f, xSave);
                        iterationsSave = i;
                        break;
                    }
                    case NONE: {
                        f = alg.solve(C, v);
                    }
                }
                V.zMult(f, x);
                if (this.computeRnrm) {
                    work = b.copy();
                    A.zMult(x, work, -1.0f, 1.0f, false);
                    rnrm = alg.norm2(work);
                }
            }
            this.iter.next();
        }
        return x;
    }

    protected void checkSizes(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) {
        if (b.size() != (long)A.rows()) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (x.size() != (long)A.columns()) {
            throw new IllegalArgumentException("x.size() != A.columns()");
        }
    }

    private float findOmega(FloatMatrix1D bhat, float[] s) {
        int m = (int)bhat.size();
        int n = s.length;
        float alpha = s[n - 1];
        float t0 = bhat.viewPart(n, m - n).aggregate(FloatFunctions.plus, FloatFunctions.square);
        DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(s);
        ((FloatMatrix1D)s2).assign(FloatFunctions.square);
        float alpha2 = alpha * alpha;
        FloatMatrix1D tt = s2.copy();
        tt.assign(FloatFunctions.plus(alpha2));
        tt.assign(FloatFunctions.inv);
        float t1 = ((FloatMatrix1D)s2).aggregate(tt, FloatFunctions.plus, FloatFunctions.mult);
        s2 = new DenseFloatMatrix1D(s);
        ((FloatMatrix1D)s2).assign(FloatFunctions.mult(alpha));
        ((FloatMatrix1D)s2).assign(bhat.viewPart(0, n), FloatFunctions.mult);
        ((FloatMatrix1D)s2).assign(FloatFunctions.square);
        FloatMatrix1D work = tt.copy();
        work.assign(FloatFunctions.pow(3.0f));
        work.assign(FloatFunctions.abs);
        float t3 = work.aggregate(s2, FloatFunctions.plus, FloatFunctions.mult);
        work = new DenseFloatMatrix1D(s);
        work.assign(tt, FloatFunctions.mult);
        float t4 = work.aggregate(FloatFunctions.plus, FloatFunctions.square);
        work = tt.copy();
        work.assign(bhat.viewPart(0, n), FloatFunctions.mult);
        work.assign(FloatFunctions.mult(alpha2));
        float t5 = work.aggregate(FloatFunctions.plus, FloatFunctions.square);
        s2 = new DenseFloatMatrix1D(s);
        ((FloatMatrix1D)s2).assign(bhat.viewPart(0, n), FloatFunctions.mult);
        ((FloatMatrix1D)s2).assign(FloatFunctions.square);
        tt.assign(FloatFunctions.pow(3.0f));
        tt.assign(FloatFunctions.abs);
        float v2 = tt.aggregate(s2, FloatFunctions.plus, FloatFunctions.mult);
        return (float)m * alpha2 * v2 / (t1 * t3 + t4 * (t5 + t0));
    }

    private float tikhonovSolver(FloatMatrix2D U, float[] s, FloatMatrix2D V, FloatMatrix1D b, FloatMatrix1D x) {
        FloatMatrix1D bhat = new DenseFloatMatrix1D(U.rows());
        U.zMult(b, bhat, 1.0f, 0.0f, true);
        float alpha = 0.0f;
        switch (this.regMethod) {
            case GCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, 1.0f);
                alpha = FloatFmin.fmin(0.0f, s[0], fmin, 1.0E-4f);
                break;
            }
            case WGCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, this.omega);
                alpha = FloatFmin.fmin(0.0f, s[0], fmin, 1.0E-4f);
                break;
            }
            case ADAPTWGCV: {
                TikFmin2D fmin = new TikFmin2D(bhat, s, this.omega);
                alpha = FloatFmin.fmin(0.0f, s[0], fmin, 1.0E-4f);
                break;
            }
            case NONE: {
                alpha = this.regPar;
            }
        }
        DenseFloatMatrix1D d = new DenseFloatMatrix1D(s);
        ((FloatMatrix1D)d).assign(FloatFunctions.square);
        ((FloatMatrix1D)d).assign(FloatFunctions.plus(alpha * alpha));
        bhat = bhat.viewPart(0, s.length);
        DenseFloatMatrix1D S = new DenseFloatMatrix1D(s);
        bhat.assign(S, FloatFunctions.mult);
        bhat.assign(d, FloatFunctions.div);
        V.zMult(bhat, x);
        return alpha;
    }

    private float GCVstopfun(float alpha, FloatMatrix1D u, float[] s, float beta, int rows, int columns) {
        int k = s.length;
        float beta2 = beta * beta;
        DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(s);
        ((FloatMatrix1D)s2).assign(FloatFunctions.square);
        float alpha2 = alpha * alpha;
        FloatMatrix1D t1 = s2.copy();
        t1.assign(FloatFunctions.plus(alpha2));
        t1.assign(FloatFunctions.inv);
        FloatMatrix1D t2 = t1.copy();
        t2.assign(u.viewPart(0, k), FloatFunctions.mult);
        t2.assign(FloatFunctions.mult(alpha2));
        float num = (float)((double)beta2 * ((double)t2.aggregate(FloatFunctions.plus, FloatFunctions.square) + Math.pow(Math.abs(u.getQuick(k)), 2.0)) / (double)columns);
        float den = ((float)rows - t1.aggregate(s2, FloatFunctions.plus, FloatFunctions.mult)) / (float)columns;
        den *= den;
        return num / den;
    }

    private class FloatPLBD
    implements FloatLBD {
        private final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatPreconditioner M;
        private final FloatMatrix2D A;
        private FloatMatrix2D C;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public FloatPLBD(FloatPreconditioner M, FloatMatrix2D A, FloatMatrix2D U, boolean reorth) {
            this.M = M;
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D row = null;
                if (k == 1) {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0f, 0.0f, true);
                } else {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0f, 0.0f, true);
                    row = this.V.viewColumn(k - 2);
                    v.assign(row, FloatFunctions.plusMultSecond(-this.C.getQuick(k - 1, k - 2)));
                    for (int j = 0; j < k - 1; ++j) {
                        row = this.V.viewColumn(j);
                        v.assign(row, FloatFunctions.plusMultSecond(-row.zDotProduct(v)));
                    }
                }
                float alpha = this.alg.norm2(v);
                v.assign(FloatFunctions.div(alpha));
                row = this.A.zMult(v, row);
                u = this.M.apply(row, u);
                row = this.U.viewRow(k - 1);
                u.assign(row, FloatFunctions.plusMultSecond(-alpha));
                for (int j = 0; j < k; ++j) {
                    row = this.U.viewRow(j);
                    u.assign(row, FloatFunctions.plusMultSecond(-row.zDotProduct(u)));
                }
                float beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div(beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D row = null;
                if (this.counter == 1) {
                    row = this.U.viewRow(0).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0f, 0.0f, true);
                } else {
                    row = this.U.viewRow(0).copy();
                    row = this.M.transApply(row, row);
                    v = this.A.zMult(row, v, 1.0f, 0.0f, true);
                    row = this.V.viewColumn(this.counter - 2);
                    v.assign(row, FloatFunctions.plusMultSecond(-this.C.getQuick(this.counter - 1, this.counter - 2)));
                }
                float alpha = this.alg.norm2(v);
                v.assign(FloatFunctions.div(alpha));
                row = this.A.zMult(v, row);
                u = this.M.apply(row, u);
                row = this.U.viewRow(0);
                u.assign(row, FloatFunctions.plusMultSecond(-alpha));
                float beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div(beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public FloatMatrix2D getC() {
            return this.C;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private class FloatSimpleLBD
    implements FloatLBD {
        private final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatMatrix2D A;
        private FloatMatrix2D C;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public FloatSimpleLBD(FloatMatrix2D A, FloatMatrix2D U, boolean reorth) {
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D column = null;
                if (k == 1) {
                    v = this.A.zMult(this.U.viewRow(k - 1), v, 1.0f, 0.0f, true);
                } else {
                    v = this.A.zMult(this.U.viewRow(k - 1), v, 1.0f, 0.0f, true);
                    column = this.V.viewColumn(k - 2);
                    v.assign(column, FloatFunctions.plusMultSecond(-this.C.getQuick(k - 1, k - 2)));
                    for (int j = 0; j < k - 1; ++j) {
                        column = this.V.viewColumn(j);
                        v.assign(column, FloatFunctions.plusMultSecond(-column.zDotProduct(v)));
                    }
                }
                float alpha = this.alg.norm2(v);
                v.assign(FloatFunctions.div(alpha));
                u = this.A.zMult(v, u);
                column = this.U.viewRow(k - 1);
                u.assign(column, FloatFunctions.plusMultSecond(-alpha));
                for (int j = 0; j < k; ++j) {
                    column = this.U.viewRow(j);
                    u.assign(column, FloatFunctions.plusMultSecond(-column.zDotProduct(u)));
                }
                float beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div(beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D column = null;
                if (this.counter == 1) {
                    v = this.A.zMult(this.U.viewRow(0), v, 1.0f, 0.0f, true);
                } else {
                    v = this.A.zMult(this.U.viewRow(0), v, 1.0f, 0.0f, true);
                    column = this.V.viewColumn(this.counter - 2);
                    v.assign(column, FloatFunctions.plusMultSecond(-this.C.getQuick(this.counter - 1, this.counter - 2)));
                }
                float alpha = this.alg.norm2(v);
                v.assign(FloatFunctions.div(alpha));
                u = this.A.zMult(v, u);
                column = this.U.viewRow(0);
                u.assign(column, FloatFunctions.plusMultSecond(-alpha));
                float beta = this.alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div(beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public FloatMatrix2D getC() {
            return this.C;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private static interface FloatLBD {
        public void apply();

        public FloatMatrix2D getC();

        public FloatMatrix2D getU();

        public FloatMatrix2D getV();
    }

    private static class TikFmin2D
    implements FloatFmin_methods {
        FloatMatrix1D bhat;
        float[] s;
        float omega;

        public TikFmin2D(FloatMatrix1D bhat, float[] s, float omega) {
            this.bhat = bhat;
            this.s = s;
            this.omega = omega;
        }

        public float f_to_minimize(float alpha) {
            int m = (int)this.bhat.size();
            int n = this.s.length;
            float t0 = this.bhat.viewPart(n, m - n).aggregate(FloatFunctions.plus, FloatFunctions.square);
            DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(this.s);
            ((FloatMatrix1D)s2).assign(FloatFunctions.square);
            float alpha2 = alpha * alpha;
            FloatMatrix1D work = s2.copy();
            work.assign(FloatFunctions.plus(alpha2));
            work.assign(FloatFunctions.inv);
            FloatMatrix1D t1 = work.copy();
            t1.assign(FloatFunctions.mult(alpha2));
            FloatMatrix1D t2 = t1.copy();
            t2.assign(this.bhat.viewPart(0, n), FloatFunctions.mult);
            FloatMatrix1D t3 = work.copy();
            t3.assign(s2, FloatFunctions.mult);
            t3.assign(FloatFunctions.mult(1.0f - this.omega));
            float denom = t3.aggregate(t1, FloatFunctions.plus, FloatFunctions.plus) + (float)m - (float)n;
            return (float)n * (t2.aggregate(FloatFunctions.plus, FloatFunctions.square) + t0) / (denom * denom);
        }
    }
}

