/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;

public class WrapperFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix1D content;

    public WrapperFComplexMatrix1D(FComplexMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    protected FComplexMatrix1D getContent() {
        return this.content;
    }

    public synchronized float[] getQuick(int index) {
        return this.content.getQuick(index);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FComplexMatrix1D like(int size) {
        return this.content.like(size);
    }

    public FComplexMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public FComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int index, float[] value) {
        this.content.setQuick(index, value);
    }

    public synchronized void setQuick(int index, float re, float im) {
        this.content.setQuick(index, re, im);
    }

    public FComplexMatrix1D viewFlip() {
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            public synchronized void setQuick(int index, float[] value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            public synchronized void setQuick(int index, float re, float im) {
                this.content.setQuick(this.size - 1 - index, re, im);
            }

            public synchronized float[] get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            public synchronized void set(int index, float[] value) {
                this.content.set(this.size - 1 - index, value);
            }

            public synchronized void set(int index, float re, float im) {
                this.content.set(this.size - 1 - index, re, im);
            }
        };
        return view;
    }

    public FComplexMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            public synchronized void setQuick(int i, float[] value) {
                this.content.setQuick(index + i, value);
            }

            public synchronized void setQuick(int i, float re, float im) {
                this.content.setQuick(index + i, re, im);
            }

            public synchronized float[] get(int i) {
                return this.content.get(index + i);
            }

            public synchronized void set(int i, float[] value) {
                this.content.set(index + i, value);
            }

            public synchronized void set(int i, float re, float im) {
                this.content.set(index + i, re, im);
            }
        };
        view.size = width;
        return view;
    }

    public FComplexMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            public synchronized void setQuick(int i, float[] value) {
                this.content.setQuick(idx[i], value);
            }

            public synchronized void setQuick(int i, float re, float im) {
                this.content.setQuick(idx[i], re, im);
            }

            public synchronized float[] get(int i) {
                return this.content.get(idx[i]);
            }

            public synchronized void set(int i, float[] value) {
                this.content.set(idx[i], value);
            }

            public synchronized void set(int i, float re, float im) {
                this.content.set(idx[i], re, im);
            }
        };
        view.size = indexes.length;
        return view;
    }

    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    public FComplexMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperFComplexMatrix1D view = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            public synchronized void setQuick(int index, float[] value) {
                this.content.setQuick(index * _stride, value);
            }

            public synchronized void setQuick(int index, float re, float im) {
                this.content.setQuick(index * _stride, re, im);
            }

            public synchronized float[] get(int index) {
                return this.content.get(index * _stride);
            }

            public synchronized void set(int index, float[] value) {
                this.content.set(index * _stride, value);
            }

            public synchronized void set(int index, float re, float im) {
                this.content.set(index * _stride, re, im);
            }
        };
        if (this.size != 0) {
            view.size = (this.size - 1) / _stride + 1;
        }
        return view;
    }

    public FloatMatrix1D getImaginaryPart() {
        return this.content.getImaginaryPart();
    }

    public FloatMatrix1D getRealPart() {
        return this.content.getRealPart();
    }
}

