/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseFComplexMatrix3D(ConcurrentHashMap<Long, float[]> elements, int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets, int offset) {
        int slices = sliceOffsets.length;
        int rows = rowOffsets.length;
        int columns = columnOffsets.length;
        this.setUp(slices, rows, columns);
        this.elements = elements;
        this.sliceOffsets = sliceOffsets;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    protected int _sliceOffset(int absRank) {
        return this.sliceOffsets[absRank];
    }

    @Override
    public float[] getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix3D other) {
        if (other instanceof SelectedSparseFComplexMatrix3D) {
            SelectedSparseFComplexMatrix3D otherMatrix = (SelectedSparseFComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFComplexMatrix3D) {
            SparseFComplexMatrix3D otherMatrix = (SparseFComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public FComplexMatrix3D like(int slices, int rows, int columns) {
        return new SparseFComplexMatrix3D(slices, rows, columns);
    }

    @Override
    public FComplexMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected FComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int slice, int row, int column, float[] value) {
        long index = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value[0] == 0.0f && value[1] == 0.0f) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public void setQuick(int slice, int row, int column, float re, float im) {
        long index = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + slice * this.sliceStride] + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (re == 0.0f && im == 0.0f) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, new float[]{re, im});
        }
    }

    @Override
    protected void setUp(int slices, int rows, int columns) {
        super.setUp(slices, rows, columns);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        super.vDice(axis0, axis1, axis2);
        int[][] offsets = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = offsets[axis0];
        this.rowOffsets = offsets[axis1];
        this.columnOffsets = offsets[axis2];
        return this;
    }

    @Override
    public FComplexMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int viewRows = this.slices;
        int viewColumns = this.rows;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.rowZero;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.rowStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.rowOffsets;
        return new SelectedSparseFComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    public FComplexMatrix2D viewRow(int row) {
        this.checkRow(row);
        int viewRows = this.slices;
        int viewColumns = this.columns;
        int viewRowZero = this.sliceZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        int viewRowStride = this.sliceStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.sliceOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedSparseFComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseFComplexMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, this.offset);
    }

    @Override
    public FComplexMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int viewRows = this.rows;
        int viewColumns = this.columns;
        int viewRowZero = this.rowZero;
        int viewColumnZero = this.columnZero;
        int viewOffset = this.offset + this._sliceOffset(this._sliceRank(slice));
        int viewRowStride = this.rowStride;
        int viewColumnStride = this.columnStride;
        int[] viewRowOffsets = this.rowOffsets;
        int[] viewColumnOffsets = this.columnOffsets;
        return new SelectedSparseFComplexMatrix2D(viewRows, viewColumns, this.elements, viewRowZero, viewColumnZero, viewRowStride, viewColumnStride, viewRowOffsets, viewColumnOffsets, viewOffset);
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FloatMatrix3D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

