/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.algo;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.jet.math.tfcomplex.FComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FComplexProperty {
    public static final FComplexProperty DEFAULT = new FComplexProperty(1.0E-5f);
    public static final FComplexProperty ZERO = new FComplexProperty(0.0f);
    public static final FComplexProperty SEVEN = new FComplexProperty(1.0E-7f);
    protected float tolerance;

    private FComplexProperty() {
        this(1.0E-5f);
    }

    public FComplexProperty(float newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    public void setTolerance(float newTolerance) {
        if (this == DEFAULT || this == ZERO || this == SEVEN) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public float tolerance() {
        return this.tolerance;
    }

    public boolean equals(final FComplexMatrix1D A, final float[] value) {
        if (A == null) {
            return false;
        }
        final float epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int size = (int)A.size();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            float[] x = A.getQuick(i);
                            diff[0] = Math.abs(value[0] - x[0]);
                            diff[1] = Math.abs(value[1] - x[1]);
                            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                diff[0] = 0.0f;
                                diff[1] = 0.0f;
                            }
                            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        int i = 0;
        while ((long)i < A.size()) {
            float[] x = A.getQuick(i);
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0f;
                diff[1] = 0.0f;
            }
            if (diff[0] > epsilon || diff[1] > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final FComplexMatrix1D A, final FComplexMatrix1D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int size = (int)A.size();
        if ((long)size != B.size()) {
            return false;
        }
        final float epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            float[] x = A.getQuick(i);
                            float[] value = B.getQuick(i);
                            diff[0] = Math.abs(value[0] - x[0]);
                            diff[1] = Math.abs(value[1] - x[1]);
                            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                diff[0] = 0.0f;
                                diff[1] = 0.0f;
                            }
                            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        for (int i = 0; i < size; ++i) {
            float[] x = A.getQuick(i);
            float[] value = B.getQuick(i);
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0f;
                diff[1] = 0.0f;
            }
            if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FComplexMatrix2D A, final float[] value) {
        if (A == null) {
            return false;
        }
        int rows = A.rows();
        int columns = A.columns();
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < A.columns(); ++c) {
                                float[] x = A.getQuick(r, c);
                                diff[0] = Math.abs(value[0] - x[0]);
                                diff[1] = Math.abs(value[1] - x[1]);
                                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                    diff[0] = 0.0f;
                                    diff[1] = 0.0f;
                                }
                                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                float[] x = A.getQuick(r, c);
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0f;
                    diff[1] = 0.0f;
                }
                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix2D A, final FComplexMatrix2D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int rows = A.rows();
        int columns = A.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < A.columns(); ++c) {
                                float[] x = A.getQuick(r, c);
                                float[] value = B.getQuick(r, c);
                                diff[0] = Math.abs(value[0] - x[0]);
                                diff[1] = Math.abs(value[1] - x[1]);
                                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                    diff[0] = 0.0f;
                                    diff[1] = 0.0f;
                                }
                                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                float[] x = A.getQuick(r, c);
                float[] value = B.getQuick(r, c);
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0f;
                    diff[1] = 0.0f;
                }
                if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix3D A, final float[] value) {
        if (A == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    float[] x = A.getQuick(s, r, c);
                                    diff[0] = Math.abs(value[0] - x[0]);
                                    diff[1] = Math.abs(value[1] - x[1]);
                                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                        diff[0] = 0.0f;
                                        diff[1] = 0.0f;
                                    }
                                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    float[] x = A.getQuick(s, r, c);
                    diff[0] = Math.abs(value[0] - x[0]);
                    diff[1] = Math.abs(value[1] - x[1]);
                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                        diff[0] = 0.0f;
                        diff[1] = 0.0f;
                    }
                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final FComplexMatrix3D A, final FComplexMatrix3D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        boolean result = false;
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        float[] diff = new float[2];
                        for (int s = startslice; s < stopslice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    float[] x = A.getQuick(s, r, c);
                                    float[] value = B.getQuick(s, r, c);
                                    diff[0] = Math.abs(value[0] - x[0]);
                                    diff[1] = Math.abs(value[1] - x[1]);
                                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                                        diff[0] = 0.0f;
                                        diff[1] = 0.0f;
                                    }
                                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        float[] diff = new float[2];
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    float[] x = A.getQuick(s, r, c);
                    float[] value = B.getQuick(s, r, c);
                    diff[0] = Math.abs(value[0] - x[0]);
                    diff[1] = Math.abs(value[1] - x[1]);
                    if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                        diff[0] = 0.0f;
                        diff[1] = 0.0f;
                    }
                    if (!(diff[0] > epsilon) && !(diff[1] > epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

