/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCG
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D z;
    private DoubleMatrix1D q;
    private DoubleMatrix1D r;

    public DoubleCG(DoubleMatrix1D template) {
        this.p = template.copy();
        this.z = template.copy();
        this.q = template.copy();
        this.r = template.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double alpha = 0.0;
        double beta = 0.0;
        double rho = 0.0;
        double rho_1 = 0.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            rho = this.r.zDotProduct(this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
            } else {
                beta = rho / rho_1;
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            alpha = rho / this.p.zDotProduct(this.q);
            x.assign(this.p, DoubleFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-alpha));
            rho_1 = rho;
            this.iter.next();
        }
        return x;
    }
}

