/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseDoubleSingularValueDecomposition {
    private DoubleMatrix2D U;
    private DoubleMatrix2D V;
    private DoubleMatrix2D S;
    private double[] elementsU;
    private double[] elementsVt;
    private double[] elementsS;
    private intW info;
    private int m;
    private int n;
    private int mn;
    private boolean wantWholeUV;
    private boolean wantUV;
    private boolean columnMatrix = false;

    public DenseDoubleSingularValueDecomposition(DoubleMatrix2D A, boolean wantUV, boolean wantWholeUV) {
        double[] elementsA;
        DoubleProperty.DEFAULT.checkDense(A);
        this.wantUV = wantUV;
        this.wantWholeUV = wantWholeUV;
        this.m = A.rows();
        this.n = A.columns();
        if (A instanceof DenseColumnDoubleMatrix2D) {
            elementsA = (double[])A.copy().elements();
            this.columnMatrix = true;
        } else {
            elementsA = (double[])A.viewDice().copy().elements();
        }
        this.mn = Math.min(this.m, this.n);
        int maxmn = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] iwork = new int[8 * this.mn];
        this.elementsS = new double[this.mn];
        wantUV = true;
        if (true) {
            if (wantWholeUV) {
                this.elementsU = new double[this.m * this.m];
                this.elementsVt = new double[this.n * this.n];
                int lwork = 3 * this.mn * this.mn + Math.max(maxmn, 4 * this.mn * this.mn + 4 * this.mn) + maxmn;
                double[] work = new double[lwork];
                LAPACK.getInstance().dgesdd("A", this.m, this.n, elementsA, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.n, work, lwork, iwork, this.info);
            } else {
                this.elementsU = new double[this.m * this.mn];
                this.elementsVt = new double[this.mn * this.n];
                int lwork = 3 * this.mn * this.mn + Math.max(maxmn, 4 * this.mn * this.mn + 4 * this.mn) + maxmn;
                double[] work = new double[lwork];
                LAPACK.getInstance().dgesdd("S", this.m, this.n, elementsA, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.mn, work, lwork, iwork, this.info);
            }
        } else {
            int lwork = 3 * this.mn + Math.max(maxmn, 6 * this.mn) + maxmn;
            double[] work = new double[lwork];
            LAPACK.getInstance().dgesdd("N", this.m, this.n, elementsA, this.m, this.elementsS, null, this.m, null, this.n, work, lwork, iwork, this.info);
        }
        if (this.info.val != 0) {
            throw new IllegalArgumentException("Error occured while computing SVD decomposition: " + this.info);
        }
    }

    public double cond() {
        return this.elementsS[0] / this.elementsS[this.mn - 1];
    }

    public DoubleMatrix2D getS() {
        if (this.S == null) {
            this.S = !this.wantWholeUV ? new DiagonalDoubleMatrix2D(this.mn, this.mn, 0) : new DiagonalDoubleMatrix2D(this.m, this.n, 0);
            for (int i = 0; i < this.mn; ++i) {
                this.S.setQuick(i, i, this.elementsS[i]);
            }
        }
        return this.S.copy();
    }

    public double[] getSingularValues() {
        return this.elementsS;
    }

    public DoubleMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (this.U == null) {
            this.U = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.m, this.mn).assign(this.elementsU) : new DenseDoubleMatrix2D(this.mn, this.m).assign(this.elementsU).viewDice()) : (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.m, this.m).assign(this.elementsU) : new DenseDoubleMatrix2D(this.m, this.m).assign(this.elementsU).viewDice());
        }
        return this.U.copy();
    }

    public DoubleMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (this.V == null) {
            this.V = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.mn, this.n).assign(this.elementsVt).viewDice() : new DenseDoubleMatrix2D(this.n, this.mn).assign(this.elementsVt)) : (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.n, this.n).assign(this.elementsVt).viewDice() : new DenseDoubleMatrix2D(this.n, this.n).assign(this.elementsVt));
        }
        return this.V.copy();
    }

    public intW getInfo() {
        return this.info;
    }

    public double norm2() {
        return this.elementsS[0];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.elementsS[0] * eps;
        int r = 0;
        for (int i = 0; i < this.elementsS.length; ++i) {
            if (!(this.elementsS[i] > tol)) continue;
            ++r;
        }
        return r;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("---------------------------------------------------------------------\n");
        buf.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        buf.append("---------------------------------------------------------------------\n");
        buf.append("cond = ");
        try {
            buf.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\nrank = ");
        try {
            buf.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\nnorm2 = ");
        try {
            buf.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nU = ");
        try {
            buf.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nS = ");
        try {
            buf.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nV = ");
        try {
            buf.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }
}

