/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo.decomposition;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_chol;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_ipvec;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_lsolve;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_ltsolve;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_pvec;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_schol;

public class SparseDComplexCholeskyDecomposition {
    private DZcs_common.DZcss S;
    private DZcs_common.DZcsn N;
    private DComplexMatrix2D L;
    private boolean rcMatrix = false;
    private int n;

    public SparseDComplexCholeskyDecomposition(DComplexMatrix2D A, int order) {
        DZcs_common.DZcs dcs;
        DComplexProperty.DEFAULT.checkSquare(A);
        DComplexProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 1) {
            throw new IllegalArgumentException("order must be equal 0 or 1");
        }
        if (A instanceof SparseRCDComplexMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDComplexMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (DZcs_common.DZcs)A.elements();
        }
        this.n = A.rows();
        this.S = DZcs_schol.cs_schol(order, dcs);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_schol()");
        }
        this.N = DZcs_chol.cs_chol(dcs, this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite");
        }
    }

    public DComplexMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCDComplexMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDComplexMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public DComplexMatrix2D getLtranspose() {
        if (this.L == null) {
            this.L = new SparseCCDComplexMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDComplexMatrix2D)this.L).getRowCompressed();
            }
        }
        if (this.rcMatrix) {
            return ((SparseRCDComplexMatrix2D)this.L).getTranspose();
        }
        return ((SparseCCDComplexMatrix2D)this.L).getTranspose();
    }

    public DZcs_common.DZcss getSymbolicAnalysis() {
        DZcs_common.DZcss S2 = new DZcs_common.DZcss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public void solve(DComplexMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        DComplexProperty.DEFAULT.checkDense(b);
        DZcs_common.DZcsa y = new DZcs_common.DZcsa(this.n);
        DZcs_common.DZcsa x = b.isView() ? new DZcs_common.DZcsa((double[])b.copy().elements()) : new DZcs_common.DZcsa((double[])b.elements());
        DZcs_ipvec.cs_ipvec(this.S.pinv, x, y, this.n);
        DZcs_lsolve.cs_lsolve(this.N.L, y);
        DZcs_ltsolve.cs_ltsolve(this.N.L, y);
        DZcs_pvec.cs_pvec(this.S.pinv, y, x, this.n);
        if (b.isView()) {
            b.assign(x.x);
        }
    }
}

