/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tboolean;

import cern.colt.Arrays;
import cern.colt.function.tboolean.BooleanProcedure;
import cern.colt.list.tboolean.AbstractBooleanList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.util.Date;

public class BooleanArrayList
extends AbstractBooleanList {
    private static final long serialVersionUID = 1L;
    protected boolean[] elements;

    public BooleanArrayList() {
        this(10);
    }

    public BooleanArrayList(boolean[] elements) {
        this.elements(elements);
    }

    public BooleanArrayList(int initialCapacity) {
        this(new boolean[initialCapacity]);
        this.setSizeRaw(0);
    }

    public void add(boolean element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void beforeInsert(int index, boolean element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    public Object clone() {
        BooleanArrayList clone = new BooleanArrayList((boolean[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public BooleanArrayList copy() {
        return (BooleanArrayList)this.clone();
    }

    public void countSortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        BooleanArrayList.checkRangeFromTo(from, to, this.size);
        boolean[] theElements = this.elements;
        int trues = 0;
        int i = from;
        while (i <= to) {
            if (!theElements[i++]) continue;
            ++trues;
        }
        int falses = to - from + 1 - trues;
        if (falses > 0) {
            this.fillFromToWith(from, from + falses - 1, false);
        }
        if (trues > 0) {
            this.fillFromToWith(from + falses, from + falses - 1 + trues, true);
        }
    }

    public boolean[] elements() {
        return this.elements;
    }

    public AbstractBooleanList elements(boolean[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof BooleanArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        BooleanArrayList other = (BooleanArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        boolean[] theElements = this.elements();
        boolean[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(BooleanProcedure procedure) {
        boolean[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public boolean get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public boolean getQuick(int index) {
        return this.elements[index];
    }

    public int indexOfFromTo(boolean element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        BooleanArrayList.checkRangeFromTo(from, to, this.size);
        boolean[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(boolean element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        BooleanArrayList.checkRangeFromTo(from, to, this.size);
        boolean[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int from, int to) {
        this.countSortFromTo(from, to);
    }

    public AbstractBooleanList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new BooleanArrayList(0);
        }
        BooleanArrayList.checkRangeFromTo(from, to, this.size);
        boolean[] part = new boolean[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new BooleanArrayList(part);
    }

    public void quickSortFromTo(int from, int to) {
        this.countSortFromTo(from, to);
    }

    public boolean removeAll(AbstractBooleanList other) {
        double M;
        if (!(other instanceof BooleanArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        boolean[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            BooleanArrayList sortedList = (BooleanArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void replaceFromToWithFrom(int from, int to, AbstractBooleanList other, int otherFrom) {
        if (!(other instanceof BooleanArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            BooleanArrayList.checkRangeFromTo(from, to, this.size());
            BooleanArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((BooleanArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    public boolean retainAll(AbstractBooleanList other) {
        double M;
        if (!(other instanceof BooleanArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        boolean[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * DoubleArithmetic.log2(N) < M * N) {
            BooleanArrayList sortedList = (BooleanArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        boolean[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            boolean tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, boolean element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, boolean element) {
        this.elements[index] = element;
    }

    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        BooleanArrayList.checkRangeFromTo(from, to, this.size);
        DoubleUniform gen = new DoubleUniform(new DRand(new Date()));
        boolean[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            boolean tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    public void sortFromTo(int from, int to) {
        this.countSortFromTo(from, to);
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

