/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBuffer2DConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer2D
extends PersistentObject
implements ShortBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBuffer2DConsumer target;
    protected short[] xElements;
    protected short[] yElements;
    protected ShortArrayList xList;
    protected ShortArrayList yList;
    protected int capacity;
    protected int size;

    public ShortBuffer2D(ShortBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new short[capacity];
        this.yElements = new short[capacity];
        this.xList = new ShortArrayList(this.xElements);
        this.yList = new ShortArrayList(this.yElements);
        this.size = 0;
    }

    public void add(short x, short y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    public void addAllOf(ShortArrayList x, ShortArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

