/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tint;

import cern.colt.PersistentObject;
import cern.colt.buffer.tint.IntBuffer3DConsumer;
import cern.colt.list.tint.IntArrayList;

public class IntBuffer3D
extends PersistentObject
implements IntBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected IntBuffer3DConsumer target;
    protected int[] xElements;
    protected int[] yElements;
    protected int[] zElements;
    protected IntArrayList xList;
    protected IntArrayList yList;
    protected IntArrayList zList;
    protected int capacity;
    protected int size;

    public IntBuffer3D(IntBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new int[capacity];
        this.yElements = new int[capacity];
        this.zElements = new int[capacity];
        this.xList = new IntArrayList(this.xElements);
        this.yList = new IntArrayList(this.yElements);
        this.zList = new IntArrayList(this.zElements);
        this.size = 0;
    }

    public void add(int x, int y, int z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    public void addAllOf(IntArrayList xElements, IntArrayList yElements, IntArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

