/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.changetracking;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class SingleThreadedMemoryStore
extends MemoryStore {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public NotifyingSailConnection getConnection() throws SailException {
        try {
            Future<NotifyingSailConnection> result = this.executor.submit(() -> super.getConnection());
            return new NotifyingSailConnectionWrapper(result.get()){

                public void close() throws SailException {
                    try {
                        Future<?> future = SingleThreadedMemoryStore.this.executor.submit(() -> super.close());
                        future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SailException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        throw new SailException(e.getCause() != null ? e.getCause() : e);
                    }
                }
            };
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SailException(e.getCause() != null ? e.getCause() : e);
        }
    }

    public void shutDown() throws SailException {
        try {
            super.shutDown();
        }
        finally {
            this.executor.shutdown();
        }
    }
}

