/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.mapdb.MapDb3CollectionFactory;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockManager;
import org.eclipse.rdf4j.common.io.MavenUtil;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.base.SnapshotSailStore;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.eclipse.rdf4j.sail.helpers.DirectoryLockManager;
import org.eclipse.rdf4j.sail.nativerdf.MemoryOverflowModel;
import org.eclipse.rdf4j.sail.nativerdf.NativeSailStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeStoreConnection;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeStore
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(NativeStore.class);
    private static final String VERSION = MavenUtil.loadVersion((String)"org.eclipse.rdf4j", (String)"rdf4j-sail-nativerdf", (String)"devel");
    @InternalUseOnly
    public static boolean SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.sail.nativerdf.softFailOnCorruptDataAndRepairIndexes"));
    private static final Cleaner REMOVE_STORES_USED_FOR_MEMORY_OVERFLOW = Cleaner.create();
    private volatile String tripleIndexes;
    private volatile boolean forceSync = false;
    private volatile int valueCacheSize = 512;
    private volatile int valueIDCacheSize = 128;
    private volatile int namespaceCacheSize = 64;
    private volatile int namespaceIDCacheSize = 32;
    private SailStore store;
    private boolean isWritable;
    private boolean isTmpDatadir = false;
    private volatile Lock dirLock;
    private EvaluationStrategyFactory evalStratFactory;
    private FederatedServiceResolver serviceResolver;
    private SPARQLServiceResolver dependentServiceResolver;
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private final LockManager isolatedLockManager = new LockManager(NativeStore.debugEnabled());
    private final LockManager disabledIsolationLockManager = new LockManager(NativeStore.debugEnabled());

    public NativeStore() {
        this.setSupportedIsolationLevels(new IsolationLevel[]{IsolationLevels.NONE, IsolationLevels.READ_COMMITTED, IsolationLevels.SNAPSHOT_READ, IsolationLevels.SNAPSHOT, IsolationLevels.SERIALIZABLE});
        this.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.SNAPSHOT_READ);
    }

    public NativeStore(File dataDir) {
        this();
        this.setDataDir(dataDir);
    }

    public NativeStore(File dataDir, String tripleIndexes) {
        this(dataDir);
        this.setTripleIndexes(tripleIndexes);
    }

    public void setDataDir(File dataDir) {
        super.setDataDir(dataDir);
        this.isTmpDatadir = dataDir == null;
    }

    public void setTripleIndexes(String tripleIndexes) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.tripleIndexes = tripleIndexes;
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        this.evalStratFactory.setTrackResultSize(this.isTrackResultSize());
        return this.evalStratFactory;
    }

    public synchronized void setEvaluationStrategyFactory(EvaluationStrategyFactory factory) {
        this.evalStratFactory = factory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver((FederatedServiceResolver)this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        if (resolver != null && this.evalStratFactory instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)this.evalStratFactory).setFederatedServiceResolver(resolver);
        }
    }

    protected void initializeInternal() throws SailException {
        logger.debug("Initializing NativeStore...");
        File dataDir = this.getDataDir();
        if (dataDir == null) {
            try {
                this.setDataDir(Files.createTempDirectory("rdf4j-native-tmp", new FileAttribute[0]).toFile());
                this.isTmpDatadir = true;
            }
            catch (IOException ioe) {
                throw new SailException("Temp data dir could not be created");
            }
            dataDir = this.getDataDir();
        } else if (!dataDir.exists()) {
            boolean success = dataDir.mkdirs();
            if (!success) {
                throw new SailException("Unable to create data directory: " + String.valueOf(dataDir));
            }
        } else {
            if (!dataDir.isDirectory()) {
                throw new SailException("The specified path does not denote a directory: " + String.valueOf(dataDir));
            }
            if (!dataDir.canRead()) {
                throw new SailException("Not allowed to read from the specified directory: " + String.valueOf(dataDir));
            }
        }
        this.dirLock = new DirectoryLockManager(dataDir).lockOrFail();
        logger.debug("Data dir is " + String.valueOf(dataDir));
        try {
            String version;
            Path versionPath = new File(dataDir, "nativerdf.ver").toPath();
            String string = version = versionPath.toFile().exists() ? Files.readString(versionPath, StandardCharsets.UTF_8) : null;
            if (!VERSION.equals(version) && this.upgradeStore(dataDir, version)) {
                logger.debug("Data store upgraded to version " + VERSION);
                Files.writeString(versionPath, (CharSequence)VERSION, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            final NativeSailStore mainStore = new NativeSailStore(dataDir, this.tripleIndexes, this.forceSync, this.valueCacheSize, this.valueIDCacheSize, this.namespaceCacheSize, this.namespaceIDCacheSize);
            this.store = new SnapshotSailStore(mainStore, () -> new MemoryOverflowIntoNativeStore()){

                public SailSource getExplicitSailSource() {
                    if (NativeStore.this.isIsolationDisabled()) {
                        return mainStore.getExplicitSailSource();
                    }
                    return super.getExplicitSailSource();
                }

                public SailSource getInferredSailSource() {
                    if (NativeStore.this.isIsolationDisabled()) {
                        return mainStore.getInferredSailSource();
                    }
                    return super.getInferredSailSource();
                }
            };
        }
        catch (Throwable e) {
            this.dirLock.release();
            throw new SailException(e);
        }
        this.isWritable = this.getDataDir().canWrite();
        logger.debug("NativeStore initialized");
    }

    protected void shutDownInternal() throws SailException {
        File dataDir;
        logger.debug("Shutting down NativeStore...");
        try {
            this.store.close();
        }
        finally {
            this.dirLock.release();
            if (this.dependentServiceResolver != null) {
                this.dependentServiceResolver.shutDown();
            }
        }
        if (this.isTmpDatadir && (dataDir = this.getDataDir()) != null) {
            try {
                Files.walk(dataDir.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
            catch (IOException ioe) {
                logger.error("Could not delete temp file " + String.valueOf(dataDir));
            }
        }
        logger.debug("NativeStore shut down");
    }

    public void shutDown() throws SailException {
        super.shutDown();
        if (this.isTmpDatadir) {
            this.setDataDir(null);
        }
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        return new NativeStoreConnection(this);
    }

    public ValueFactory getValueFactory() {
        return this.store.getValueFactory();
    }

    protected Lock getTransactionLock(IsolationLevel level) throws SailException {
        this.txnLockManager.lock();
        try {
            if (IsolationLevels.NONE.isCompatibleWith(level)) {
                this.isolatedLockManager.waitForActiveLocks();
                Lock lock = this.disabledIsolationLockManager.createLock(level.toString());
                return lock;
            }
            this.disabledIsolationLockManager.waitForActiveLocks();
            Lock lock = this.isolatedLockManager.createLock(level.toString());
            return lock;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException((Throwable)e);
        }
        finally {
            this.txnLockManager.unlock();
        }
    }

    boolean isIsolationDisabled() {
        return this.disabledIsolationLockManager.isActiveLock();
    }

    SailStore getSailStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeStore(File dataDir, String version) throws IOException, SailException {
        if (version == null) {
            try (ValueStore valueStore = new ValueStore(dataDir);){
                valueStore.checkConsistency();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Supplier<CollectionFactory> getCollectionFactory() {
        return () -> new MapDb3CollectionFactory(this.getIterationCacheSyncThreshold());
    }

    static final class MemoryOverflowIntoNativeStore
    extends MemoryOverflowModel {
        private static final long serialVersionUID = 1L;

        MemoryOverflowIntoNativeStore() {
        }

        @Override
        protected SailStore createSailStore(File dataDir) throws IOException, SailException {
            NativeSailStore nativeSailStore = new NativeSailStore(dataDir, "spoc");
            REMOVE_STORES_USED_FOR_MEMORY_OVERFLOW.register((Object)this, new OverFlowStoreCleaner(nativeSailStore, dataDir));
            return nativeSailStore;
        }

        private static final class OverFlowStoreCleaner
        implements Runnable {
            private final NativeSailStore nativeSailStore;
            private final File dataDir;

            private OverFlowStoreCleaner(NativeSailStore nativeSailStore, File dataDir) {
                this.nativeSailStore = nativeSailStore;
                nativeSailStore.disableTxnStatus();
                this.dataDir = dataDir;
            }

            @Override
            public void run() {
                try {
                    this.nativeSailStore.close();
                }
                finally {
                    try {
                        FileUtils.deleteDirectory((File)this.dataDir);
                    }
                    catch (IOException e) {
                        logger.error("Could not remove data dir of overflow model store", (Throwable)e);
                    }
                }
            }
        }
    }
}

