/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.PriorityQueue;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.Node;
import com.infomatiq.jsi.rtree.SortedList;
import gnu.trove.TIntStack;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongProcedure;
import gnu.trove.TLongStack;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;

public class RTree
implements SpatialIndex {
    private static final Logger log = Logger.getLogger((String)RTree.class.getName());
    private static final Logger deleteLog = Logger.getLogger((String)(RTree.class.getName() + "-delete"));
    private static final String version = "1.0b6";
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    int maxNodeEntries;
    int minNodeEntries;
    private final LongObjectHashMap<Node> nodeMap = new LongObjectHashMap();
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private TLongStack parents = new TLongStack();
    private TIntStack parentsEntry = new TIntStack();
    private int treeHeight = 1;
    private long rootNodeId = 0L;
    private int size = 0;
    private long highestUsedNodeId = this.rootNodeId;
    private TLongStack deletedNodeIds = new TLongStack();
    private TLongArrayList nearestIds = new TLongArrayList();
    private TLongArrayList savedValues = new TLongArrayList();
    private float savedPriority = 0.0f;
    private SortedList nearestNIds = new SortedList();
    private PriorityQueue distanceQueue = new PriorityQueue(true);

    @Override
    public void init(Properties props) {
        this.maxNodeEntries = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
        this.minNodeEntries = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
        if (this.maxNodeEntries < 2) {
            log.warn((Object)("Invalid MaxNodeEntries = " + this.maxNodeEntries + " Resetting to default value of " + 10));
            this.maxNodeEntries = 10;
        }
        if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
            log.warn((Object)"MinNodeEntries must be between 1 and MaxNodeEntries / 2");
            this.minNodeEntries = this.maxNodeEntries / 2;
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            this.initialEntryStatus[i] = 1;
        }
        Node root = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, (Object)root);
        log.debug((Object)("init()  MaxNodeEntries = " + this.maxNodeEntries + ", MinNodeEntries = " + this.minNodeEntries));
    }

    @Override
    public void add(Rectangle r, long id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding rectangle " + r + ", id " + id));
        }
        this.add(r.minX, r.minY, r.maxX, r.maxY, id, 1);
        ++this.size;
    }

    private void add(float minX, float minY, float maxX, float maxY, long id, int level) {
        Node n = this.chooseNode(minX, minY, maxX, maxY, level);
        Node newLeaf = null;
        if (n.entryCount < this.maxNodeEntries) {
            n.addEntry(minX, minY, maxX, maxY, id);
        } else {
            newLeaf = this.splitNode(n, minX, minY, maxX, maxY, id);
        }
        Node newNode = this.adjustTree(n, newLeaf);
        if (newNode != null) {
            long oldRootNodeId = this.rootNodeId;
            Node oldRoot = this.getNode(oldRootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntry(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, newNode.nodeId);
            root.addEntry(oldRoot.mbrMinX, oldRoot.mbrMinY, oldRoot.mbrMaxX, oldRoot.mbrMaxY, oldRoot.nodeId);
            this.nodeMap.put(this.rootNodeId, (Object)root);
        }
    }

    @Override
    public boolean delete(Rectangle r, long id) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                deleteLog.debug((Object)("searching node " + n.nodeId + ", from index " + startIndex));
                boolean contains = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!Rectangle.contains(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], r.minX, r.minY, r.maxX, r.maxY)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    contains = true;
                    break;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r.minX, r.minY, r.maxX, r.maxY, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1) {
            n.deleteEntry(foundIndex, this.minNodeEntries);
            this.condenseTree(n);
            --this.size;
        }
        Node root = this.getNode(this.rootNodeId);
        while (root.entryCount == 1 && this.treeHeight > 1) {
            this.deletedNodeIds.push(this.rootNodeId);
            root.entryCount = 0;
            this.rootNodeId = root.ids[0];
            --this.treeHeight;
            root = this.getNode(this.rootNodeId);
        }
        if (this.size == 0) {
            root.mbrMinX = Float.MAX_VALUE;
            root.mbrMaxX = -3.4028235E38f;
            root.mbrMinY = Float.MAX_VALUE;
            root.mbrMaxY = -3.4028235E38f;
        }
        return foundIndex != -1;
    }

    @Override
    public void nearest(Point p, TLongProcedure v, float furthestDistance) {
        Node rootNode = this.getNode(this.rootNodeId);
        float furthestDistanceSq = furthestDistance * furthestDistance;
        this.nearest(p, rootNode, furthestDistanceSq);
        this.nearestIds.forEach(v);
        this.nearestIds.reset();
    }

    private void createNearestNDistanceQueue(Point p, int count, float furthestDistance) {
        this.distanceQueue.reset();
        this.distanceQueue.setSortOrder(false);
        if (count <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        float furthestDistanceSq = furthestDistance * furthestDistance;
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean near = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!(Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y) <= furthestDistanceSq)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    near = true;
                    break;
                }
                if (near) {
                    continue;
                }
            } else {
                for (int i = 0; i < n.entryCount; ++i) {
                    float entryDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
                    long entryId = n.ids[i];
                    if (!(entryDistanceSq <= furthestDistanceSq)) continue;
                    this.distanceQueue.insert(entryId, entryDistanceSq);
                    while (this.distanceQueue.size() > count) {
                        long value = this.distanceQueue.getValue();
                        float distanceSq = this.distanceQueue.getPriority();
                        this.distanceQueue.pop();
                        if (distanceSq == this.distanceQueue.getPriority()) {
                            this.savedValues.add(value);
                            this.savedPriority = distanceSq;
                            continue;
                        }
                        this.savedValues.clear();
                    }
                    if (this.savedValues.size() > 0 && this.savedPriority == this.distanceQueue.getPriority()) {
                        for (int svi = 0; svi < this.savedValues.size(); ++svi) {
                            this.distanceQueue.insert(this.savedValues.get(svi), this.savedPriority);
                        }
                        this.savedValues.clear();
                    }
                    if (!(this.distanceQueue.getPriority() < furthestDistanceSq) || this.distanceQueue.size() < count) continue;
                    furthestDistanceSq = this.distanceQueue.getPriority();
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    @Override
    public void nearestNUnsorted(Point p, TLongProcedure v, int count, float furthestDistance) {
        this.createNearestNDistanceQueue(p, count, furthestDistance);
        while (this.distanceQueue.size() > 0) {
            v.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    @Override
    public void nearestN(Point p, TLongProcedure v, int count, float furthestDistance) {
        this.createNearestNDistanceQueue(p, count, furthestDistance);
        this.distanceQueue.setSortOrder(true);
        while (this.distanceQueue.size() > 0) {
            v.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    public void nearestN_orig(Point p, TLongProcedure v, int count, float furthestDistance) {
        if (count <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        this.nearestNIds.init(count);
        float furthestDistanceSq = furthestDistance * furthestDistance;
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean near = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!(Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y) <= furthestDistanceSq)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    near = true;
                    break;
                }
                if (near) {
                    continue;
                }
            } else {
                for (int i = 0; i < n.entryCount; ++i) {
                    float entryDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
                    long entryId = n.ids[i];
                    if (!(entryDistanceSq <= furthestDistanceSq)) continue;
                    this.nearestNIds.add(entryId, -entryDistanceSq);
                    float tempFurthestDistanceSq = -this.nearestNIds.getLowestPriority();
                    if (!(tempFurthestDistanceSq < furthestDistanceSq)) continue;
                    furthestDistanceSq = tempFurthestDistanceSq;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        this.nearestNIds.forEachId(v);
    }

    @Override
    public void intersects(Rectangle r, TLongProcedure v) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.intersects(r, v, rootNode);
    }

    @Override
    public void contains(Rectangle r, TLongProcedure v) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean intersects = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!Rectangle.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    intersects = true;
                    break;
                }
                if (intersects) {
                    continue;
                }
            } else {
                for (int i = 0; i < n.entryCount; ++i) {
                    if (!Rectangle.contains(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || v.execute(n.ids[i])) continue;
                    return;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        Node n = this.getNode(this.getRootNodeId());
        if (n != null && n.entryCount > 0) {
            bounds = new Rectangle();
            bounds.minX = n.mbrMinX;
            bounds.minY = n.mbrMinY;
            bounds.maxX = n.mbrMaxX;
            bounds.maxY = n.mbrMaxY;
        }
        return bounds;
    }

    @Override
    public String getVersion() {
        return "RTree-1.0b6";
    }

    private long getNextNodeId() {
        long nextNodeId = 0L;
        nextNodeId = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : 1L + this.highestUsedNodeId++;
        return nextNodeId;
    }

    public Node getNode(long id) {
        return (Node)this.nodeMap.get(id);
    }

    public long getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public long getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node n, float newRectMinX, float newRectMinY, float newRectMaxX, float newRectMaxY, long newId) {
        float initialArea = 0.0f;
        if (log.isDebugEnabled()) {
            float unionMinX = Math.min(n.mbrMinX, newRectMinX);
            float unionMinY = Math.min(n.mbrMinY, newRectMinY);
            float unionMaxX = Math.max(n.mbrMaxX, newRectMaxX);
            float unionMaxY = Math.max(n.mbrMaxY, newRectMaxY);
            initialArea = (unionMaxX - unionMinX) * (unionMaxY - unionMinY);
        }
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node newNode = null;
        newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.nodeMap.put(newNode.nodeId, (Object)newNode);
        this.pickSeeds(n, newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    if (n.entriesMinX[i] < n.mbrMinX) {
                        n.mbrMinX = n.entriesMinX[i];
                    }
                    if (n.entriesMinY[i] < n.mbrMinY) {
                        n.mbrMinY = n.entriesMinY[i];
                    }
                    if (n.entriesMaxX[i] > n.mbrMaxX) {
                        n.mbrMaxX = n.entriesMaxX[i];
                    }
                    if (n.entriesMaxY[i] > n.mbrMaxY) {
                        n.mbrMaxY = n.entriesMaxY[i];
                    }
                    ++n.entryCount;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    newNode.addEntry(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], n.ids[i]);
                    n.ids[i] = -1L;
                }
                break;
            }
            this.pickNext(n, newNode);
        }
        n.reorganize(this);
        if (log.isDebugEnabled()) {
            float newArea = Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) + Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY);
            float percentageIncrease = 100.0f * (newArea - initialArea) / initialArea;
            log.debug((Object)("Node " + n.nodeId + " split. New area increased by " + percentageIncrease + "%"));
        }
        return newNode;
    }

    private void pickSeeds(Node n, float newRectMinX, float newRectMinY, float newRectMaxX, float newRectMaxY, long newId, Node newNode) {
        float normalizedSeparation;
        float tempHigh;
        float tempLow;
        int i;
        float maxNormalizedSeparation = -1.0f;
        int highestLowIndex = -1;
        int lowestHighIndex = -1;
        if (newRectMinX < n.mbrMinX) {
            n.mbrMinX = newRectMinX;
        }
        if (newRectMinY < n.mbrMinY) {
            n.mbrMinY = newRectMinY;
        }
        if (newRectMaxX > n.mbrMaxX) {
            n.mbrMaxX = newRectMaxX;
        }
        if (newRectMaxY > n.mbrMaxY) {
            n.mbrMaxY = newRectMaxY;
        }
        float mbrLenX = n.mbrMaxX - n.mbrMinX;
        float mbrLenY = n.mbrMaxY - n.mbrMinY;
        if (log.isDebugEnabled()) {
            log.debug((Object)("pickSeeds(): NodeId = " + n.nodeId));
        }
        float tempHighestLow = newRectMinX;
        int tempHighestLowIndex = -1;
        float tempLowestHigh = newRectMaxX;
        int tempLowestHighIndex = -1;
        for (i = 0; i < n.entryCount; ++i) {
            tempLow = n.entriesMinX[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxX[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            float f = normalizedSeparation = mbrLenX == 0.0f ? 1.0f : (tempHighestLow - tempLowestHigh) / mbrLenX;
            if (normalizedSeparation > 1.0f || normalizedSeparation < -1.0f) {
                log.error((Object)"Invalid normalized separation X");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + i + ", dimension X: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation));
            }
            if (!(normalizedSeparation >= maxNormalizedSeparation)) continue;
            highestLowIndex = tempHighestLowIndex;
            lowestHighIndex = tempLowestHighIndex;
            maxNormalizedSeparation = normalizedSeparation;
        }
        tempHighestLow = newRectMinY;
        tempHighestLowIndex = -1;
        tempLowestHigh = newRectMaxY;
        tempLowestHighIndex = -1;
        for (i = 0; i < n.entryCount; ++i) {
            tempLow = n.entriesMinY[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxY[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            float f = normalizedSeparation = mbrLenY == 0.0f ? 1.0f : (tempHighestLow - tempLowestHigh) / mbrLenY;
            if (normalizedSeparation > 1.0f || normalizedSeparation < -1.0f) {
                log.error((Object)"Invalid normalized separation Y");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry " + i + ", dimension Y: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation));
            }
            if (!(normalizedSeparation >= maxNormalizedSeparation)) continue;
            highestLowIndex = tempHighestLowIndex;
            lowestHighIndex = tempLowestHighIndex;
            maxNormalizedSeparation = normalizedSeparation;
        }
        if (highestLowIndex == lowestHighIndex) {
            highestLowIndex = -1;
            float tempMinY = newRectMinY;
            lowestHighIndex = 0;
            float tempMaxX = n.entriesMaxX[0];
            for (int i2 = 1; i2 < n.entryCount; ++i2) {
                if (n.entriesMinY[i2] < tempMinY) {
                    tempMinY = n.entriesMinY[i2];
                    highestLowIndex = i2;
                    continue;
                }
                if (!(n.entriesMaxX[i2] > tempMaxX)) continue;
                tempMaxX = n.entriesMaxX[i2];
                lowestHighIndex = i2;
            }
        }
        if (highestLowIndex == -1) {
            newNode.addEntry(newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId);
        } else {
            newNode.addEntry(n.entriesMinX[highestLowIndex], n.entriesMinY[highestLowIndex], n.entriesMaxX[highestLowIndex], n.entriesMaxY[highestLowIndex], n.ids[highestLowIndex]);
            n.ids[highestLowIndex] = -1L;
            n.entriesMinX[highestLowIndex] = newRectMinX;
            n.entriesMinY[highestLowIndex] = newRectMinY;
            n.entriesMaxX[highestLowIndex] = newRectMaxX;
            n.entriesMaxY[highestLowIndex] = newRectMaxY;
            n.ids[highestLowIndex] = newId;
        }
        if (lowestHighIndex == -1) {
            lowestHighIndex = highestLowIndex;
        }
        this.entryStatus[lowestHighIndex] = 0;
        n.entryCount = 1;
        n.mbrMinX = n.entriesMinX[lowestHighIndex];
        n.mbrMinY = n.entriesMinY[lowestHighIndex];
        n.mbrMaxX = n.entriesMaxX[lowestHighIndex];
        n.mbrMaxY = n.entriesMaxY[lowestHighIndex];
    }

    private int pickNext(Node n, Node newNode) {
        float maxDifference = Float.NEGATIVE_INFINITY;
        int next = 0;
        boolean nextGroup = false;
        maxDifference = Float.NEGATIVE_INFINITY;
        if (log.isDebugEnabled()) {
            log.debug((Object)"pickNext()");
        }
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            float newNodeIncrease;
            float nIncrease;
            float difference;
            if (this.entryStatus[i] != 1) continue;
            if (n.ids[i] == -1L) {
                log.error((Object)("Error: Node " + n.nodeId + ", entry " + i + " is null"));
            }
            if ((difference = Math.abs((nIncrease = Rectangle.enlargement(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) - (newNodeIncrease = Rectangle.enlargement(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])))) > maxDifference) {
                next = i;
                nextGroup = nIncrease < newNodeIncrease ? false : (newNodeIncrease < nIncrease ? true : (Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) < Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY) ? false : (Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY) < Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) ? true : newNode.entryCount >= this.maxNodeEntries / 2)));
                maxDifference = difference;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Entry " + i + " group0 increase = " + nIncrease + ", group1 increase = " + newNodeIncrease + ", diff = " + difference + ", MaxDiff = " + maxDifference + " (entry " + next + ")"));
        }
        this.entryStatus[next] = 0;
        if (!nextGroup) {
            if (n.entriesMinX[next] < n.mbrMinX) {
                n.mbrMinX = n.entriesMinX[next];
            }
            if (n.entriesMinY[next] < n.mbrMinY) {
                n.mbrMinY = n.entriesMinY[next];
            }
            if (n.entriesMaxX[next] > n.mbrMaxX) {
                n.mbrMaxX = n.entriesMaxX[next];
            }
            if (n.entriesMaxY[next] > n.mbrMaxY) {
                n.mbrMaxY = n.entriesMaxY[next];
            }
            ++n.entryCount;
        } else {
            newNode.addEntry(n.entriesMinX[next], n.entriesMinY[next], n.entriesMaxX[next], n.entriesMaxY[next], n.ids[next]);
            n.ids[next] = -1L;
        }
        return next;
    }

    private float nearest(Point p, Node n, float furthestDistanceSq) {
        for (int i = 0; i < n.entryCount; ++i) {
            float tempDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
            if (n.isLeaf()) {
                if (tempDistanceSq < furthestDistanceSq) {
                    furthestDistanceSq = tempDistanceSq;
                    this.nearestIds.clear();
                }
                if (!(tempDistanceSq <= furthestDistanceSq)) continue;
                this.nearestIds.add(n.ids[i]);
                continue;
            }
            if (!(tempDistanceSq <= furthestDistanceSq)) continue;
            furthestDistanceSq = this.nearest(p, this.getNode(n.ids[i]), furthestDistanceSq);
        }
        return furthestDistanceSq;
    }

    private boolean intersects(Rectangle r, TLongProcedure v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            Node childNode;
            if (!Rectangle.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) || !(n.isLeaf() ? !v.execute(n.ids[i]) : !this.intersects(r, v, childNode = this.getNode(n.ids[i])))) continue;
            return false;
        }
        return true;
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        TLongStack eliminatedNodeIds = new TLongStack();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry, this.minNodeEntries);
                eliminatedNodeIds.push(n.nodeId);
            } else if (n.mbrMinX != parent.entriesMinX[parentEntry] || n.mbrMinY != parent.entriesMinY[parentEntry] || n.mbrMaxX != parent.entriesMaxX[parentEntry] || n.mbrMaxY != parent.entriesMaxY[parentEntry]) {
                float deletedMinX = parent.entriesMinX[parentEntry];
                float deletedMinY = parent.entriesMinY[parentEntry];
                float deletedMaxX = parent.entriesMaxX[parentEntry];
                float deletedMaxY = parent.entriesMaxY[parentEntry];
                parent.entriesMinX[parentEntry] = n.mbrMinX;
                parent.entriesMinY[parentEntry] = n.mbrMinY;
                parent.entriesMaxX[parentEntry] = n.mbrMaxX;
                parent.entriesMaxY[parentEntry] = n.mbrMaxY;
                parent.recalculateMBRIfInfluencedBy(deletedMinX, deletedMinY, deletedMaxX, deletedMaxY);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode(eliminatedNodeIds.pop());
            for (int j = 0; j < e.entryCount; ++j) {
                this.add(e.entriesMinX[j], e.entriesMinY[j], e.entriesMaxX[j], e.entriesMaxY[j], e.ids[j], e.level);
                e.ids[j] = -1L;
            }
            e.entryCount = 0;
            this.deletedNodeIds.push(e.nodeId);
        }
    }

    private Node chooseNode(float minX, float minY, float maxX, float maxY, int level) {
        Node n = this.getNode(this.rootNodeId);
        this.parents.reset();
        this.parentsEntry.reset();
        while (true) {
            if (n == null) {
                log.error((Object)("Could not get root node (" + this.rootNodeId + ")"));
            }
            if (n.level == level) {
                return n;
            }
            float leastEnlargement = Rectangle.enlargement(n.entriesMinX[0], n.entriesMinY[0], n.entriesMaxX[0], n.entriesMaxY[0], minX, minY, maxX, maxY);
            int index = 0;
            for (int i = 1; i < n.entryCount; ++i) {
                float tempMinX = n.entriesMinX[i];
                float tempMinY = n.entriesMinY[i];
                float tempMaxX = n.entriesMaxX[i];
                float tempMaxY = n.entriesMaxY[i];
                float tempEnlargement = Rectangle.enlargement(tempMinX, tempMinY, tempMaxX, tempMaxY, minX, minY, maxX, maxY);
                if (!(tempEnlargement < leastEnlargement) && (tempEnlargement != leastEnlargement || !(Rectangle.area(tempMinX, tempMinY, tempMaxX, tempMaxY) < Rectangle.area(n.entriesMinX[index], n.entriesMinY[index], n.entriesMaxX[index], n.entriesMaxY[index])))) continue;
                index = i;
                leastEnlargement = tempEnlargement;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
    }

    private Node adjustTree(Node n, Node nn) {
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (parent.ids[entry] != n.nodeId) {
                log.error((Object)("Error: entry " + entry + " in node " + parent.nodeId + " should point to node " + n.nodeId + "; actually points to node " + parent.ids[entry]));
            }
            if (parent.entriesMinX[entry] != n.mbrMinX || parent.entriesMinY[entry] != n.mbrMinY || parent.entriesMaxX[entry] != n.mbrMaxX || parent.entriesMaxY[entry] != n.mbrMaxY) {
                parent.entriesMinX[entry] = n.mbrMinX;
                parent.entriesMinY[entry] = n.mbrMinY;
                parent.entriesMaxX[entry] = n.mbrMaxX;
                parent.entriesMaxY[entry] = n.mbrMaxY;
                parent.recalculateMBR();
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntry(nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
            parent = null;
            newNode = null;
        }
        return nn;
    }

    public boolean checkConsistency() {
        return this.checkConsistency(this.rootNodeId, this.treeHeight, null);
    }

    private boolean checkConsistency(long nodeId, int expectedLevel, Rectangle expectedMBR) {
        Node n = this.getNode(nodeId);
        if (n == null) {
            log.error((Object)("Error: Could not read node " + nodeId));
            return false;
        }
        if (nodeId == this.rootNodeId && this.size() == 0 && n.level != 1) {
            log.error((Object)"Error: tree is empty but root node is not at level 1");
            return false;
        }
        if (n.level != expectedLevel) {
            log.error((Object)("Error: Node " + nodeId + ", expected level " + expectedLevel + ", actual level " + n.level));
            return false;
        }
        Rectangle calculatedMBR = this.calculateMBR(n);
        Rectangle actualMBR = new Rectangle();
        actualMBR.minX = n.mbrMinX;
        actualMBR.minY = n.mbrMinY;
        actualMBR.maxX = n.mbrMaxX;
        actualMBR.maxY = n.mbrMaxY;
        if (!actualMBR.equals(calculatedMBR)) {
            log.error((Object)("Error: Node " + nodeId + ", calculated MBR does not equal stored MBR"));
            return false;
        }
        if (expectedMBR != null && !actualMBR.equals(expectedMBR)) {
            log.error((Object)("Error: Node " + nodeId + ", expected MBR (from parent) does not equal stored MBR"));
            return false;
        }
        if (expectedMBR != null && actualMBR.sameObject(expectedMBR)) {
            log.error((Object)("Error: Node " + nodeId + " MBR using same rectangle object as parent's entry"));
            return false;
        }
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.ids[i] == -1L) {
                log.error((Object)("Error: Node " + nodeId + ", Entry " + i + " is null"));
                return false;
            }
            if (n.level <= 1 || this.checkConsistency(n.ids[i], n.level - 1, new Rectangle(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]))) continue;
            return false;
        }
        return true;
    }

    private Rectangle calculateMBR(Node n) {
        Rectangle mbr = new Rectangle();
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.entriesMinX[i] < mbr.minX) {
                mbr.minX = n.entriesMinX[i];
            }
            if (n.entriesMinY[i] < mbr.minY) {
                mbr.minY = n.entriesMinY[i];
            }
            if (n.entriesMaxX[i] > mbr.maxX) {
                mbr.maxX = n.entriesMaxX[i];
            }
            if (!(n.entriesMaxY[i] > mbr.maxY)) continue;
            mbr.maxY = n.entriesMaxY[i];
        }
        return mbr;
    }
}

