/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.rtree.RTree;

public class Node {
    long nodeId = 0L;
    float mbrMinX = Float.MAX_VALUE;
    float mbrMinY = Float.MAX_VALUE;
    float mbrMaxX = -3.4028235E38f;
    float mbrMaxY = -3.4028235E38f;
    float[] entriesMinX = null;
    float[] entriesMinY = null;
    float[] entriesMaxX = null;
    float[] entriesMaxY = null;
    long[] ids = null;
    int level;
    int entryCount;

    Node(long nodeId, int level, int maxNodeEntries) {
        this.nodeId = nodeId;
        this.level = level;
        this.entriesMinX = new float[maxNodeEntries];
        this.entriesMinY = new float[maxNodeEntries];
        this.entriesMaxX = new float[maxNodeEntries];
        this.entriesMaxY = new float[maxNodeEntries];
        this.ids = new long[maxNodeEntries];
    }

    void addEntry(float minX, float minY, float maxX, float maxY, long id) {
        this.ids[this.entryCount] = id;
        this.entriesMinX[this.entryCount] = minX;
        this.entriesMinY[this.entryCount] = minY;
        this.entriesMaxX[this.entryCount] = maxX;
        this.entriesMaxY[this.entryCount] = maxY;
        if (minX < this.mbrMinX) {
            this.mbrMinX = minX;
        }
        if (minY < this.mbrMinY) {
            this.mbrMinY = minY;
        }
        if (maxX > this.mbrMaxX) {
            this.mbrMaxX = maxX;
        }
        if (maxY > this.mbrMaxY) {
            this.mbrMaxY = maxY;
        }
        ++this.entryCount;
    }

    int findEntry(float minX, float minY, float maxX, float maxY, long id) {
        for (int i = 0; i < this.entryCount; ++i) {
            if (id != this.ids[i] || this.entriesMinX[i] != minX || this.entriesMinY[i] != minY || this.entriesMaxX[i] != maxX || this.entriesMaxY[i] != maxY) continue;
            return i;
        }
        return -1;
    }

    void deleteEntry(int i, int minNodeEntries) {
        int lastIndex = this.entryCount - 1;
        float deletedMinX = this.entriesMinX[i];
        float deletedMinY = this.entriesMinY[i];
        float deletedMaxX = this.entriesMaxX[i];
        float deletedMaxY = this.entriesMaxY[i];
        if (i != lastIndex) {
            this.entriesMinX[i] = this.entriesMinX[lastIndex];
            this.entriesMinY[i] = this.entriesMinY[lastIndex];
            this.entriesMaxX[i] = this.entriesMaxX[lastIndex];
            this.entriesMaxY[i] = this.entriesMaxY[lastIndex];
            this.ids[i] = this.ids[lastIndex];
        }
        --this.entryCount;
        if (this.entryCount >= minNodeEntries) {
            this.recalculateMBRIfInfluencedBy(deletedMinX, deletedMinY, deletedMaxX, deletedMaxY);
        }
    }

    void recalculateMBRIfInfluencedBy(float deletedMinX, float deletedMinY, float deletedMaxX, float deletedMaxY) {
        if (this.mbrMinX == deletedMinX || this.mbrMinY == deletedMinY || this.mbrMaxX == deletedMaxX || this.mbrMaxY == deletedMaxY) {
            this.recalculateMBR();
        }
    }

    void recalculateMBR() {
        this.mbrMinX = this.entriesMinX[0];
        this.mbrMinY = this.entriesMinY[0];
        this.mbrMaxX = this.entriesMaxX[0];
        this.mbrMaxY = this.entriesMaxY[0];
        for (int i = 1; i < this.entryCount; ++i) {
            if (this.entriesMinX[i] < this.mbrMinX) {
                this.mbrMinX = this.entriesMinX[i];
            }
            if (this.entriesMinY[i] < this.mbrMinY) {
                this.mbrMinY = this.entriesMinY[i];
            }
            if (this.entriesMaxX[i] > this.mbrMaxX) {
                this.mbrMaxX = this.entriesMaxX[i];
            }
            if (!(this.entriesMaxY[i] > this.mbrMaxY)) continue;
            this.mbrMaxY = this.entriesMaxY[i];
        }
    }

    void reorganize(RTree rtree) {
        int countdownIndex = rtree.maxNodeEntries - 1;
        for (int index = 0; index < this.entryCount; ++index) {
            if (this.ids[index] != -1L) continue;
            while (this.ids[countdownIndex] == -1L && countdownIndex > index) {
                --countdownIndex;
            }
            this.entriesMinX[index] = this.entriesMinX[countdownIndex];
            this.entriesMinY[index] = this.entriesMinY[countdownIndex];
            this.entriesMaxX[index] = this.entriesMaxX[countdownIndex];
            this.entriesMaxY[index] = this.entriesMaxY[countdownIndex];
            this.ids[index] = this.ids[countdownIndex];
            this.ids[countdownIndex] = -1L;
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public long getId(int index) {
        if (index < this.entryCount) {
            return this.ids[index];
        }
        return -1L;
    }

    boolean isLeaf() {
        return this.level == 1;
    }

    public int getLevel() {
        return this.level;
    }
}

