/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb;

import com.ontotext.trree.config.OWLIMSailSchema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.platform.Platform;
import org.eclipse.rdf4j.common.platform.PlatformFactory;
import org.eclipse.rdf4j.model.IRI;

public class MigrationWizard {
    static Set<String> enginePropertyNames;

    static String getDataDirectory() throws IOException {
        Platform adunaPlatform = PlatformFactory.getPlatform();
        File adunaHome = adunaPlatform.getApplicationDataDir("OpenRDF Sesame");
        File adunaRepositories = new File(adunaHome, "repositories");
        if (adunaRepositories.isDirectory() && Files.isDirectory(adunaRepositories.toPath().resolve("SYSTEM"), new LinkOption[0])) {
            return adunaHome.getAbsolutePath();
        }
        return null;
    }

    static String askUserInput(String prompt) {
        System.out.print(prompt + ": ");
        return System.console().readLine();
    }

    static List<String> tokeniseAlaShell(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inDoubleQuotes = false;
        boolean inSingleQuotes = false;
        char[] chars = input.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    if (i + 1 >= chars.length) continue block6;
                    sb.append(chars[++i]);
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inDoubleQuotes || inSingleQuotes) {
                        sb.append(c);
                        continue block6;
                    }
                    if (sb.length() <= 0) continue block6;
                    tokens.add(sb.toString());
                    sb.setLength(0);
                    continue block6;
                }
                case '\"': {
                    if (inSingleQuotes) {
                        sb.append(c);
                        continue block6;
                    }
                    inDoubleQuotes = !inDoubleQuotes;
                    continue block6;
                }
                case '\'': {
                    if (inDoubleQuotes) {
                        sb.append(c);
                        continue block6;
                    }
                    inSingleQuotes = !inSingleQuotes;
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        return tokens;
    }

    static String getPropertiesFromTomcatBash(String tomcatHome, String file) throws IOException {
        Path pathToFile = Paths.get(tomcatHome, "bin", file + ".sh");
        if (!Files.exists(pathToFile, new LinkOption[0])) {
            System.out.println("    File " + String.valueOf(pathToFile) + " not found or not readable");
            return "";
        }
        System.out.println("    Reading file " + String.valueOf(pathToFile));
        ArrayList<Object> datas = new ArrayList<Object>();
        try (BufferedReader br = new BufferedReader(new FileReader(pathToFile.toFile()));){
            String line;
            Object data = "";
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (!((String)data).isEmpty()) {
                    data = (String)data + " " + line;
                    if (line.endsWith("\\")) continue;
                    datas.add(data);
                    data = "";
                }
                if (!line.startsWith("CATALINA_OPTS=") && !line.startsWith("export CATALINA_OPTS=") && !line.startsWith("JAVA_OPTS=") && !line.startsWith("export JAVA_OPTS=")) continue;
                data = line.substring(line.indexOf(61) + 1, line.length());
                if (((String)data).endsWith("\\")) {
                    data = ((String)data).substring(0, ((String)data).length() - 1);
                    continue;
                }
                datas.add(data);
                data = "";
            }
        }
        StringBuilder joinedDatas = new StringBuilder();
        for (Object data : datas) {
            if (((String)data).startsWith("\"") && ((String)data).endsWith("\"") || ((String)data).startsWith("'") && ((String)data).endsWith("'")) {
                data = ((String)data).substring(1, ((String)data).length() - 1);
            }
            joinedDatas.append((String)data);
            joinedDatas.append(" ");
        }
        return joinedDatas.toString().trim();
    }

    static String getPropertiesFromTomcatCmd(String tomcatHome, String file) throws IOException {
        Path pathToFile = Paths.get(tomcatHome, "bin", file + ".bat");
        if (!Files.exists(pathToFile, new LinkOption[0])) {
            System.out.println("    File " + String.valueOf(pathToFile) + " not found or not readable");
            return "";
        }
        System.out.println("    Reading file " + String.valueOf(pathToFile));
        ArrayList<String> datas = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(pathToFile.toFile()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!(line = line.trim()).startsWith("set CATALINA_OPTS=") && !line.startsWith("set JAVA_OPTS=")) continue;
                datas.add(line.substring(line.indexOf(61) + 1, line.length()));
            }
        }
        StringBuilder joinedDatas = new StringBuilder();
        for (String data : datas) {
            joinedDatas.append(data);
            joinedDatas.append(" ");
        }
        return joinedDatas.toString().trim();
    }

    static String getPropertiesFromTomcat(String tomcatHome, String file) throws IOException {
        if (tomcatHome.isEmpty()) {
            return "";
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return MigrationWizard.getPropertiesFromTomcatCmd(tomcatHome, file);
        }
        return MigrationWizard.getPropertiesFromTomcatBash(tomcatHome, file);
    }

    static void writeNewLine(Writer writer) throws IOException {
        writer.write(System.lineSeparator());
    }

    static void writeComment(Writer writer, String comment) throws IOException {
        writer.write("# ");
        writer.write(comment);
        MigrationWizard.writeNewLine(writer);
    }

    static void writePropertyWithComment(Writer writer, String key, String value, String comment) throws IOException {
        MigrationWizard.writeComment(writer, comment);
        writer.write(key);
        writer.write(" = ");
        writer.write(value.replace("\\", "\\\\"));
        MigrationWizard.writeNewLine(writer);
        MigrationWizard.writeNewLine(writer);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("GraphDB 6.x to GraphDB 7 config migration wizard.\n");
        List<String> userArgs = MigrationWizard.tokeniseAlaShell(MigrationWizard.askUserInput("Enter any -D options you passed to Tomcat (optional)"));
        String tomcatHome = MigrationWizard.askUserInput("Enter the path to your Tomcat installation (optional)");
        List<String> tomcatCatalinaArgs = MigrationWizard.tokeniseAlaShell(MigrationWizard.getPropertiesFromTomcat(tomcatHome, "catalina"));
        List<String> tomcatSetenvArgs = MigrationWizard.tokeniseAlaShell(MigrationWizard.getPropertiesFromTomcat(tomcatHome, "setenv"));
        userArgs.addAll(tomcatCatalinaArgs);
        userArgs.addAll(tomcatSetenvArgs);
        System.out.println("----------------------------------------------------------------------");
        System.out.println("PROPERTY ANALYSIS:\n");
        LinkedHashMap<String, String> userProperties = new LinkedHashMap<String, String>();
        String adunaLoggingDir = null;
        String licenseFile = null;
        boolean foundProperty = false;
        for (String arg : userArgs) {
            String[] keyValue;
            if (!arg.startsWith("-D") || (keyValue = arg.substring(2).split("=", 2)).length != 2) continue;
            Object key = keyValue[0];
            String value = keyValue[1];
            System.out.println("Found Java system property: " + (String)key + " = " + value);
            switch (key) {
                case "info.aduna.platform.appdata.basedir": 
                case "aduna.platform.applicationdata.dir": {
                    System.out.println("    property is not used in GraphDB 7, will map to new config");
                    foundProperty = true;
                    break;
                }
                case "info.aduna.logging.dir": {
                    System.out.println("    property is not used in GraphDB 7, will map to new config");
                    adunaLoggingDir = value;
                    foundProperty = true;
                    break;
                }
                case "owlim-license": {
                    System.out.println("    will map to new property graphdb.license.file");
                    licenseFile = value;
                    foundProperty = true;
                    break;
                }
                default: {
                    if (enginePropertyNames.contains(key)) {
                        System.out.println("    will map to new property graphdb.engine." + (String)key);
                        key = "graphdb.engine." + (String)key;
                    }
                    userProperties.put((String)key, value);
                    foundProperty = true;
                }
            }
            System.setProperty((String)key, value);
        }
        if (!foundProperty) {
            System.out.println("No properties in your input or Tomcat installation.");
        }
        System.out.println("----------------------------------------------------------------------");
        System.out.println("NEW CONFIG:\n");
        try (FileWriter writer = new FileWriter("graphdb-migrated.properties");){
            MigrationWizard.writeComment(writer, "This is an auto-generated config file for GraphDB.");
            MigrationWizard.writeComment(writer, "Save this file as conf/graphdb.properties.");
            MigrationWizard.writeNewLine(writer);
            MigrationWizard.writeComment(writer, "No value for GraphDB home directory.");
            MigrationWizard.writeComment(writer, "The default will be used: ");
            MigrationWizard.writeComment(writer, "  - same as the distribution directory (when running standalone mode)");
            MigrationWizard.writeComment(writer, "  - OS-specific directory (when running in war mode)");
            MigrationWizard.writeComment(writer, "Please consider providing an explicit value.");
            MigrationWizard.writeComment(writer, "graphdb.home = ");
            MigrationWizard.writeNewLine(writer);
            String dataDirectory = MigrationWizard.getDataDirectory();
            if (dataDirectory != null) {
                System.out.println("Found data directory: " + dataDirectory);
                MigrationWizard.writePropertyWithComment(writer, "graphdb.home.data", dataDirectory, "GraphDB data directory");
            } else {
                System.out.println("Unable to find the data directory.");
                MigrationWizard.writeComment(writer, "GraphDB data directory.");
                MigrationWizard.writeComment(writer, "No valid directory was find by the migration wizard.");
                MigrationWizard.writeComment(writer, "The default is ${graphdb.home}/data.");
                MigrationWizard.writeComment(writer, "graphdb.data =");
                MigrationWizard.writeNewLine(writer);
            }
            MigrationWizard.writeComment(writer, "GraphDB work directory. The default is ${graphdb.home}/work");
            MigrationWizard.writeComment(writer, "graphdb.home.work =");
            MigrationWizard.writeNewLine(writer);
            if (adunaLoggingDir != null) {
                System.out.println("Found logs directory: " + adunaLoggingDir);
                MigrationWizard.writePropertyWithComment(writer, "graphdb.home.logs", adunaLoggingDir, "GraphDB logs directory");
            }
            if (licenseFile != null) {
                System.out.println("Found license file: " + licenseFile);
                MigrationWizard.writePropertyWithComment(writer, "graphdb.license.file", licenseFile, "GraphDB license file, mapped from old property owlim-license");
            }
            for (Map.Entry pEntry : userProperties.entrySet()) {
                String key = (String)pEntry.getKey();
                String value = (String)pEntry.getValue();
                if (!key.startsWith("graphdb.engine.")) continue;
                System.out.println("Found property: " + key + " = " + value);
                MigrationWizard.writePropertyWithComment(writer, key, value, "Mapped old property " + key.substring("graphdb.engine.".length()));
            }
        }
        System.out.println("\nGenerated config file 'graphdb-migrated.properties' in current directory.");
    }

    static {
        IRI[] enginePropertyUris = new IRI[]{OWLIMSailSchema.baseURL, OWLIMSailSchema.checkForInconsistencies, OWLIMSailSchema.defaultNS, OWLIMSailSchema.disableSameAs, OWLIMSailSchema.enableContextIndex, OWLIMSailSchema.enableLiteralIndex, OWLIMSailSchema.enableOptimization, OWLIMSailSchema.enablePredicateList, OWLIMSailSchema.entityIdSize, OWLIMSailSchema.entityindexsize, OWLIMSailSchema.imports_tag, OWLIMSailSchema.indexCompressionRatio, OWLIMSailSchema.inferencerThreads, OWLIMSailSchema.inMemoryLiteralProperties, OWLIMSailSchema.partialRDFS, OWLIMSailSchema.predicateMemory, OWLIMSailSchema.queryTimeout, OWLIMSailSchema.readOnly, OWLIMSailSchema.repositoryFragments, OWLIMSailSchema.repository_type, OWLIMSailSchema.ruleset, OWLIMSailSchema.storagefolder, OWLIMSailSchema.throwQueryEvaluationExceptionOnTimeout, OWLIMSailSchema.tokenizationRegex, OWLIMSailSchema.transactionIsolation, OWLIMSailSchema.transactionMode, OWLIMSailSchema.entityPoolImplementation, OWLIMSailSchema.tupleIndexMemory, OWLIMSailSchema.queryLimitResults, OWLIMSailSchema.registerPlugins, OWLIMSailSchema.nonInterpretablePredicates, OWLIMSailSchema.checkForValidPropertiesAndClasses};
        enginePropertyNames = new HashSet<String>();
        for (IRI uri : enginePropertyUris) {
            enginePropertyNames.add(uri.getLocalName());
        }
    }
}

