/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.retrieval;

import com.ontotext.trree.plugin.externalsync.api.DocumentsResult;
import com.ontotext.trree.plugin.externalsync.api.SnippetResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RetrievalResult
implements DocumentsResult {
    int currentIndex = -1;
    List<JSONObject> metadata;
    List<Double> scores = new ArrayList<Double>();
    List<String> chunkIDs = new ArrayList<String>();
    List<String> chunkTexts = new ArrayList<String>();

    RetrievalResult(JSONObject results) {
        this.metadata = new ArrayList<JSONObject>();
        JSONArray outerResults = (JSONArray)results.get((Object)"results");
        for (Object outerResult : outerResults) {
            for (Object innerResult : (JSONArray)((JSONObject)outerResult).get((Object)"results")) {
                JSONObject r = (JSONObject)innerResult;
                this.metadata.add((JSONObject)r.get((Object)"metadata"));
                this.scores.add((Double)r.get((Object)"score"));
                this.chunkIDs.add((String)r.get((Object)"id"));
                this.chunkTexts.add((String)r.get((Object)"text"));
            }
        }
    }

    public long totalSize() {
        return this.metadata.size();
    }

    public double getCurrentScore() {
        return this.scores.get(this.currentIndex);
    }

    public String getCurrentSubject() {
        return (String)this.metadata.get(this.currentIndex).get((Object)"document_id");
    }

    public Collection<SnippetResult> getCurrentSnippets() {
        JSONObject md = this.metadata.get(this.currentIndex);
        ArrayList<SnippetResult> result = new ArrayList<SnippetResult>();
        md.forEach((key, value) -> {
            if (value != null && !key.equals("document_id")) {
                result.add(new SnippetResult("metadata_" + String.valueOf(key), Collections.singletonList(value.toString())));
            }
        });
        result.add(new SnippetResult("chunk_id", Collections.singletonList(this.chunkIDs.get(this.currentIndex))));
        result.add(new SnippetResult("chunk", Collections.singletonList(this.chunkTexts.get(this.currentIndex))));
        return result;
    }

    public boolean next() {
        ++this.currentIndex;
        return this.currentIndex < this.metadata.size();
    }
}

