/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.retrieval;

import com.google.common.collect.ImmutableList;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ClassNameValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalStore;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.StatelessPlugin;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import org.json.simple.JSONObject;

public class RetrievalPlugin
extends ExternalSyncPlugin
implements StatelessPlugin {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-retrieval-option-description", Locale.getDefault());
    static final String SUBJECT_FIELD_NAME = "subject";
    static final String TEXT_FIELD_NAME = "text";
    static final String METADATA_FIELD_NAME = "metadata";
    static final String RETRIEVAL_URL_PARAM_NAME = "retrievalUrl";
    static final String RETRIEVAL_BEARER_PARAM_NAME = "retrievalBearerToken";
    static final String RETRIEVAL_FIELD_TEXT_PREFIX_NAME = "fieldTextPrefix";
    static final String RETRIEVAL_FIELD_TEXT_PREFIX_DEFAULT = "has {}";
    static final Option<String> RETRIEVAL_URL = Option.string((String)"retrievalUrl", (ResourceBundle)RESOURCE_BUNDLE).required().updatable().build();
    static final Option<String> RETRIEVAL_BEARER = Option.string((String)"retrievalBearerToken", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<String> AUTHENTICATION_CONFIGURATOR_CLASS = Option.string((String)"authenticationConfiguratorClass", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new ClassNameValidator()).updatable().build();
    static final Option<Long> BULK_UPDATE_BATCH_SIZE = Option.longNumber((String)"bulkUpdateBatchSize", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)1000L).updatable().build();
    private static final ImmutableList<Option<?>> OPTIONS = ImmutableList.builder().add((Object)RetrievalPlugin.createFieldsOptionsRetrieval("fields", RetrievalPlugin.createFieldsOptionsRetrieval("objectFields", new Option[0])).appendValidator((Validator)new Validator<List<JSONObject>>(){

        @Nullable
        public Object validate(@Nullable List<JSONObject> fields, Options optionsSet) {
            for (JSONObject field : fields) {
                String fieldName = (String)field.get((Object)"fieldName");
                boolean isMetadata = RetrievalPlugin.METADATA_FIELD_NAME.equals(fieldName);
                boolean isNested = field.containsKey((Object)"objectFields");
                if (!isMetadata || isNested) continue;
                return "The field '" + fieldName + "' must be a nested field.";
            }
            return null;
        }
    })).addAll((Iterable)DEFAULT_OPTIONS).add(RETRIEVAL_URL).add(RETRIEVAL_BEARER).add(AUTHENTICATION_CONFIGURATOR_CLASS).add(BULK_UPDATE_BATCH_SIZE).build();

    private static Option<List<Option<?>>> createFieldsOptionsRetrieval(String optionName, Option<?> ... options) {
        Option[] moreOptions = new Option[options.length + 3];
        moreOptions[0] = Option.string((String)RETRIEVAL_FIELD_TEXT_PREFIX_NAME, (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)RETRIEVAL_FIELD_TEXT_PREFIX_DEFAULT).build();
        moreOptions[1] = Option.flag((String)"array", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
        moreOptions[2] = DOCUMENT_FILTER;
        System.arraycopy(options, 0, moreOptions, moreOptions.length - options.length, options.length);
        return RetrievalPlugin.createFieldsOptions((String)optionName, (boolean)false, (boolean)false, (boolean)false, (Option[])moreOptions);
    }

    public String getName() {
        return "chatgpt-retrieval-connector";
    }

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return RetrievalStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        return RetrievalStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
    }

    public List<Option<?>> getAllOptions() {
        return OPTIONS;
    }

    protected String getURIComponent() {
        return "retrieval";
    }

    public String getShortName() {
        return "ChatGPT Retrieval";
    }

    protected Set<String> getOptionsToRedactForUser() {
        return Set.of(RETRIEVAL_URL_PARAM_NAME, RETRIEVAL_BEARER_PARAM_NAME, "authenticationConfiguratorClass");
    }

    public void checkRequiredCapabilities(PluginConnection pluginConnection) {
    }
}

