/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.ZipIRIMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OWLZipClosureIRIMapper
implements OWLOntologyIRIMapper {
    private static final Pattern CATALOG_PATTERN = Pattern.compile("catalog[\\-v0-9]*\\.xml");
    private final List<IRI> physicalRoots = new ArrayList<IRI>();
    private final Map<IRI, IRI> logicalToPhysicalIRI = new ConcurrentHashMap<IRI, IRI>();

    public OWLZipClosureIRIMapper(File f) throws IOException {
        String basePhysicalIRI = "jar:" + String.valueOf(f.toURI()) + "!/";
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile z = new ZipFile(f);){
            if (this.loadFromOwlzipProperties(basePhysicalIRI, z)) {
                return;
            }
            if (this.loadFromCatalog(basePhysicalIRI, z)) {
                return;
            }
            ZipEntry root = z.getEntry("root.owl");
            if (root != null) {
                this.physicalRoots.add(IRI.create(basePhysicalIRI + "root.owl"));
            }
            ZipIRIMapper mapper = new ZipIRIMapper(z, basePhysicalIRI);
            mapper.iriMappings().forEach(e -> {
                IRI iRI = this.logicalToPhysicalIRI.put((IRI)e.getKey(), (IRI)e.getValue());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean loadFromCatalog(String basePhysicalIRI, ZipFile z) throws IOException {
        ZipEntry yaml = z.stream().filter(e -> CATALOG_PATTERN.matcher(e.getName()).matches()).findFirst().orElse(null);
        if (yaml == null) {
            return false;
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(z.getInputStream(yaml));
            NodeList uris = doc.getElementsByTagName("uri");
            int i = 0;
            while (i < uris.getLength()) {
                Element e2 = (Element)uris.item(i);
                IRI physicalIRI = IRI.create(basePhysicalIRI + e2.getAttribute("uri"));
                this.physicalRoots.add(physicalIRI);
                String name = e2.getAttribute("name");
                if (name.startsWith("duplicate:")) {
                    name = name.replace("duplicate:", "");
                }
                this.logicalToPhysicalIRI.put(IRI.create(name), physicalIRI);
                ++i;
            }
            return true;
        }
        catch (ParserConfigurationException | SAXException e1) {
            throw new IOException(e1);
        }
    }

    protected boolean loadFromOwlzipProperties(String basePhysicalIRI, ZipFile z) throws IOException {
        String[] roots;
        ZipEntry yaml = z.getEntry("owlzip.properties");
        if (yaml == null) {
            return false;
        }
        Properties p = new Properties();
        p.load(z.getInputStream(yaml));
        String[] stringArray = roots = p.getProperty("roots", "").split(", ");
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String name = s.trim();
            if (!name.isEmpty()) {
                this.physicalRoots.add(IRI.create(basePhysicalIRI + name.trim()));
            }
            p.entrySet().stream().filter(e -> !e.getKey().equals("roots")).forEach(e -> {
                IRI iRI = this.logicalToPhysicalIRI.put(IRI.create(e.getValue().toString()), IRI.create(basePhysicalIRI + String.valueOf(e.getKey())));
            });
            ++n2;
        }
        return true;
    }

    @Override
    @Nullable
    public IRI getDocumentIRI(IRI ontologyIRI) {
        return this.logicalToPhysicalIRI.get(ontologyIRI);
    }

    public Stream<IRI> roots() {
        return this.physicalRoots.stream();
    }

    public Stream<Map.Entry<IRI, IRI>> mappedEntries() {
        return this.logicalToPhysicalIRI.entrySet().stream();
    }
}

