/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class OWLLiteralReplacer {
    private final OWLOntologyManager owlOntologyManager;
    private final Set<OWLOntology> ontologies;

    public OWLLiteralReplacer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    private static Collection<OWLAxiom> getAxioms(OWLOntology ont, OWLLiteral entity) {
        List<OWLAxiom> axioms = OWLAPIStreamUtils.asList(ont.referencingAxioms(entity, Imports.EXCLUDED));
        OWLAPIStreamUtils.add(axioms, ont.declarationAxioms(entity.getDatatype()));
        return axioms;
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Collection<OWLAxiom> axioms, OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAxiom ax : axioms) {
            assert (ax != null);
            changes.add(new RemoveAxiom(ont, ax));
            OWLAxiom dupAx = duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        }
    }

    public List<OWLOntologyChange> changeLiteral(OWLLiteral literal, OWLLiteral newLiteral) {
        OWLAPIPreconditions.checkNotNull(literal, "literal cannot be null");
        OWLAPIPreconditions.checkNotNull(newLiteral, "newLiteral cannot be null");
        HashMap<OWLLiteral, OWLLiteral> uriMap = new HashMap<OWLLiteral, OWLLiteral>();
        uriMap.put(literal, newLiteral);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator dup = new OWLObjectDuplicator(Collections.emptyMap(), uriMap, this.owlOntologyManager, new RemappingIndividualProvider(false, this.owlOntologyManager.getOWLDataFactory()));
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            OWLLiteralReplacer.fillListWithTransformChanges(changes, OWLLiteralReplacer.getAxioms(ont, literal), ont, dup);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeLiterals(Map<OWLLiteral, OWLLiteral> literalToLiteralMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(Collections.emptyMap(), literalToLiteralMap, this.owlOntologyManager, new RemappingIndividualProvider(false, this.owlOntologyManager.getOWLDataFactory()));
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLLiteral ent : literalToLiteralMap.keySet()) {
                assert (ent != null);
                OWLLiteralReplacer.fillListWithTransformChanges(changes, OWLLiteralReplacer.getAxioms(ont, ent), ont, duplicator);
            }
        }
        return changes;
    }
}

