/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLStorer
implements OWLStorer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLStorer.class);

    private static OutputStream prepareActualOutput(IRI documentIRI) throws IOException {
        if ("file".equals(documentIRI.getScheme())) {
            File file = new File(documentIRI.toURI());
            file.getParentFile().mkdirs();
            return new FileOutputStream(file);
        }
        URL url = documentIRI.toURI().toURL();
        URLConnection conn = url.openConnection();
        return conn.getOutputStream();
    }

    @Override
    public void storeOntology(OWLOntology ontology, IRI documentIRI, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        if (!documentIRI.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI must be absolute: " + String.valueOf(documentIRI));
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream os = AbstractOWLStorer.prepareActualOutput(documentIRI);){
                this.store(ontology, ontologyFormat, os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void store(OWLOntology ontology, OWLDocumentFormat ontologyFormat, OutputStream tempOutputStream) throws OWLOntologyStorageException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            OutputStreamWriter osw = new OutputStreamWriter(tempOutputStream, StandardCharsets.UTF_8);
            try {
                block18: {
                    BufferedWriter bw = new BufferedWriter(osw);
                    try {
                        try (PrintWriter tempWriter = new PrintWriter(bw);){
                            this.storeOntology(ontology, tempWriter, ontologyFormat);
                            tempWriter.flush();
                        }
                        if (bw == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bw == null) throw throwable;
                        bw.close();
                        throw throwable;
                    }
                    bw.close();
                }
                if (osw == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (osw == null) throw throwable;
                osw.close();
                throw throwable;
            }
            osw.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void storeOntology(OWLOntology ontology, OWLOntologyDocumentTarget target, OWLDocumentFormat format) throws OWLOntologyStorageException {
        Optional<Writer> writer = target.getWriter();
        if (format.isTextual() && writer.isPresent()) {
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try {
                    PrintWriter pw;
                    Writer w;
                    block21: {
                        w = writer.get();
                        pw = new PrintWriter(w);
                        this.storeOntology(ontology, pw, format);
                        pw.flush();
                        if (pw != null) {
                            pw.close();
                        }
                        if (w == null) break block21;
                        w.close();
                    }
                    return;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (pw != null) {
                                    pw.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (w != null) {
                                    w.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        }
        Optional<OutputStream> outputStream = target.getOutputStream();
        if (outputStream.isPresent()) {
            this.storeOntology(ontology, outputStream.get(), format);
            return;
        }
        Optional<IRI> documentIRI = target.getDocumentIRI();
        if (documentIRI.isPresent()) {
            this.storeOntology(ontology, documentIRI.get(), format);
            return;
        }
        throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Document IRI could be obtained to store the ontology in this format: " + format.getKey());
    }

    protected abstract void storeOntology(OWLOntology var1, PrintWriter var2, OWLDocumentFormat var3) throws OWLOntologyStorageException;

    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (!format.isTextual()) {
            throw new OWLOntologyStorageException("This method must be overridden to support this binary format: " + format.getKey());
        }
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
            this.storeOntology(ontology, writer, format);
            writer.flush();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

