/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.Set;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class AnnotationVisitor<C>
implements OWLAxiomVisitorEx<Set<C>> {
    private final boolean value;

    AnnotationVisitor(boolean value) {
        this.value = value;
    }

    @Override
    public Set<C> doDefault(Object object) {
        return OWLAPIStreamUtils.asUnorderedSet(((HasAnnotations)object).annotations().map(this::get));
    }

    private C get(OWLAnnotation a) {
        if (this.value) {
            return (C)a.getValue();
        }
        return (C)a;
    }

    @Override
    public Set<C> visit(OWLAnnotationAssertionAxiom axiom) {
        if (this.value) {
            return CollectionFactory.createSet(axiom.getValue());
        }
        return CollectionFactory.createSet(axiom.getAnnotation());
    }
}

