/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.semanticweb.owlapi.model.EntityTypeVisitorEx;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.providers.EntityProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class EntityType<E extends OWLEntity>
implements Serializable,
HasShortForm,
HasPrefixedName,
HasIRI {
    public static final EntityType<OWLClass> CLASS = new EntityType<OWLClass>("Class", "Class", "Classes", OWLRDFVocabulary.OWL_CLASS, (i, p) -> p.getOWLClass(i));
    public static final EntityType<OWLObjectProperty> OBJECT_PROPERTY = new EntityType<OWLObjectProperty>("ObjectProperty", "Object property", "Object properties", OWLRDFVocabulary.OWL_OBJECT_PROPERTY, (i, p) -> p.getOWLObjectProperty(i));
    public static final EntityType<OWLDataProperty> DATA_PROPERTY = new EntityType<OWLDataProperty>("DataProperty", "Data property", "Data properties", OWLRDFVocabulary.OWL_DATA_PROPERTY, (i, p) -> p.getOWLDataProperty(i));
    public static final EntityType<OWLAnnotationProperty> ANNOTATION_PROPERTY = new EntityType<OWLAnnotationProperty>("AnnotationProperty", "Annotation property", "Annotation properties", OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY, (i, p) -> p.getOWLAnnotationProperty(i));
    public static final EntityType<OWLNamedIndividual> NAMED_INDIVIDUAL = new EntityType<OWLNamedIndividual>("NamedIndividual", "Named individual", "Named individuals", OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL, (i, p) -> p.getOWLNamedIndividual(i));
    public static final EntityType<OWLDatatype> DATATYPE = new EntityType<OWLDatatype>("Datatype", "Datatype", "Datatypes", OWLRDFVocabulary.RDFS_DATATYPE, (i, p) -> p.getOWLDatatype(i));
    private static final List<EntityType<?>> VALUES = Collections.unmodifiableList(Arrays.asList(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, ANNOTATION_PROPERTY, NAMED_INDIVIDUAL, DATATYPE));
    private final String name;
    private final OWLRDFVocabulary vocabulary;
    private final String printName;
    private final String pluralPrintName;
    private final Builder<E> builder;

    protected EntityType(String name, String print, String pluralPrint, OWLRDFVocabulary vocabulary, Builder<E> builder) {
        this.name = name;
        this.vocabulary = vocabulary;
        this.printName = print;
        this.pluralPrintName = pluralPrint;
        this.builder = builder;
    }

    public static List<EntityType<?>> values() {
        return VALUES;
    }

    public OWLRDFVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getPrintName() {
        return this.printName;
    }

    public String getPluralPrintName() {
        return this.pluralPrintName;
    }

    @Override
    public String getShortForm() {
        return this.name;
    }

    @Override
    public String getPrefixedName() {
        return this.vocabulary.getPrefixedName();
    }

    @Override
    public IRI getIRI() {
        return this.vocabulary.getIRI();
    }

    public <T> Optional<T> accept(EntityTypeVisitorEx<T> visitor) {
        return visitor.visit(this);
    }

    public E buildEntity(IRI i, EntityProvider df) {
        return (E)((OWLEntity)this.builder.buildEntity(i, df));
    }

    @FunctionalInterface
    private static interface Builder<T> {
        public T buildEntity(IRI var1, EntityProvider var2);
    }
}

