/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nullable;

public final class XMLUtils {
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP = "&amp;";
    public static final String APOS = "&apos;";
    public static final String OWL_PROCESSING_INSTRUCTION_NAME = "owl";

    private XMLUtils() {
    }

    public static boolean isXMLNameStartCharacter(int codePoint) {
        return codePoint == 58 || codePoint >= 65 && codePoint <= 90 || codePoint == 95 || codePoint >= 97 && codePoint <= 122 || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isXMLNameChar(int codePoint) {
        return XMLUtils.isXMLNameStartCharacter(codePoint) || codePoint == 45 || codePoint == 46 || codePoint >= 48 && codePoint <= 57 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }

    public static boolean isNCNameStartChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameStartCharacter(codePoint);
    }

    public static boolean isNCNameChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameChar(codePoint);
    }

    public static boolean isNCName(@Nullable CharSequence s) {
        if (XMLUtils.isNullOrEmpty(s)) {
            return false;
        }
        assert (s != null);
        int firstCodePoint = Character.codePointAt(s, 0);
        if (!XMLUtils.isNCNameStartChar(firstCodePoint)) {
            return false;
        }
        int i = Character.charCount(firstCodePoint);
        while (i < s.length()) {
            int codePoint = Character.codePointAt(s, i);
            if (!XMLUtils.isNCNameChar(codePoint)) {
                return false;
            }
            i += Character.charCount(codePoint);
        }
        return true;
    }

    public static boolean isQName(CharSequence s) {
        return XMLUtils.isQName(s, 0);
    }

    public static boolean isQName(CharSequence s, int start) {
        if (XMLUtils.isNullOrEmpty(s) || start >= s.length()) {
            return false;
        }
        boolean foundColon = false;
        boolean inNCName = false;
        int i = start;
        while (i < s.length()) {
            int codePoint = Character.codePointAt(s, i);
            if (codePoint == 58) {
                if (foundColon) {
                    return false;
                }
                foundColon = true;
                if (!inNCName) {
                    return false;
                }
                inNCName = false;
            } else if (!inNCName) {
                if (!XMLUtils.isXMLNameStartCharacter(codePoint)) {
                    return false;
                }
                inNCName = true;
            } else if (!XMLUtils.isXMLNameChar(codePoint)) {
                return false;
            }
            i += Character.charCount(codePoint);
        }
        return true;
    }

    public static boolean hasNCNameSuffix(CharSequence s) {
        return XMLUtils.getNCNameSuffixIndex(s) != -1;
    }

    public static int getNCNameSuffixIndex(CharSequence s) {
        if (s.length() > 1 && s.charAt(0) == '_' && s.charAt(1) == ':') {
            return -1;
        }
        int index = -1;
        int i = s.length() - 1;
        while (i > -1) {
            if (!Character.isLowSurrogate(s.charAt(i))) {
                int codePoint = Character.codePointAt(s, i);
                if (XMLUtils.isNCNameStartChar(codePoint)) {
                    index = i;
                }
                if (!XMLUtils.isNCNameChar(codePoint)) break;
            }
            --i;
        }
        return index;
    }

    @Nullable
    public static String getNCNameSuffix(CharSequence s) {
        if (s.length() > 1 && s.charAt(0) == '_' && s.charAt(1) == ':') {
            return null;
        }
        int localPartStartIndex = XMLUtils.getNCNameSuffixIndex(s);
        if (localPartStartIndex > -1) {
            return s.toString().substring(localPartStartIndex);
        }
        return null;
    }

    public static boolean isEmpty(@Nullable CharSequence s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        return s.chars().allMatch(Character::isWhitespace);
    }

    public static String getNCNamePrefix(CharSequence s) {
        if (XMLUtils.isEmpty(s)) {
            return "";
        }
        if (s.length() > 1 && s.charAt(0) == '_' && s.charAt(1) == ':') {
            return s.toString();
        }
        int localPartStartIndex = XMLUtils.getNCNameSuffixIndex(s);
        int firstNonBlank = 0;
        while (Character.isWhitespace(s.charAt(firstNonBlank))) {
            ++firstNonBlank;
        }
        if (localPartStartIndex > -1) {
            return s.toString().substring(firstNonBlank, localPartStartIndex);
        }
        return s.toString().substring(firstNonBlank);
    }

    public static String escapeXML(CharSequence s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            int codePoint = Character.codePointAt(s, i);
            if (codePoint == 60) {
                sb.append(LT);
            } else if (codePoint == 62) {
                sb.append(GT);
            } else if (codePoint == 34) {
                sb.append(QUOT);
            } else if (codePoint == 38) {
                sb.append(AMP);
            } else if (codePoint == 39) {
                sb.append(APOS);
            } else {
                sb.appendCodePoint(codePoint);
            }
            i += Character.charCount(codePoint);
        }
        return sb.toString();
    }

    public static StringBuilder escapeXML(char[] chars, int start, int count, StringBuilder destination) {
        int i = 0;
        while (i < count) {
            char codePoint = chars[start + i];
            if (codePoint == '<') {
                destination.append(LT);
            } else if (codePoint == '>') {
                destination.append(GT);
            } else if (codePoint == '\"') {
                destination.append(QUOT);
            } else if (codePoint == '&') {
                destination.append(AMP);
            } else if (codePoint == '\'') {
                destination.append(APOS);
            } else {
                destination.append(codePoint);
            }
            ++i;
        }
        return destination;
    }

    public static void escapeXML(StringBuilder sb) {
        int i = 0;
        while (i < sb.length()) {
            int codePoint = Character.codePointAt(sb, i);
            int length = Character.charCount(codePoint);
            if (codePoint == 60) {
                sb.replace(i, i + length, LT);
                i += LT.length();
                continue;
            }
            if (codePoint == 62) {
                sb.replace(i, i + length, GT);
                i += GT.length();
                continue;
            }
            if (codePoint == 34) {
                sb.replace(i, i + length, QUOT);
                i += QUOT.length();
                continue;
            }
            if (codePoint == 38) {
                sb.replace(i, i + length, AMP);
                i += AMP.length();
                continue;
            }
            if (codePoint == 39) {
                sb.replace(i, i + length, APOS);
                i += APOS.length();
                continue;
            }
            i += length;
        }
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static String iriWithTerminatingHash(@Nullable String iri) {
        if (iri == null) {
            return "#";
        }
        char c = iri.charAt(iri.length() - 1);
        if (c == '/' || c == '#') {
            return iri;
        }
        if (iri.indexOf(35) > -1) {
            return iri;
        }
        return iri + "#";
    }
}

