/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.StringDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class StringDocumentSource
extends OWLOntologyDocumentSourceBase {
    private final String string;

    public StringDocumentSource(String string) {
        super("string:ontology", null, null);
        this.string = OWLAPIPreconditions.checkNotNull(string, "string cannot be null");
        this.failedOnIRI.set(true);
    }

    public StringDocumentSource(String string, IRI iri) {
        this(string, iri, null, null);
    }

    public StringDocumentSource(StringDocumentTarget target) {
        this(target.toString());
    }

    public StringDocumentSource(String string, IRI documentIRI, @Nullable OWLDocumentFormat f, @Nullable String mime) {
        super(documentIRI, f, mime);
        this.string = OWLAPIPreconditions.checkNotNull(string, "string cannot be null");
    }

    public StringDocumentSource(String string, String prefix, @Nullable OWLDocumentFormat f, @Nullable String mime) {
        super(prefix, f, mime);
        this.string = OWLAPIPreconditions.checkNotNull(string, "string cannot be null");
    }

    @Override
    public Optional<Reader> getReader() {
        return OWLAPIPreconditions.optional(new StringReader(this.string));
    }
}

