/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class AddClassExpressionClosureAxiom
extends AbstractCompositeOntologyChange {
    public AddClassExpressionClosureAxiom(OWLDataFactory dataFactory, OWLClass cls, OWLObjectPropertyExpression property, Collection<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null");
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null");
        this.generateChanges(cls, property, ontologies, targetOntology);
    }

    private void generateChanges(OWLClass cls, OWLObjectPropertyExpression property, Collection<OWLOntology> ontologies, OWLOntology targetOntology) {
        FillerCollector collector = new FillerCollector(property);
        ontologies.forEach(o -> o.subClassAxiomsForSubClass(cls).forEach(ax -> ax.getSuperClass().accept(collector)));
        if (collector.fillers.isEmpty()) {
            return;
        }
        OWLObjectUnionOf union = this.df.getOWLObjectUnionOf(collector.fillers);
        OWLObjectAllValuesFrom closureAxiomDesc = this.df.getOWLObjectAllValuesFrom(property, union);
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLSubClassOfAxiom(cls, closureAxiomDesc)));
    }

    private class FillerCollector
    implements OWLClassExpressionVisitor {
        final List<OWLClassExpression> fillers = new ArrayList<OWLClassExpression>();
        final OWLObjectPropertyExpression property;

        FillerCollector(OWLObjectPropertyExpression p) {
            this.property = OWLAPIPreconditions.checkNotNull(p, "p cannot be null");
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom ce) {
            if (ce.getProperty().equals(this.property)) {
                this.fillers.add((OWLClassExpression)ce.getFiller());
            }
        }

        @Override
        public void visit(OWLObjectHasValue ce) {
            if (ce.getProperty().equals(this.property)) {
                this.fillers.add(AddClassExpressionClosureAxiom.this.df.getOWLObjectOneOf((OWLIndividual)ce.getFiller()));
            }
        }
    }
}

