/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.forest.mcp.server.GraphDBWebMvcSseServerTransportProvider;
import com.ontotext.forest.mcp.server.McpToolsRegistry;
import com.ontotext.graphdb.Config;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.function.RouterFunction;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"com.ontotext.forest.mcp.server"})
@PropertySource(value={"classpath:META-INF/application.properties"})
public class GraphDBMCPServer {
    @Bean
    @ConditionalOnProperty(prefix="transport", name={"mode"}, havingValue="stdio")
    public McpServerTransportProvider stdioServerTransportProvider() {
        return new StdioServerTransportProvider();
    }

    @Bean
    @ConditionalOnProperty(prefix="transport", name={"mode"}, havingValue="sse")
    public GraphDBWebMvcSseServerTransportProvider webMvcSseServerTransportProvider() {
        return new GraphDBWebMvcSseServerTransportProvider(new ObjectMapper(), Config.getExternalUrl(null), "/mcp/message", "/mcp/sse");
    }

    @Bean
    @ConditionalOnProperty(prefix="transport", name={"mode"}, havingValue="sse")
    public RouterFunction<?> mcpRouterFunction(GraphDBWebMvcSseServerTransportProvider transportProvider) {
        return transportProvider.getRouterFunction();
    }

    @Bean
    public McpAsyncServer mcpServer(GraphDBWebMvcSseServerTransportProvider transportProvider, McpToolsRegistry toolRegistryService) {
        McpSchema.ServerCapabilities capabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).logging().build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((GraphDBWebMvcSseServerTransportProvider)transportProvider).close()));
        return McpServer.async((McpServerTransportProvider)transportProvider).serverInfo("GraphDB MCP Server", "1.0.0").capabilities(capabilities).tools(McpToolUtils.toAsyncToolSpecifications((ToolCallback[])ToolCallbacks.from((Object[])new Object[]{toolRegistryService}))).build();
    }
}

