/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools.openapi;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ontotext.forest.gpt.ttyg.tools.openapi.OpenApiToolDefinition;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"openapi", "info", "servers", "paths"})
public class OpenApiTools {
    private final String title;
    private final String description;
    private final String version;
    private final String url;
    private final List<OpenApiToolDefinition> definitions;

    public OpenApiTools(String id, String url, List<OpenApiToolDefinition> definitions) {
        this.title = "Query GraphDB (id: " + id + ")";
        this.description = "Retrieves information from GraphDB using various methods. Can be used to integrate with LLM agents.";
        this.version = "v1.0.0";
        this.url = url;
        this.definitions = definitions;
    }

    public OpenApiTools(String title, String description, String version, String url, List<OpenApiToolDefinition> definitions) {
        this.title = title;
        this.description = description;
        this.version = version;
        this.url = url;
        this.definitions = definitions;
    }

    public String getOpenapi() {
        return "3.1.0";
    }

    public Info getInfo() {
        return new Info();
    }

    public List<Map<String, Object>> getServers() {
        return List.of(Map.of("url", this.url));
    }

    public Map<String, OpenApiToolDefinition> getPaths() {
        return this.definitions.stream().collect(Collectors.toMap(OpenApiToolDefinition::getUrl, v -> v));
    }

    @JsonPropertyOrder(value={"title", "description", "version"})
    public class Info {
        public String getTitle() {
            return OpenApiTools.this.title;
        }

        public String getDescription() {
            return OpenApiTools.this.description;
        }

        public String getVersion() {
            return OpenApiTools.this.version;
        }
    }
}

