/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNullSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import java.util.Map;
import java.util.stream.StreamSupport;

class ToolSpecificationHelper {
    ToolSpecificationHelper() {
    }

    static JsonSchemaElement jsonNodeToJsonSchemaElement(JsonNode node) {
        if (node.has("anyOf")) {
            JsonAnyOfSchema.Builder anyOf = JsonAnyOfSchema.builder();
            JsonSchemaElement[] types = (JsonSchemaElement[])StreamSupport.stream(node.get("anyOf").spliterator(), false).map(ToolSpecificationHelper::jsonNodeToJsonSchemaElement).toArray(JsonSchemaElement[]::new);
            anyOf.anyOf(types);
            return anyOf.build();
        }
        JsonNode typeNode = node.get("type");
        if (typeNode == null || node.get("type").getNodeType() == JsonNodeType.STRING && node.get("type").asText().equals("object")) {
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder();
            if (node.has("description")) {
                builder.description(node.get("description").asText());
            } else if (node.has("title")) {
                builder.description(node.get("title").asText());
            }
            if (node.has("properties")) {
                ObjectNode propertiesObject = (ObjectNode)node.get("properties");
                for (Map.Entry property : propertiesObject.properties()) {
                    builder.addProperty((String)property.getKey(), ToolSpecificationHelper.jsonNodeToJsonSchemaElement((JsonNode)property.getValue()));
                }
            }
            if (node.has("required")) {
                builder.required(ToolSpecificationHelper.toStringArray((ArrayNode)node.get("required")));
            }
            if (node.has("additionalProperties")) {
                builder.additionalProperties(Boolean.valueOf(node.get("additionalProperties").asBoolean(false)));
            }
            return builder.build();
        }
        if (node.get("type").getNodeType() == JsonNodeType.STRING) {
            String nodeType = node.get("type").asText();
            if (nodeType.equals("string")) {
                if (node.has("enum")) {
                    JsonEnumSchema.Builder builder = JsonEnumSchema.builder();
                    if (node.has("description")) {
                        builder.description(node.get("description").asText());
                    } else if (node.has("title")) {
                        builder.description(node.get("title").asText());
                    }
                    builder.enumValues(ToolSpecificationHelper.toStringArray((ArrayNode)node.get("enum")));
                    return builder.build();
                }
                JsonStringSchema.Builder builder = JsonStringSchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                } else if (node.has("title")) {
                    builder.description(node.get("title").asText());
                }
                return builder.build();
            }
            if (nodeType.equals("number")) {
                JsonNumberSchema.Builder builder = JsonNumberSchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                } else if (node.has("title")) {
                    builder.description(node.get("title").asText());
                }
                return builder.build();
            }
            if (nodeType.equals("integer")) {
                JsonIntegerSchema.Builder builder = JsonIntegerSchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                } else if (node.has("title")) {
                    builder.description(node.get("title").asText());
                }
                return builder.build();
            }
            if (nodeType.equals("boolean")) {
                JsonBooleanSchema.Builder builder = JsonBooleanSchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                } else if (node.has("title")) {
                    builder.description(node.get("title").asText());
                }
                return builder.build();
            }
            if (nodeType.equals("array")) {
                JsonArraySchema.Builder builder = JsonArraySchema.builder();
                if (node.has("description")) {
                    builder.description(node.get("description").asText());
                } else if (node.has("title")) {
                    builder.description(node.get("title").asText());
                }
                builder.items(ToolSpecificationHelper.jsonNodeToJsonSchemaElement(node.get("items")));
                return builder.build();
            }
            throw new IllegalArgumentException("Unknown element type: " + nodeType);
        }
        JsonAnyOfSchema.Builder anyOf = JsonAnyOfSchema.builder();
        JsonSchemaElement[] types = (JsonSchemaElement[])StreamSupport.stream(node.get("type").spliterator(), false).map(ToolSpecificationHelper::toTypeElement).toArray(JsonSchemaElement[]::new);
        anyOf.anyOf(types);
        return anyOf.build();
    }

    private static JsonSchemaElement toTypeElement(JsonNode node) {
        if (!node.isTextual()) {
            throw new IllegalArgumentException(String.valueOf(node) + " is not a string");
        }
        switch (node.textValue()) {
            case "string": {
                return JsonStringSchema.builder().build();
            }
            case "number": {
                return JsonNumberSchema.builder().build();
            }
            case "integer": {
                return JsonIntegerSchema.builder().build();
            }
            case "boolean": {
                return JsonBooleanSchema.builder().build();
            }
            case "array": {
                return JsonArraySchema.builder().build();
            }
            case "object": {
                return JsonObjectSchema.builder().build();
            }
            case "null": {
                return new JsonNullSchema();
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + node.textValue());
    }

    private static String[] toStringArray(ArrayNode jsonArray) {
        String[] result = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            result[i] = jsonArray.get(i).asText();
        }
        return result;
    }
}

