/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class SimilaritySearchTool
extends BaseTool {
    public static final String QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.similarity.query.template";
    private static final String QUERY = Config.getProperty((String)"graphdb.ttyg.similarity.query.template", (String)"PREFIX sim: <http://www.ontotext.com/graphdb/similarity/>\nPREFIX sim-index: <http://www.ontotext.com/graphdb/similarity/instance/>\nDESCRIBE ?documentID WHERE {\n    ?search a sim-index:%s ;\n        sim:searchTerm %s ;\n        sim:documentResult ?result .\n    ?result sim:value ?documentID ;\n        sim:score ?score.\n    FILTER(?score >= %f)\n}");
    private static final String VALIDATION_QUERY = "PREFIX sim: <http://www.ontotext.com/graphdb/similarity/>\nPREFIX sim-index:<http://www.ontotext.com/graphdb/similarity/instance/>\nASK {\n    sim-index:%s sim:status ?status}";
    public static final String SIMILARITY_TOOL_DESCRIPTION = "Query GraphDB by similarity search and return a subgraph of RDF triples.";
    private String similarityIndex;
    private double resultThreshold = 0.6;
    private int limit;

    public SimilaritySearchTool() {
        super(ToolType.SIMILARITY_SEARCH);
    }

    @VisibleForTesting
    public SimilaritySearchTool(String similarityIndex, double resultThreshold, int limit) {
        this();
        this.setEnabled(true);
        this.setSimilarityIndex(similarityIndex);
        this.setResultThreshold(resultThreshold);
        this.setLimit(limit);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
        this.setSimilarityIndex(node.path("similarityIndex").asText());
        this.setResultThreshold(node.path("similarityIndexThreshold").asDouble());
        this.setLimit(node.path("maxNumberOfTriplesPerCall").asInt(0));
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
        gen.writeStringField("similarityIndex", this.getSimilarityIndex());
        gen.writeNumberField("similarityIndexThreshold", this.getResultThreshold());
        gen.writeNumberField("maxNumberOfTriplesPerCall", this.getLimit());
    }

    public String getSimilarityIndex() {
        return this.similarityIndex;
    }

    public void setSimilarityIndex(String similarityIndex) {
        this.similarityIndex = similarityIndex;
    }

    public double getResultThreshold() {
        return this.resultThreshold;
    }

    public void setResultThreshold(double resultThreshold) {
        this.resultThreshold = resultThreshold;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
        if (StringUtils.isBlank((CharSequence)this.similarityIndex)) {
            throw new ToolConfigException("Similarity method requires a similarity index value.");
        }
        if (!TurtleUtil.isValidPrefixedName((String)this.similarityIndex)) {
            throw new ToolConfigException("Similarity method index must be a valid local name: " + this.similarityIndex);
        }
        if (!agentRepository.connectionInstance().prepareBooleanQuery(SystemConfig.localeIndependentFormat((String)VALIDATION_QUERY, (Object[])new Object[]{this.similarityIndex})).evaluate()) {
            throw new ToolConfigException("Similarity method requires a valid similarity index.");
        }
    }

    @Override
    public String getDescription() {
        return SIMILARITY_TOOL_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        return ParameterDefinition.singleParameter("query", "Similarity search query");
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        return SystemConfig.localeIndependentFormat((String)QUERY, (Object[])new Object[]{this.similarityIndex, this.toSparqlLiteral(this.getRawQuery((Map)parameters)), this.resultThreshold});
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        return new ToolResponse(this.evaluateParsedQuery((Query)connection.prepareGraphQuery(this.getNativeQuery(parameters)), connection, this.limit));
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimilaritySearchTool)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimilaritySearchTool tool = (SimilaritySearchTool)o;
        return Double.compare(this.resultThreshold, tool.resultThreshold) == 0 && this.limit == tool.limit && Objects.equals(this.similarityIndex, tool.similarityIndex);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.similarityIndex);
        result = 31 * result + Double.hashCode(this.resultThreshold);
        result = 31 * result + this.limit;
        return result;
    }
}

