/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchConnectorService;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchDirectService;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class RetrievalSearchTool
extends BaseTool {
    private static final String RETRIEVAL_CLASSIC_PROPERTY = "graphdb.ttyg.retrieval.classic";
    public static final String RETRIEVAL_SEARCH_DESCRIPTION = "Query GraphDB by full-text search and return a textual representation of RDF triples.";
    private static final String DEFAULT_QUERY_TEMPLATE_RESOURCE = "/ttyg/retrieval_search/default_query_template.json";
    private static final String VALIDATION_QUERY = "PREFIX retr: <http://www.ontotext.com/connectors/retrieval#>\nPREFIX retr-index: <http://www.ontotext.com/connectors/retrieval/instance#>\nASK {\n    retr-index:%s retr:connectorStatus ?status\n}";
    private static final int DEFAULT_LIMIT = 10;
    private final RetrievalSearchService service;
    private String connectorInstance;
    private String queryTemplate;
    private int limit;

    public RetrievalSearchTool() {
        this(false);
    }

    @VisibleForTesting
    RetrievalSearchTool(boolean useConnectorDefault) {
        super(ToolType.RETRIEVAL_SEARCH);
        try (InputStream inputStream = this.getClass().getResourceAsStream(DEFAULT_QUERY_TEMPLATE_RESOURCE);){
            Objects.requireNonNull(inputStream, "Missing resource: /ttyg/retrieval_search/default_query_template.json");
            this.queryTemplate = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8).trim();
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Could not read default query template", e);
        }
        this.service = Config.getPropertyAsBoolean((String)RETRIEVAL_CLASSIC_PROPERTY, (boolean)useConnectorDefault) ? new RetrievalSearchConnectorService(this) : new RetrievalSearchDirectService(this);
    }

    @VisibleForTesting
    public RetrievalSearchTool(String connectorInstance, String queryTemplate, int limit) {
        this();
        this.setEnabled(true);
        this.setConnectorInstance(connectorInstance);
        this.setQueryTemplate(queryTemplate);
        this.setLimit(limit);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
        this.setConnectorInstance(node.path("retrievalConnectorInstance").asText());
        this.setQueryTemplate(node.path("queryTemplate").asText());
        this.setLimit(node.path("maxNumberOfTriplesPerCall").asInt(0));
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
        gen.writeStringField("retrievalConnectorInstance", this.getConnectorInstance());
        gen.writeStringField("queryTemplate", this.getQueryTemplate());
        gen.writeNumberField("maxNumberOfTriplesPerCall", this.getLimit());
    }

    public String getConnectorInstance() {
        return this.connectorInstance;
    }

    public void setConnectorInstance(String connectorInstance) {
        this.connectorInstance = connectorInstance;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void validate(ToolCallContext agentRepository) {
        if (StringUtils.isBlank((CharSequence)this.connectorInstance)) {
            throw new ToolConfigException("Retrieval method requires a connector instance value.");
        }
        if (!TurtleUtil.isValidPrefixedName((String)this.connectorInstance)) {
            throw new ToolConfigException("Retrieval method connector instance must be a valid local name: " + this.connectorInstance);
        }
        if (StringUtils.isBlank((CharSequence)this.queryTemplate)) {
            throw new ToolConfigException("Retrieval method requires a query template.");
        }
        if (!agentRepository.connectionInstance().prepareBooleanQuery(SystemConfig.localeIndependentFormat((String)VALIDATION_QUERY, (Object[])new Object[]{this.connectorInstance})).evaluate()) {
            throw new ToolConfigException("Retrieval method requires a valid retrieval connector instance.");
        }
        this.getParameterSchema();
    }

    @Override
    public String getDescription() {
        return RETRIEVAL_SEARCH_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        ParameterDefinition itemType = this.parseParameterDefinition(this.getParsedQueryTemplate(), "queries", null, Set.of("queries.query"));
        return ParameterDefinition.rootParameters(List.of(ParameterDefinition.arrayParameter("queries", "Array of queries to be processed", true, itemType)));
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        return this.service.getNativeQuery(parameters);
    }

    @Override
    public String getRawQuery(Map<String, Object> parameters) {
        return JSONUtil.toJSON(parameters);
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        return new ToolResponse(this.service.call(parameters, agentRepository));
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetrievalSearchTool)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RetrievalSearchTool tool = (RetrievalSearchTool)o;
        return this.limit == tool.limit && Objects.equals(this.connectorInstance, tool.connectorInstance) && Objects.equals(this.queryTemplate, tool.queryTemplate);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.connectorInstance);
        result = 31 * result + Objects.hashCode(this.queryTemplate);
        result = 31 * result + this.limit;
        return result;
    }

    @VisibleForTesting
    Map<String, Object> sanitizeParameters(Map<String, Object> parameters) {
        ParameterDefinition rootParameterDefinition = this.getParameterSchema();
        parameters = this.makeParametersEditable(parameters);
        List queries = parameters.getOrDefault("queries", List.of());
        for (Map query : queries) {
            Object filter = query.get("filter");
            if (filter instanceof Map) {
                String fixedDate;
                LinkedHashMap<String, String> newFilter = new LinkedHashMap<String, String>((Map)filter);
                newFilter.keySet().removeIf(k -> !this.hasFilterParameter(rootParameterDefinition, (String)k));
                if (newFilter.containsKey("start_date")) {
                    fixedDate = this.fixDate(newFilter.get("start_date").toString(), "start_date", false);
                    newFilter.put("start_date", fixedDate);
                }
                if (newFilter.containsKey("end_date")) {
                    fixedDate = this.fixDate(newFilter.get("end_date").toString(), "end_date", true);
                    newFilter.put("end_date", fixedDate);
                }
                if (newFilter.isEmpty()) {
                    query.remove("filter");
                } else {
                    query.put("filter", newFilter);
                }
            } else if (filter != null) {
                throw new IllegalArgumentException("Filter must be an object");
            }
            if (query.containsKey("top_k")) continue;
            query.put("top_k", this.limit > 0 ? this.limit : 10);
        }
        return parameters;
    }

    private Map<String, Object> makeParametersEditable(Map<String, Object> parameters) {
        parameters = new LinkedHashMap<String, Object>(parameters);
        List queries = ((List)parameters.get("queries")).stream().map(LinkedHashMap::new).collect(Collectors.toList());
        parameters.put("queries", queries);
        return new LinkedHashMap<String, Object>(parameters);
    }

    @VisibleForTesting
    String fixDate(String date, String field, boolean end) {
        if (date == null) {
            return null;
        }
        String origDate = date;
        try {
            String timePad;
            String string = timePad = end ? "T23:59:59Z" : "T00:00:00Z";
            if (((String)date).length() == 4) {
                date = (String)date + "-" + (end ? "12-31" : "01-01") + timePad;
            } else if (((String)date).length() == 7) {
                int padDay = 1;
                String[] dateParts = ((String)date).split("-", 2);
                if (end) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, Integer.parseInt(dateParts[0]));
                    cal.set(2, Integer.parseInt(dateParts[1]) - 1);
                    cal.set(5, 1);
                    padDay = cal.getActualMaximum(5);
                }
                date = SystemConfig.localeIndependentFormat((String)"%s-%02d%s", (Object[])new Object[]{date, padDay, timePad});
            } else if (((String)date).length() == 10) {
                date = (String)date + timePad;
            } else if (((String)date).length() == 19) {
                date = (String)date + "Z";
            }
            DateTimeFormatter.ISO_INSTANT.parse((CharSequence)date);
        }
        catch (NumberFormatException | DateTimeParseException e) {
            throw new IllegalArgumentException(SystemConfig.localeIndependentFormat((String)"Invalid date in filter '%s': %s", (Object[])new Object[]{field, origDate}));
        }
        return date;
    }

    private boolean hasFilterParameter(ParameterDefinition rootParameters, String name) {
        ParameterDefinition def = rootParameters.getChild("queries").getArrayTypeParameter();
        ParameterDefinition filter = def.getChild("filter");
        if (filter != null) {
            return filter.hasChild(name);
        }
        return false;
    }

    private ParameterDefinition parseParameterDefinition(JsonNode node, String field, String parentPath, Set<String> requiredFields) {
        String type;
        String thisPath = parentPath == null ? field : parentPath + "." + field;
        boolean required = requiredFields.contains(thisPath);
        List<String> enumValues = List.of();
        String title = null;
        String description = null;
        Object defaultValue = null;
        List<Object> children = List.of();
        if (node instanceof TextNode) {
            type = node.asText();
        } else if (node instanceof ObjectNode) {
            ObjectNode map = (ObjectNode)node;
            type = this.parseString((JsonNode)map, "type", field);
            if (type != null) {
                title = this.parseString((JsonNode)map, "title", field);
                description = this.parseString((JsonNode)map, "description", field);
                if ("object".equals(type)) {
                    ObjectNode properties = this.parseObject((JsonNode)map, "properties", field);
                    if (properties == null) {
                        throw new ToolConfigException("Missing properties for object field: " + field);
                    }
                    children = properties.properties().stream().map(e -> this.parseParameterDefinition((JsonNode)e.getValue(), (String)e.getKey(), thisPath, requiredFields)).collect(Collectors.toList());
                } else {
                    defaultValue = this.parseValue((JsonNode)map, "default", field);
                    enumValues = this.parseStringArray((JsonNode)map, "enum", field);
                    if (!type.equals("string") && !enumValues.isEmpty()) {
                        throw new ToolConfigException("Enum requires a string type for field: " + field);
                    }
                }
            } else {
                type = "object";
                children = map.properties().stream().map(e -> this.parseParameterDefinition((JsonNode)e.getValue(), (String)e.getKey(), thisPath, requiredFields)).collect(Collectors.toList());
            }
        } else {
            throw new ToolConfigException("Invalid query template");
        }
        List finalChildren = children;
        String childrenPrefix = thisPath + ".";
        requiredFields.stream().filter(f -> f.startsWith(childrenPrefix)).map(f -> f.substring(childrenPrefix.length())).filter(f -> !f.contains(".")).forEach(f -> {
            if (finalChildren.stream().noneMatch(c -> f.equals(c.name))) {
                throw new ToolConfigException("Missing required field in query template: " + f);
            }
        });
        return new ParameterDefinition(field, type, enumValues, title, description, defaultValue, required, children, null);
    }

    private Object parseValue(JsonNode node, String key, String field) {
        JsonNode value = node.get(key);
        if (value != null && !(value instanceof ValueNode)) {
            throw new ToolConfigException("Value for key " + key + " must be a scalar value, in field " + field);
        }
        return value == null ? null : JSONUtil.getObjectMapper().convertValue((Object)value, Object.class);
    }

    private String parseString(JsonNode node, String key, String field) {
        JsonNode value = node.get(key);
        if (value != null && !(value instanceof TextNode)) {
            throw new ToolConfigException("Value for key " + key + " must be a string, in field " + field);
        }
        return value == null ? null : value.asText();
    }

    private ObjectNode parseObject(JsonNode node, String key, String field) {
        JsonNode value = node.get(key);
        if (value != null && !(value instanceof ObjectNode)) {
            throw new ToolConfigException("Value for key " + key + " must be an object, in field " + field);
        }
        return (ObjectNode)value;
    }

    private List<String> parseStringArray(JsonNode node, String key, String field) {
        ArrayNode array = this.parseArray(node, key, field);
        if (array == null) {
            return List.of();
        }
        return (List)JSONUtil.getObjectMapper().convertValue((Object)array, (TypeReference)new TypeReference<List<String>>(this){});
    }

    private ArrayNode parseArray(JsonNode node, String key, String field) {
        JsonNode value = node.get(key);
        if (value != null && !(value instanceof ArrayNode)) {
            throw new ToolConfigException("Value for '" + key + "' must be an object or a string, in field " + field);
        }
        return (ArrayNode)value;
    }

    private JsonNode getParsedQueryTemplate() {
        try {
            return JSONUtil.readTree(this.queryTemplate);
        }
        catch (IllegalArgumentException e) {
            throw new ToolConfigException("Invalid JSON in query template.");
        }
    }

    static interface RetrievalSearchService {
        public String call(Map<String, Object> var1, ToolCallContext var2);

        public String getNativeQuery(Map<String, Object> var1);
    }
}

