/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ParameterDefinition {
    static final String ROOT_PARAMETERS_NAME = "parameters";
    @JsonIgnore
    public final String name;
    public final Map<String, ParameterDefinition> children;
    @JsonProperty(value="items")
    public final ParameterDefinition arrayTypeParameter;
    public final String type;
    public final String title;
    public final String description;
    @JsonProperty(value="enum")
    public final List<String> enumValues;
    @JsonProperty(value="default")
    public final Object defaultValue;
    @JsonIgnore
    public final boolean required;

    @JsonProperty(value="required")
    public List<String> getRequiredNames() {
        return this.children.entrySet().stream().filter(e -> ((ParameterDefinition)e.getValue()).required).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static ParameterDefinition rootParameters(List<ParameterDefinition> parameters) {
        return new ParameterDefinition(ROOT_PARAMETERS_NAME, "object", List.of(), null, null, null, false, parameters, null);
    }

    static ParameterDefinition arrayParameter(String name, String description, boolean required, ParameterDefinition itemParameter) {
        return new ParameterDefinition(name, "array", null, null, description, null, required, List.of(), itemParameter);
    }

    static ParameterDefinition singleParameter(String parameterName, String description) {
        return ParameterDefinition.rootParameters(List.of(new ParameterDefinition(parameterName, "string", List.of(), null, description, null, true, List.of(), null)));
    }

    ParameterDefinition(String name, String type, List<String> enumValues, String title, String description, Object defaultValue, boolean required, List<ParameterDefinition> children, ParameterDefinition arrayTypeParameter) {
        this.name = name;
        this.type = type;
        this.enumValues = enumValues;
        this.title = title;
        this.description = description;
        this.defaultValue = defaultValue;
        this.required = required;
        this.children = children.stream().collect(Collectors.toMap(c -> c.name, c -> c, (a, b) -> a, LinkedHashMap::new));
        this.arrayTypeParameter = arrayTypeParameter;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Map<String, ParameterDefinition> getChildren() {
        return "object".equals(this.type) ? this.children : null;
    }

    ParameterDefinition getChild(String name) {
        return this.children.get(name);
    }

    boolean hasChild(String name) {
        return this.children.containsKey(name);
    }

    ParameterDefinition getArrayTypeParameter() {
        return this.arrayTypeParameter;
    }

    protected String getName() {
        return this.name;
    }

    protected String getDescription() {
        return this.description;
    }

    protected String getType() {
        return this.type;
    }

    protected Boolean getRequired() {
        return this.required;
    }
}

