/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.ToolConfigException;
import com.ontotext.forest.gpt.ttyg.tools.BaseTool;
import com.ontotext.forest.gpt.ttyg.tools.ParameterDefinition;
import com.ontotext.forest.gpt.ttyg.tools.ToolResponse;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;
import com.ontotext.trree.util.IRIUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class AutocompleteIriDiscoveryTool
extends BaseTool {
    public static final String AUTOCOMPLETE_IRI_DISCOVERY_QUERY_TEMPLATE_PROPERTY = "graphdb.ttyg.autocomplete_iri.query.template";
    private static final String AUTOCOMPLETE_QUERY = Config.getProperty((String)"graphdb.ttyg.autocomplete_iri.query.template", (String)"PREFIX auto: <http://www.ontotext.com/plugins/autocomplete#>\nPREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>\nPREFIX spif: <http://spinrdf.org/spif#>\nSELECT ?iri ?label {\n    ?iri auto:query %s .\n    %s\n    OPTIONAL { ?iri rank:hasRDFRank ?rank }\n    OPTIONAL {\n        ?labelPred auto:labelConfig ?labelLangs .\n        ?labelLang spif:split (?labelLangs \", \") .\n        ?iri ?labelPred ?label .\n        FILTER(?labelLang = \"\" || langMatches(lang(?label), ?labelLang))\n    }\n}\nORDER BY DESC(?rank)");
    public static final String CHECK_ENABLED_AUTOCOMPLETE = "ASK WHERE { ?o <http://www.ontotext.com/plugins/autocomplete#enabled> ?s . }\n";
    public static final String RESULT_CLASS = "resultClass";
    public static final String QUERY = "query";
    public static final String AUTOCOMPLETE_IRI_DISCOVERY_DESCRIPTION = "Discover IRIs by searching their names and getting results in order of relevance leveraging GraphDB's Autocomplete index.";
    private int limit;

    public AutocompleteIriDiscoveryTool() {
        super(ToolType.AUTOCOMPLETE_IRI_DISCOVERY_SEARCH);
    }

    @VisibleForTesting
    public AutocompleteIriDiscoveryTool(int limit) {
        this();
        this.setEnabled(true);
        this.setLimit(limit);
    }

    @Override
    public void setFromLegacyUiObject(JsonNode node) {
        this.setEnabled(true);
        this.setLimit(node.path("limit").asInt());
    }

    @Override
    public void writeToLegacyUiObject(JsonGenerator gen) throws IOException {
        gen.writeStringField("method", this.getType().getLegacyUiMethodKey());
        gen.writeNumberField("limit", this.getLimit());
    }

    @Override
    public void validate(ToolCallContext agentRepository) throws ToolConfigException, RepositoryException {
        RepositoryConnection repositoryConnection = agentRepository.connectionInstance();
        if (!repositoryConnection.prepareBooleanQuery(CHECK_ENABLED_AUTOCOMPLETE).evaluate()) {
            throw new ToolConfigException("Autocomplete search method for IRI discovery requires autocomplete index of repository " + agentRepository.getRepositoryId() + " to be enabled.");
        }
    }

    @Override
    public String getDescription() {
        return AUTOCOMPLETE_IRI_DISCOVERY_DESCRIPTION;
    }

    @Override
    public ParameterDefinition getParameterSchema() {
        ParameterDefinition queryParam = new ParameterDefinition(QUERY, "string", List.of(), null, "Autocomplete for IRI discovery search query", null, true, List.of(), null);
        ParameterDefinition resultClassParam = new ParameterDefinition(RESULT_CLASS, "string", List.of(), null, "Filter results by class. Valid values are the exact URI of one class from the ontology.", null, false, List.of(), null);
        return ParameterDefinition.rootParameters(List.of(queryParam, resultClassParam));
    }

    @Override
    public String getNativeQuery(Map<String, Object> parameters) {
        this.validateTemplate();
        this.validateParameters(parameters);
        return SystemConfig.localeIndependentFormat((String)AUTOCOMPLETE_QUERY, (Object[])new Object[]{this.toSparqlLiteral(this.extractQuery(parameters)), this.extractResultClass(parameters)}).trim();
    }

    @Override
    public ToolResponse call(Map<String, Object> parameters, ToolCallContext agentRepository) {
        RepositoryConnection connection = agentRepository.connectionInstance();
        return new ToolResponse(this.evaluateParsedQuery((Query)connection.prepareTupleQuery(this.getNativeQuery(parameters)), connection, this.limit));
    }

    void validateTemplate() {
        if (!AUTOCOMPLETE_QUERY.contains("%s")) {
            throw new ToolConfigException("Query template must contain at least one '%s' placeholder for parameter substitution.");
        }
    }

    @Override
    public String getRawQuery(Map<String, Object> parameters) {
        this.validateParameters(parameters);
        return JSONUtil.toJSON(parameters);
    }

    private String extractQuery(Map<String, Object> parameters) {
        String arg;
        Object queryObj = parameters.get(QUERY);
        if (queryObj == null) {
            return "";
        }
        if (!(queryObj instanceof String) || (arg = (String)queryObj).isBlank()) {
            throw new IllegalArgumentException("QUERY parameter must be a non-empty String.");
        }
        return queryObj.toString();
    }

    private String extractResultClass(Map<String, Object> parameters) {
        String arg;
        Object resultClassObj = parameters.get(RESULT_CLASS);
        if (resultClassObj == null) {
            return "";
        }
        if (!(resultClassObj instanceof String) || (arg = (String)resultClassObj).isBlank()) {
            throw new IllegalArgumentException("RESULT_CLASS parameter must be a non-empty String.");
        }
        if (IRIUtil.isValidFullIri((String)arg)) {
            return "?iri a <" + arg + "> .";
        }
        throw new IllegalArgumentException("Encountered unexpected filter class parameter. " + arg + " should be a valid full IRI.");
    }

    private void validateParameters(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            throw new IllegalArgumentException("Parameters map cannot be null or empty.");
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutocompleteIriDiscoveryTool)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.limit == ((AutocompleteIriDiscoveryTool)o).limit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.limit;
        return result;
    }
}

