/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class JSONUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter PRETTY_PRINTER = OBJECT_MAPPER.writerWithDefaultPrettyPrinter();

    public static <T> T parseJSON(Path jsonFile, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonFile.toFile(), clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T parseJSON(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T parseJSON(String json, TypeReference<T> typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeRef);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Map<String, T> parseJSON(Path jsonFile) {
        return JSONUtil.parseJSON(jsonFile, Map.class);
    }

    public static <T> Map<String, T> parseJSON(String json) {
        return JSONUtil.parseJSON(json, Map.class);
    }

    public static String toJSON(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String prettyPrintJSON(Object object) {
        try {
            return PRETTY_PRINTER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode readTree(String string) {
        try {
            return OBJECT_MAPPER.readTree(string);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }
}

