/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AgentInstructions
extends ArrayList<Part> {
    private final Part baseInstructions = new Part("baseInstructions");
    private final Part additionalInstructions = new Part("additionalInstructions");
    private final Part sparqlInstructions = new Part("sparqlInstructions");
    private final Part ontologyIntroduction = new Part("ontologyIntroduction");
    private final Part ontology = new Part("ontology");

    public AgentInstructions() {
        this.addAll(List.of(this.baseInstructions, this.additionalInstructions, this.sparqlInstructions, this.ontologyIntroduction, this.ontology));
    }

    @JsonIgnore
    public String getBaseInstructions() {
        return this.baseInstructions.content;
    }

    public void setBaseInstructions(String baseInstructions) {
        this.baseInstructions.content = baseInstructions;
    }

    @JsonIgnore
    public String getAdditionalInstructions() {
        return this.additionalInstructions.content;
    }

    public void setAdditionalInstructions(String additionalInstructions) {
        this.additionalInstructions.content = additionalInstructions;
    }

    @JsonIgnore
    public String getSparqlInstructions() {
        return this.sparqlInstructions.content;
    }

    public void setSparqlInstructions(String sparqlInstructions) {
        this.sparqlInstructions.content = sparqlInstructions;
    }

    @JsonIgnore
    public String getOntologyIntroduction() {
        return this.ontologyIntroduction.content;
    }

    public void setOntologyIntroduction(String ontologyIntroduction) {
        this.ontologyIntroduction.content = ontologyIntroduction;
    }

    @JsonIgnore
    public String getOntology() {
        return this.ontology.content;
    }

    public void setOntology(String ontology) {
        this.ontology.content = ontology;
    }

    boolean hasOntology() {
        return StringUtils.isNotBlank((CharSequence)this.ontology.content);
    }

    public String assemble() {
        return this.stream().map(p -> p.content).filter(StringUtils::isNotBlank).collect(Collectors.joining("\n\n"));
    }

    public static class Part {
        @JsonProperty
        public final String type;
        @JsonProperty
        public String content;

        public Part(String type) {
            this.type = type;
            this.content = "";
        }

        @JsonProperty
        public int getSize() {
            return this.content == null ? 0 : this.content.length();
        }
    }
}

