/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.ttyg;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Splitter;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.ToolCallContext;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericClientException;
import com.ontotext.forest.gpt.ttyg.exceptions.GenericServerException;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.forest.gpt.ttyg.tools.ToolValueDeserializer;
import com.ontotext.graphdb.configs.SystemConfig;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfig {
    public static final int VERSION = 2;
    public static final int MAX_CHUNKS = 15;
    public static final int CHUNK_SIZE = 512;
    public static final int MAX_CONFIG_SIZE = 7680;
    public static int MAX_INSTRUCTIONS_SIZE = 256000;
    private static final String BASE_KEY = "graphdb.ttyg";
    private static final String CHUNKS_BASE_KEY = "graphdb.ttyg.";
    private static final Logger log = LoggerFactory.getLogger(AgentConfig.class);
    private String id;
    private String name;
    private String model;
    private double temperature;
    private double topP;
    private int contextSize;
    private CoreConfig coreConfig = new CoreConfig();
    private ExtendedConfig extendedConfig = new ExtendedConfig();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public void setTopP(double topP) {
        this.topP = topP;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public void setContextSize(int contextSize) {
        this.contextSize = contextSize;
    }

    public String getInstallationId() {
        return this.coreConfig.installationId;
    }

    public void setInstallationId(String installationId) {
        this.coreConfig.installationId = installationId;
    }

    public String getRepositoryId() {
        return this.coreConfig.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.coreConfig.repositoryId = repositoryId;
    }

    public String getFingerprint() {
        return this.extendedConfig.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.extendedConfig.fingerprint = fingerprint;
    }

    public String getBaseInstruction() {
        return this.extendedConfig.baseInstruction;
    }

    public void setBaseInstruction(String baseInstruction) {
        this.extendedConfig.baseInstruction = baseInstruction;
    }

    public String getUserInstruction() {
        return this.extendedConfig.userInstruction;
    }

    public void setUserInstruction(String userInstruction) {
        this.extendedConfig.userInstruction = userInstruction;
    }

    public int getVersion() {
        return this.coreConfig.version;
    }

    void setVersion(int version) {
        this.coreConfig.version = version;
    }

    protected void validateConfigSize(String extendedConfigJson) {
    }

    protected void validateInstructionsSize(String instructions, boolean hasOntology) {
    }

    public <T extends Tool> T getEnabledTool(ToolType type) {
        Tool config = this.getTools().get((Object)type);
        if (config == null) {
            throw new IllegalArgumentException("Unknown tool type: " + String.valueOf((Object)type));
        }
        if (!config.isEnabled()) {
            throw new IllegalArgumentException("Tool not enabled: " + String.valueOf((Object)type));
        }
        return (T)config;
    }

    public Map<ToolType, Tool> getTools() {
        return this.extendedConfig.tools;
    }

    public void setTools(Map<ToolType, Tool> tools) {
        this.extendedConfig.tools = new ToolMap(tools);
    }

    public Map<String, String> toMetadata() {
        String extendedConfigJson = JSONUtil.toJSON(this.extendedConfig);
        this.validateConfigSize(extendedConfigJson);
        List chunks = Splitter.fixedLength((int)512).splitToList((CharSequence)extendedConfigJson);
        this.coreConfig.numberOfChunks = chunks.size();
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put(BASE_KEY, JSONUtil.toJSON(this.coreConfig));
        for (int i = 0; i < chunks.size(); ++i) {
            String chunk = (String)chunks.get(i);
            metadata.put(CHUNKS_BASE_KEY + i, chunk);
        }
        return metadata;
    }

    public void setFromMetadata(Map<String, String> metadata) {
        this.coreConfig = this.parseCoreConfig(metadata);
        String fullJson = this.assembleExtendedConfigJson(metadata, this.coreConfig.numberOfChunks);
        try {
            this.extendedConfig = JSONUtil.parseJSON(fullJson, ExtendedConfig.class);
        }
        catch (IllegalArgumentException e) {
            log.warn("Standard agent configuration with id {} parsing from metadata failed, attempting to recover...", (Object)this.id);
            this.extendedConfig = this.recoverExtendedConfig(fullJson);
        }
    }

    private CoreConfig parseCoreConfig(Map<String, String> metadata) {
        String baseConfigValue = metadata.get(BASE_KEY);
        if (baseConfigValue == null) {
            throw new GenericServerException("Missing required property: graphdb.ttyg");
        }
        return JSONUtil.parseJSON(baseConfigValue, CoreConfig.class);
    }

    private String assembleExtendedConfigJson(Map<String, String> metadata, int numberOfChunks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfChunks; ++i) {
            String chunk = metadata.get(CHUNKS_BASE_KEY + i);
            if (chunk == null) {
                throw new GenericServerException("Missing required property: graphdb.ttyg." + i);
            }
            sb.append(chunk);
        }
        return sb.toString();
    }

    private ExtendedConfig recoverExtendedConfig(String fullJson) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(fullJson);
            this.cleanUnknownTools(rootNode);
            return (ExtendedConfig)objectMapper.treeToValue((TreeNode)rootNode, ExtendedConfig.class);
        }
        catch (Exception e) {
            throw new GenericServerException("Failed to parse metadata JSON", e);
        }
    }

    private void cleanUnknownTools(JsonNode rootNode) {
        JsonNode toolsNode = rootNode.get("tools");
        if (toolsNode != null && toolsNode.isObject()) {
            ObjectNode cleanedToolsNode = new ObjectMapper().createObjectNode();
            Iterator it = toolsNode.fields();
            while (it.hasNext()) {
                Map.Entry toolEntry = (Map.Entry)it.next();
                String toolName = (String)toolEntry.getKey();
                try {
                    ToolType.fromString(toolName);
                    cleanedToolsNode.set(toolName, (JsonNode)toolEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    log.warn("Skipping unknown tool type: {}", (Object)toolName);
                }
            }
            ((ObjectNode)rootNode).set("tools", (JsonNode)cleanedToolsNode);
        }
    }

    public void validate(ToolCallContext agentRepository) {
        if (this.getTools().entrySet().stream().noneMatch(e -> ((ToolType)((Object)((Object)e.getKey()))).isMainTool() && ((Tool)e.getValue()).isEnabled())) {
            throw new GenericClientException("At least one main query method must be set.");
        }
        this.getTools().forEach((type, tool) -> {
            if (tool.isEnabled()) {
                tool.validate(agentRepository);
            }
        });
    }

    public AgentInstructions toAgentInstructions(RepositoryConnection connection) {
        AgentInstructions agentInstructions = new AgentInstructions();
        agentInstructions.setBaseInstructions((String)StringUtils.defaultIfBlank((CharSequence)this.getBaseInstruction(), (CharSequence)SystemConfig.getAgentInstructions()));
        agentInstructions.setAdditionalInstructions(this.getUserInstruction());
        SPARQLQueryTool config = (SPARQLQueryTool)this.getTools().get((Object)ToolType.SPARQL_QUERY);
        if (config != null) {
            config.applyOntologyInstructions(agentInstructions, connection);
        }
        return agentInstructions;
    }

    public String toAssistantInstructions(RepositoryConnection connection) {
        AgentInstructions agentInstructions = this.toAgentInstructions(connection);
        String instructions = agentInstructions.assemble();
        this.validateInstructionsSize(instructions, agentInstructions.hasOntology());
        return instructions;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static class CoreConfig {
        int version = 2;
        String installationId;
        String repositoryId;
        int numberOfChunks;

        CoreConfig() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    static class ExtendedConfig {
        String fingerprint;
        String baseInstruction;
        String userInstruction;
        ToolMap tools = new ToolMap();

        ExtendedConfig() {
        }
    }

    @JsonDeserialize(contentUsing=ToolValueDeserializer.class)
    public static class ToolMap
    extends LinkedHashMap<ToolType, Tool> {
        public ToolMap() {
        }

        public ToolMap(Map<ToolType, Tool> map) {
            super(map);
        }
    }
}

