/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ontotext.forest.gpt.model.AssistantsInstructions;
import com.ontotext.forest.gpt.model.AssistantsRequestResponseBase;
import com.ontotext.forest.gpt.ttyg.tools.AutocompleteIriDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.FTSSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.IRIDiscoveryTool;
import com.ontotext.forest.gpt.ttyg.tools.RetrievalSearchTool;
import com.ontotext.forest.gpt.ttyg.tools.SPARQLQueryTool;
import com.ontotext.forest.gpt.ttyg.tools.SimilaritySearchTool;
import com.ontotext.forest.gpt.ttyg.transitional.ToolList;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.configs.SystemConfig;

public class AssistantsRequestDefaultValues
extends AssistantsRequestResponseBase {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String api;

    public AssistantsRequestDefaultValues() {
        this.setModel(SystemConfig.getDefaultLlmModel());
        this.setTemperature(0.7);
        this.setTopP(1.0);
        this.setContextSize(SystemConfig.getDefaultContextWindowSize());
        this.setInstructions(new AssistantsInstructions());
        this.assistantExtractionMethods = new ToolList();
        this.additionalExtractionMethods = new ToolList();
        this.setApi(Config.getProperty((String)"graphdb.llm.api", (String)"openai-assistants"));
        SPARQLQueryTool sparqlTool = new SPARQLQueryTool("http://example.com/ontology", "CONSTRUCT {\n    ?s ?p ?o\n} WHERE {\n    GRAPH <http://example.org/ontology> {\n        ?s ?p ?o\n    }\n}");
        this.assistantExtractionMethods.add(sparqlTool);
        FTSSearchTool ftsTool = new FTSSearchTool();
        this.assistantExtractionMethods.add(ftsTool);
        SimilaritySearchTool similarityTool = new SimilaritySearchTool();
        this.assistantExtractionMethods.add(similarityTool);
        RetrievalSearchTool retrievalTool = new RetrievalSearchTool();
        this.assistantExtractionMethods.add(retrievalTool);
        IRIDiscoveryTool iriDiscoveryTool = new IRIDiscoveryTool();
        this.additionalExtractionMethods.add(iriDiscoveryTool);
        AutocompleteIriDiscoveryTool autocompleteIriTool = new AutocompleteIriDiscoveryTool();
        this.additionalExtractionMethods.add(autocompleteIriTool);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return super.getId();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return super.getName();
    }

    @Override
    @JsonIgnore
    public String getRepositoryId() {
        return super.getRepositoryId();
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }
}

